/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.servlets;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URLDecoder;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.orion.internal.server.servlets.ServletResourceHandler;
import org.eclipse.orion.server.cf.TaskHandler;
import org.eclipse.orion.server.cf.jobs.CFJob;
import org.eclipse.orion.server.cf.objects.CFObject;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.osgi.util.NLS;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRESTHandler<T extends CFObject>
extends ServletResourceHandler<String> {
    private final Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.cf");
    protected ServletResourceHandler<IStatus> statusHandler;

    public AbstractRESTHandler(ServletResourceHandler<IStatus> statusHandler) {
        this.statusHandler = statusHandler;
    }

    protected abstract T buildResource(HttpServletRequest var1, String var2) throws CoreException;

    protected JSONObject extractJSONData(HttpServletRequest request) {
        try {
            JSONTokener tokener = new JSONTokener((Reader)new InputStreamReader((InputStream)request.getInputStream()));
            return new JSONObject(tokener);
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected JSONObject extractJSONData(String param) {
        try {
            return param != null ? new JSONObject(URLDecoder.decode(param, "UTF8")) : null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected CFJob handleGet(T resource, HttpServletRequest request, HttpServletResponse response, final String path) {
        return new CFJob(request, false){

            protected IStatus performJob() {
                String msg = NLS.bind((String)"Failed to handle request for {0}", (Object)path);
                return new ServerStatus(4, 501, msg, null);
            }
        };
    }

    protected CFJob handlePut(T resource, HttpServletRequest request, HttpServletResponse response, final String path) {
        return new CFJob(request, false){

            protected IStatus performJob() {
                String msg = NLS.bind((String)"Failed to handle request for {0}", (Object)path);
                return new ServerStatus(4, 501, msg, null);
            }
        };
    }

    protected CFJob handlePost(T resource, HttpServletRequest request, HttpServletResponse response, final String path) {
        return new CFJob(request, false){

            protected IStatus performJob() {
                String msg = NLS.bind((String)"Failed to handle request for {0}", (Object)path);
                return new ServerStatus(4, 501, msg, null);
            }
        };
    }

    protected CFJob handleDelete(T resource, HttpServletRequest request, HttpServletResponse response, final String path) {
        return new CFJob(request, false){

            protected IStatus performJob() {
                String msg = NLS.bind((String)"Failed to handle request for {0}", (Object)path);
                return new ServerStatus(4, 501, msg, null);
            }
        };
    }

    protected boolean handleNotExistingResource(HttpServletRequest request, HttpServletResponse response, String path) throws ServletException {
        String msg = NLS.bind((String)"Failed to handle request for {0}", (Object)path);
        ServerStatus status = new ServerStatus(4, 404, msg, null);
        return this.statusHandler.handleRequest(request, response, (Object)status);
    }

    protected boolean handleConflictingResource(HttpServletRequest request, HttpServletResponse response, String path) throws ServletException {
        String msg = NLS.bind((String)"Failed to handle request for {0}", (Object)path);
        ServerStatus status = new ServerStatus(4, 409, msg, null);
        return this.statusHandler.handleRequest(request, response, (Object)status);
    }

    public boolean handleRequest(HttpServletRequest request, HttpServletResponse response, String path) throws ServletException {
        try {
            T resource = this.buildResource(request, path);
            switch (AbstractRESTHandler.getMethod((HttpServletRequest)request)) {
                case GET: {
                    CFJob getJob = this.handleGet(resource, request, response, path);
                    return TaskHandler.handleTaskJob(request, response, getJob, this.statusHandler);
                }
                case PUT: {
                    CFJob putJob = this.handlePut(resource, request, response, path);
                    return TaskHandler.handleTaskJob(request, response, putJob, this.statusHandler);
                }
                case POST: {
                    CFJob postJob = this.handlePost(resource, request, response, path);
                    return TaskHandler.handleTaskJob(request, response, postJob, this.statusHandler);
                }
                case DELETE: {
                    CFJob deleteJob = this.handleDelete(resource, request, response, path);
                    return TaskHandler.handleTaskJob(request, response, deleteJob, this.statusHandler);
                }
            }
            return false;
        }
        catch (Exception e) {
            String msg = NLS.bind((String)"Failed to handle request for {0}", (Object)path);
            ServerStatus status = new ServerStatus(4, 500, msg, (Throwable)e);
            this.logger.error(msg, (Throwable)e);
            return this.statusHandler.handleRequest(request, response, (Object)status);
        }
    }
}

