/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.user.securestorage;

import org.eclipse.orion.internal.server.user.securestorage.SecureStorageCredentialsService;
import org.eclipse.orion.internal.server.user.securestorage.SecureStorageUserProfileService;
import org.eclipse.orion.server.core.OrionConfiguration;
import org.eclipse.orion.server.user.profile.IOrionUserProfileService;
import org.eclipse.orion.server.useradmin.IOrionCredentialsService;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator {
    public static final String PI_USER_SECURESTORAGE = "org.eclipse.orion.server.user.securestorage";
    public static final String ORION_STORAGE_PASSWORD = "orion.storage.password";
    static BundleContext bundleContext;
    private ServiceRegistration<IOrionCredentialsService> userCredentialsService;
    private ServiceRegistration<IOrionUserProfileService> userProfileService;

    public static BundleContext getContext() {
        return bundleContext;
    }

    public void start(BundleContext bundleContext) throws Exception {
        String metastore = OrionConfiguration.getMetaStorePreference();
        if ("legacy".equals(metastore)) {
            Activator.bundleContext = bundleContext;
            Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.config");
            this.userCredentialsService = bundleContext.registerService(IOrionCredentialsService.class, (Object)new SecureStorageCredentialsService(), null);
            logger.debug("Started legacy user credentials service.");
            this.userProfileService = bundleContext.registerService(IOrionUserProfileService.class, (Object)new SecureStorageUserProfileService(), null);
            logger.debug("Started legacy user profile service.");
        }
    }

    public void stop(BundleContext bundleContext) throws Exception {
        if (this.userCredentialsService != null) {
            this.userCredentialsService.unregister();
        }
        if (this.userProfileService != null) {
            this.userProfileService.unregister();
        }
        Activator.bundleContext = null;
    }
}

