/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.core.metastore;

import java.io.File;
import org.eclipse.orion.internal.server.core.metastore.SimpleMetaStoreUtil;
import org.eclipse.orion.server.core.metastore.IMetaStore;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class SimpleMetaStore
implements IMetaStore {
    public static final int NO_ORION_VERSION = -1;
    public static final String ORION_VERSION = "OrionVersion";
    public static final String PROJECT = "project";
    public static final String ROOT = "metastore";
    public static final String USER = "user";
    public static final String WORKSPACE = "workspace";
    private File rootLocation = null;

    public static int getOrionVersion(File testRootLocation) {
        int version = -1;
        JSONObject jsonObject = SimpleMetaStoreUtil.readMetaFile(testRootLocation, ROOT);
        try {
            if (jsonObject != null && jsonObject.has(ORION_VERSION)) {
                version = jsonObject.getInt(ORION_VERSION);
            }
        }
        catch (JSONException jSONException) {
            throw new RuntimeException("SimpleMetaStore.initializeMetaStore: could not read MetaStore.");
        }
        return version;
    }

    public SimpleMetaStore(File rootLocation) {
        this.rootLocation = rootLocation;
        this.initializeMetaStore(rootLocation);
    }

    public File getRootLocation() {
        return this.rootLocation;
    }

    protected abstract void initializeMetaStore(File var1);
}

