/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.core.metastore;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import org.eclipse.orion.internal.server.core.metastore.SimpleMetaStore;
import org.eclipse.orion.internal.server.core.metastore.SimpleMetaStoreUtil;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleMetaStoreMigrationV2 {
    private static final String LEGACY_METADATA_DIR = "/.metadata/.plugins/org.eclipse.orion.server.core/.settings/";
    private static final String SECURESTORAGE_DIR = "/.metadata/.plugins/org.eclipse.orion.server.user.securestorage";
    private PrintStream migrationLog;

    private void deleteFile(File parentFile) {
        if (parentFile.isDirectory()) {
            File[] allFiles = parentFile.listFiles();
            if (allFiles.length == 0) {
                parentFile.delete();
            } else {
                File[] fileArray = allFiles;
                int n = allFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    this.deleteFile(file);
                    ++n2;
                }
                parentFile.delete();
            }
        } else {
            parentFile.delete();
        }
    }

    public void doMigration(File rootLocation) {
        File orionLegacyPrefs;
        Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.config");
        logger.info("Starting simple storage migration.");
        this.migrationLogOpen(rootLocation);
        this.migrationLogPrint("Migrating MetaStore from simple to simple2.");
        this.updateOrionVersion(rootLocation, "metastore");
        File rootFile = SimpleMetaStoreUtil.retrieveMetaFile(rootLocation, "metastore");
        File[] files = rootLocation.listFiles();
        int i = 0;
        while (i < files.length) {
            File next = files[i];
            if (!next.getName().equals(rootFile.getName()) && !next.getName().equals(".metadata")) {
                if (next.isDirectory() && next.getName().length() == 2) {
                    this.updateOrganizationalFolder(next);
                } else {
                    this.migrationLogPrint("INFO: workspace root contains invalid metadata: deleted orphan folder " + next.toString());
                    this.deleteFile(next);
                }
            }
            ++i;
        }
        File secureStorage = new File(rootLocation, SECURESTORAGE_DIR);
        if (secureStorage.exists()) {
            this.migrationLogPrint("INFO: deleted legacy secure storage folder: " + secureStorage.toString());
            this.deleteFile(secureStorage);
        }
        if ((orionLegacyPrefs = new File(rootLocation, LEGACY_METADATA_DIR)).exists()) {
            this.migrationLogPrint("INFO: deleted legacy metadata storage folder: " + orionLegacyPrefs.toString());
            this.deleteFile(orionLegacyPrefs);
        }
        this.migrationLogClose();
        logger.info("Completed simple storage migration.");
    }

    public boolean isMigrationRequired(File rootLocation) {
        return SimpleMetaStore.getOrionVersion(rootLocation) == 4;
    }

    private void migrationLogClose() {
        this.migrationLog.close();
    }

    private void migrationLogOpen(File workspaceRoot) {
        try {
            File metadataFolder = new File(workspaceRoot, ".metadata");
            File logFile = new File(metadataFolder, "migration2.log");
            FileOutputStream stream = new FileOutputStream(logFile);
            Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.config");
            logger.info("Simple storage version two migration log is at " + logFile.getAbsolutePath());
            this.migrationLog = new PrintStream(stream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new RuntimeException("SimpleMetaStoreMigration.migrationLogOpen: could not create migration log.");
        }
    }

    private void migrationLogPrint(String message) {
        this.migrationLog.println(message);
        Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.config");
        logger.debug(message);
    }

    private void moveProjectJsonFile(File folder, String projectName) {
        File userMetaFolder = folder.getParentFile();
        JSONObject projectMetaFile = SimpleMetaStoreUtil.readMetaFile(folder, projectName);
        File newProjectMetaFile = SimpleMetaStoreUtil.retrieveMetaFile(userMetaFolder, projectName);
        if (newProjectMetaFile.exists()) {
            this.migrationLogPrint("ERROR: duplicate project metadata file at " + newProjectMetaFile.toString());
            return;
        }
        SimpleMetaStoreUtil.createMetaFile(userMetaFolder, projectName, projectMetaFile);
        this.migrationLogPrint("Created project MetaData file: " + newProjectMetaFile.getAbsolutePath());
        File oldProjectMetaFile = SimpleMetaStoreUtil.retrieveMetaFile(folder, projectName);
        SimpleMetaStoreUtil.deleteMetaFile(folder, projectName);
        this.migrationLogPrint("Deleted old workspace MetaData file: " + oldProjectMetaFile.getAbsolutePath());
    }

    private String moveWorkspaceJsonFile(File folder) {
        File newWorkspaceMetaFile;
        String workspaceId;
        JSONObject workspaceMetaData;
        File parent;
        block5: {
            block4: {
                try {
                    parent = folder.getParentFile();
                    File workspaceMetaFile = SimpleMetaStoreUtil.retrieveMetaFile(folder, "workspace");
                    workspaceMetaData = SimpleMetaStoreUtil.readMetaFile(folder, "workspace");
                    if (workspaceMetaData.has("UniqueId")) break block4;
                    this.migrationLogPrint("ERROR: workspace metadata is missing UniqueId " + workspaceMetaFile.toString());
                    return null;
                }
                catch (JSONException e) {
                    throw new RuntimeException("SimpleMetaStoreMigrationV2: could not update file: " + e.getLocalizedMessage());
                }
            }
            workspaceId = workspaceMetaData.getString("UniqueId");
            newWorkspaceMetaFile = SimpleMetaStoreUtil.retrieveMetaFile(parent, workspaceId);
            if (!newWorkspaceMetaFile.exists()) break block5;
            this.migrationLogPrint("ERROR: duplicate workspace metadata file at " + newWorkspaceMetaFile.toString());
            return null;
        }
        SimpleMetaStoreUtil.createMetaFile(parent, workspaceId, workspaceMetaData);
        this.migrationLogPrint("Created workspace MetaData file: " + newWorkspaceMetaFile.getAbsolutePath());
        File oldWorkspaceMetaFile = SimpleMetaStoreUtil.retrieveMetaFile(folder, "workspace");
        SimpleMetaStoreUtil.deleteMetaFile(folder, "workspace");
        this.migrationLogPrint("Deleted old workspace MetaData file: " + oldWorkspaceMetaFile.getAbsolutePath());
        return workspaceId;
    }

    private void updateOrganizationalFolder(File folder) {
        File[] files = folder.listFiles();
        int i = 0;
        while (i < files.length) {
            File next = files[i];
            if (next.isDirectory()) {
                this.updateUserFolder(next);
            } else {
                this.migrationLogPrint("INFO: organizational folder contains invalid metadata: deleted orphan file " + next.toString());
                this.deleteFile(next);
            }
            ++i;
        }
    }

    private void updateOrionVersion(File parent, String name) {
        try {
            JSONObject jsonObject = SimpleMetaStoreUtil.readMetaFile(parent, name);
            jsonObject.put("OrionVersion", 6);
            SimpleMetaStoreUtil.updateMetaFile(parent, name, jsonObject);
            File metaFile = SimpleMetaStoreUtil.retrieveMetaFile(parent, name);
            this.migrationLogPrint("Updated Orion version in MetaData file: " + metaFile.getAbsolutePath());
        }
        catch (JSONException e) {
            throw new RuntimeException("SimpleMetaStoreMigrationV2: could not update file: " + e.getLocalizedMessage());
        }
    }

    private void updateUserFolder(File folder) {
        if (!SimpleMetaStoreUtil.isMetaFile(folder, "user")) {
            this.migrationLogPrint("INFO: user folder contains invalid metadata: deleted orphan folder " + folder.toString());
            this.deleteFile(folder);
            return;
        }
        this.migrationLogPrint("Processing user: " + folder.getName());
        this.updateOrionVersion(folder, "user");
        File userMetaFile = SimpleMetaStoreUtil.retrieveMetaFile(folder, "user");
        File[] files = folder.listFiles();
        int i = 0;
        while (i < files.length) {
            File next = files[i];
            if (!next.getName().equals(userMetaFile.getName())) {
                if (next.isDirectory()) {
                    this.updateWorkspaceFolder(next);
                } else {
                    this.migrationLogPrint("INFO: user folder contains invalid metadata: orphan orphan file " + next.toString());
                    this.deleteFile(next);
                }
            }
            ++i;
        }
    }

    private void updateWorkspaceFolder(File folder) {
        try {
            if (!SimpleMetaStoreUtil.isMetaFile(folder, "workspace")) {
                this.migrationLogPrint("INFO: workspace folder contains invalid metadata: deleted orphan folder " + folder.toString());
                this.deleteFile(folder);
                return;
            }
            this.updateOrionVersion(folder, "workspace");
            String workspaceId = this.moveWorkspaceJsonFile(folder);
            if (workspaceId == null) {
                return;
            }
            File workspaceMetaFile = SimpleMetaStoreUtil.retrieveMetaFile(folder.getParentFile(), workspaceId);
            JSONObject jsonObject = SimpleMetaStoreUtil.readMetaFile(folder.getParentFile(), workspaceId);
            if (!jsonObject.has("ProjectNames")) {
                this.migrationLogPrint("ERROR: workspace metadata is missing ProjectNames " + workspaceMetaFile.toString());
                return;
            }
            JSONArray projectNames = jsonObject.getJSONArray("ProjectNames");
            ArrayList<String> projectNameList = new ArrayList<String>();
            int i = 0;
            while (i < projectNames.length()) {
                projectNameList.add(projectNames.getString(i));
                ++i;
            }
            File[] files = folder.listFiles();
            int i2 = 0;
            while (i2 < files.length) {
                File next = files[i2];
                if (!next.getName().equals(workspaceMetaFile.getName())) {
                    if (next.isDirectory()) {
                        if (!projectNameList.contains(next.getName())) {
                            this.migrationLogPrint("INFO: workspace folder contains invalid metadata: deleted orphan project folder " + next.toString());
                            this.deleteFile(next);
                        }
                    } else if (next.isFile()) {
                        if (next.getName().endsWith(".json")) {
                            String name = next.getName().substring(0, next.getName().length() - ".json".length());
                            if (!projectNameList.contains(name)) {
                                this.migrationLogPrint("INFO: workspace folder contains invalid metadata: deleted orphan project file " + next.toString());
                                this.deleteFile(next);
                            } else {
                                this.updateOrionVersion(folder, name);
                                this.moveProjectJsonFile(folder, name);
                            }
                        } else {
                            this.migrationLogPrint("INFO: workspace folder contains invalid metadata: deleted orphan file " + next.toString());
                            this.deleteFile(next);
                        }
                    } else {
                        this.migrationLogPrint("INFO: workspace folder contains invalid metadata: deleted orphan file " + next.toString());
                        this.deleteFile(next);
                    }
                }
                ++i2;
            }
        }
        catch (JSONException e) {
            throw new RuntimeException("SimpleMetaStoreMigrationV2: could not update file: " + e.getLocalizedMessage());
        }
    }
}

