/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.commands;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.orion.server.cf.commands.AbstractRevertableCFCommand;
import org.eclipse.orion.server.cf.commands.AttachRouteCommand;
import org.eclipse.orion.server.cf.commands.CreateRouteCommand;
import org.eclipse.orion.server.cf.commands.FindRouteCommand;
import org.eclipse.orion.server.cf.commands.GetDomainsCommand;
import org.eclipse.orion.server.cf.manifest.v2.InvalidAccessException;
import org.eclipse.orion.server.cf.manifest.v2.ManifestParseTree;
import org.eclipse.orion.server.cf.objects.App;
import org.eclipse.orion.server.cf.objects.Target;
import org.eclipse.orion.server.cf.utils.MultiServerStatus;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.osgi.util.NLS;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BindRouteCommand
extends AbstractRevertableCFCommand {
    private final Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.cf");
    private String commandName;
    private String appDomain;
    private String domainName;
    private JSONObject route;
    private boolean noRoute;

    public JSONObject getRoute() {
        return this.route;
    }

    public String getAppDomain() {
        return this.appDomain;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public BindRouteCommand(Target target, App app) {
        super(target, app);
        Object[] bindings = new String[]{app.getName(), app.getGuid()};
        this.commandName = NLS.bind((String)"Bind a new route to application {1} (guid: {2})", (Object[])bindings);
    }

    @Override
    protected ServerStatus _doIt() {
        MultiServerStatus status = new MultiServerStatus();
        try {
            if (this.noRoute) {
                return status;
            }
            GetDomainsCommand getDomains = new GetDomainsCommand(this.target);
            ServerStatus jobStatus = (ServerStatus)getDomains.doIt();
            status.add(jobStatus);
            if (!jobStatus.isOK()) {
                return this.revert(status);
            }
            JSONObject domains = jobStatus.getJsonData();
            if (domains.getInt("total_results") < 1) {
                status.add(new ServerStatus(4, 400, "Failed to find available domains in target", null));
                return this.revert(status);
            }
            String domainGUID = null;
            if (!this.appDomain.isEmpty()) {
                int resources = domains.getJSONArray("resources").length();
                int k = 0;
                while (k < resources) {
                    JSONObject resource = domains.getJSONArray("resources").getJSONObject(k);
                    String tmpDomainName = resource.getJSONObject("entity").getString("name");
                    if (this.appDomain.equals(tmpDomainName)) {
                        domainGUID = resource.getJSONObject("metadata").getString("guid");
                        this.domainName = tmpDomainName;
                        break;
                    }
                    ++k;
                }
                if (domainGUID == null) {
                    String msg = NLS.bind((String)"Failed to find domain {0} in target", (Object)this.appDomain);
                    status.add(new ServerStatus(4, 400, msg, null));
                    return this.revert(status);
                }
            } else {
                JSONObject resource = domains.getJSONArray("resources").getJSONObject(0);
                this.domainName = resource.getJSONObject("entity").getString("name");
                domainGUID = resource.getJSONObject("metadata").getString("guid");
            }
            String routeGUID = null;
            FindRouteCommand findRouteCommand = new FindRouteCommand(this.target, this.application, domainGUID);
            jobStatus = (ServerStatus)findRouteCommand.doIt();
            status.add(jobStatus);
            if (jobStatus.isOK()) {
                this.route = jobStatus.getJsonData();
                routeGUID = this.route.getJSONObject("metadata").getString("guid");
                AttachRouteCommand attachRoute = new AttachRouteCommand(this.target, this.application, routeGUID);
                jobStatus = (ServerStatus)attachRoute.doIt();
                status.add(jobStatus);
                if (jobStatus.isOK()) {
                    return status;
                }
                String msg = NLS.bind((String)"The host {0} is already used in another space.", (Object)findRouteCommand.getAppHost());
                status.add(new ServerStatus(4, 409, msg, null));
                return status;
            }
            CreateRouteCommand createRoute = new CreateRouteCommand(this.target, this.application, domainGUID);
            jobStatus = (ServerStatus)createRoute.doIt();
            status.add(jobStatus);
            if (!jobStatus.isOK()) {
                return this.revert(status);
            }
            this.route = jobStatus.getJsonData();
            routeGUID = this.route.getJSONObject("metadata").getString("guid");
            AttachRouteCommand attachRoute = new AttachRouteCommand(this.target, this.application, routeGUID);
            jobStatus = (ServerStatus)attachRoute.doIt();
            status.add(jobStatus);
            if (!jobStatus.isOK()) {
                return this.revert(status);
            }
            return status;
        }
        catch (Exception e) {
            String msg = NLS.bind((String)"An error occured when performing operation {0}", (Object)this.commandName);
            this.logger.error(msg, (Throwable)e);
            status.add(new ServerStatus(4, 500, msg, (Throwable)e));
            return this.revert(status);
        }
    }

    @Override
    protected IStatus validateParams() {
        try {
            ManifestParseTree manifest = this.application.getManifest();
            ManifestParseTree app = manifest.get("applications").get(0);
            ManifestParseTree domainNode = app.getOpt("domain");
            this.appDomain = domainNode != null ? domainNode.getValue() : "";
            ManifestParseTree noRouteNode = app.getOpt("no-route");
            this.noRoute = noRouteNode != null ? Boolean.parseBoolean(noRouteNode.getValue()) : false;
            return Status.OK_STATUS;
        }
        catch (InvalidAccessException e) {
            return this.revert(new MultiServerStatus(new ServerStatus(4, 400, e.getMessage(), null)));
        }
    }
}

