/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.commands;

import java.net.URI;
import java.net.URL;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.orion.server.cf.commands.AbstractRevertableCFCommand;
import org.eclipse.orion.server.cf.manifest.v2.InvalidAccessException;
import org.eclipse.orion.server.cf.manifest.v2.ManifestParseTree;
import org.eclipse.orion.server.cf.objects.App;
import org.eclipse.orion.server.cf.objects.Target;
import org.eclipse.orion.server.cf.utils.HttpUtil;
import org.eclipse.orion.server.cf.utils.MultiServerStatus;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.osgi.util.NLS;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BindServicesCommand
extends AbstractRevertableCFCommand {
    private final Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.cf");
    private String commandName;

    public BindServicesCommand(Target target, App app) {
        super(target, app);
        Object[] bindings = new String[]{app.getName(), app.getGuid()};
        this.commandName = NLS.bind((String)"Bind new services to application {1} (guid: {2})", (Object[])bindings);
    }

    @Override
    protected ServerStatus _doIt() {
        MultiServerStatus status = new MultiServerStatus();
        try {
            URI targetURI = URIUtil.toURI((URL)this.target.getUrl());
            ManifestParseTree manifest = this.application.getManifest();
            ManifestParseTree app = manifest.get("applications").get(0);
            if (app.has("services")) {
                String spaceGuid;
                int version;
                URI servicesURI = targetURI.resolve("/v2/services");
                GetMethod getServicesMethod = new GetMethod(servicesURI.toString());
                HttpUtil.configureHttpMethod((HttpMethod)getServicesMethod, this.target);
                getServicesMethod.setQueryString("inline-relations-depth=1");
                ServerStatus jobStatus = HttpUtil.executeMethod((HttpMethod)getServicesMethod);
                status.add(jobStatus);
                if (!jobStatus.isOK()) {
                    return this.revert(status);
                }
                JSONObject resp = jobStatus.getJsonData();
                JSONArray servicesJSON = resp.getJSONArray("resources");
                ManifestParseTree services = app.getOpt("services");
                if (services == null) {
                    return status;
                }
                int n = version = services.isList() ? 6 : 2;
                if (version == 2) {
                    spaceGuid = this.target.getSpace().getGuid();
                    URI serviceInstancesURI2 = targetURI.resolve("/v2/spaces/" + spaceGuid + "/service_instances");
                    for (ManifestParseTree service : services.getChildren()) {
                        String serviceName = service.getLabel();
                        String nameService = "name:" + serviceName;
                        NameValuePair[] pa = new NameValuePair[]{new NameValuePair("return_user_provided_service_instance", "false"), new NameValuePair("q", nameService), new NameValuePair("inline-relations-depth", "2")};
                        GetMethod getServiceMethod = new GetMethod(serviceInstancesURI2.toString());
                        getServiceMethod.setQueryString(pa);
                        HttpUtil.configureHttpMethod((HttpMethod)getServiceMethod, this.target);
                        jobStatus = HttpUtil.executeMethod((HttpMethod)getServiceMethod);
                        status.add(jobStatus);
                        if (!jobStatus.isOK()) {
                            return this.revert(status);
                        }
                        resp = jobStatus.getJsonData();
                        String serviceInstanceGUID = null;
                        JSONArray respArray = resp.getJSONArray("resources");
                        int i = 0;
                        while (i < respArray.length()) {
                            JSONObject str;
                            JSONObject o = respArray.optJSONObject(i);
                            if (o != null && (str = o.optJSONObject("metadata")) != null) {
                                serviceInstanceGUID = str.getString("guid");
                                break;
                            }
                            ++i;
                        }
                        if (serviceInstanceGUID == null) {
                            ManifestParseTree serviceType = service.getOpt("type");
                            if (serviceType == null) {
                                serviceType = service.get("label");
                            }
                            ManifestParseTree provider = service.get("provider");
                            ManifestParseTree plan = service.get("plan");
                            String servicePlanGUID = this.findServicePlanGUID(serviceType.getValue(), provider.getValue(), plan.getValue(), servicesJSON);
                            if (servicePlanGUID == null) {
                                Object[] bindings = new String[]{serviceName, serviceType.getValue(), plan.getValue()};
                                String msg = NLS.bind((String)"Could not find service instance {0} nor service {1} with plan {2} in target.", (Object[])bindings);
                                status.add(new ServerStatus(4, 400, msg, null));
                                return this.revert(status);
                            }
                            URI serviceInstancesURI = targetURI.resolve("/v2/service_instances");
                            PostMethod createServiceMethod = new PostMethod(serviceInstancesURI.toString());
                            HttpUtil.configureHttpMethod((HttpMethod)createServiceMethod, this.target);
                            JSONObject createServiceRequest = new JSONObject();
                            createServiceRequest.put("space_guid", (Object)this.target.getSpace().getCFJSON().getJSONObject("metadata").getString("guid"));
                            createServiceRequest.put("name", (Object)serviceName);
                            createServiceRequest.put("service_plan_guid", (Object)servicePlanGUID);
                            createServiceMethod.setRequestEntity((RequestEntity)new StringRequestEntity(createServiceRequest.toString(), "application/json", "utf-8"));
                            jobStatus = HttpUtil.executeMethod((HttpMethod)createServiceMethod);
                            status.add(jobStatus);
                            if (!jobStatus.isOK()) {
                                return this.revert(status);
                            }
                            resp = jobStatus.getJsonData();
                            serviceInstanceGUID = resp.getJSONObject("metadata").getString("guid");
                        }
                        URI serviceBindingsURI = targetURI.resolve("/v2/service_bindings");
                        PostMethod bindServiceMethod = new PostMethod(serviceBindingsURI.toString());
                        HttpUtil.configureHttpMethod((HttpMethod)bindServiceMethod, this.target);
                        JSONObject bindServiceRequest = new JSONObject();
                        bindServiceRequest.put("app_guid", (Object)this.application.getGuid());
                        bindServiceRequest.put("service_instance_guid", (Object)serviceInstanceGUID);
                        bindServiceMethod.setRequestEntity((RequestEntity)new StringRequestEntity(bindServiceRequest.toString(), "application/json", "utf-8"));
                        jobStatus = HttpUtil.executeMethod((HttpMethod)bindServiceMethod);
                        status.add(jobStatus);
                        if (jobStatus.isOK()) continue;
                        return this.revert(status);
                    }
                }
                if (version == 6) {
                    spaceGuid = this.target.getSpace().getGuid();
                    URI serviceInstancesURI = targetURI.resolve("/v2/spaces/" + spaceGuid + "/service_instances");
                    for (ManifestParseTree service : services.getChildren()) {
                        String nameService = service.getValue();
                        NameValuePair[] pa = new NameValuePair[]{new NameValuePair("return_user_provided_service_instance", "true"), new NameValuePair("q", "name:" + nameService), new NameValuePair("inline-relations-depth", "2")};
                        GetMethod getServiceMethod = new GetMethod(serviceInstancesURI.toString());
                        getServiceMethod.setQueryString(pa);
                        HttpUtil.configureHttpMethod((HttpMethod)getServiceMethod, this.target);
                        jobStatus = HttpUtil.executeMethod((HttpMethod)getServiceMethod);
                        status.add(jobStatus);
                        if (!jobStatus.isOK()) {
                            return this.revert(status);
                        }
                        resp = jobStatus.getJsonData();
                        String serviceInstanceGUID = null;
                        JSONArray respArray = resp.getJSONArray("resources");
                        int i = 0;
                        while (i < respArray.length()) {
                            JSONObject str;
                            JSONObject o = respArray.optJSONObject(i);
                            if (o != null && (str = o.optJSONObject("metadata")) != null) {
                                serviceInstanceGUID = str.getString("guid");
                            }
                            ++i;
                        }
                        if (serviceInstanceGUID == null) {
                            status.add(new ServerStatus(4, 400, "Service instance " + nameService + " can not be found in target space", null));
                            return this.revert(status);
                        }
                        URI serviceBindingsURI = targetURI.resolve("/v2/service_bindings");
                        PostMethod bindServiceMethod = new PostMethod(serviceBindingsURI.toString());
                        HttpUtil.configureHttpMethod((HttpMethod)bindServiceMethod, this.target);
                        JSONObject bindServiceRequest = new JSONObject();
                        bindServiceRequest.put("app_guid", (Object)this.application.getGuid());
                        bindServiceRequest.put("service_instance_guid", (Object)serviceInstanceGUID);
                        bindServiceMethod.setRequestEntity((RequestEntity)new StringRequestEntity(bindServiceRequest.toString(), "application/json", "utf-8"));
                        jobStatus = HttpUtil.executeMethod((HttpMethod)bindServiceMethod);
                        status.add(jobStatus);
                        if (jobStatus.isOK()) continue;
                        return this.revert(status);
                    }
                }
            }
            return status;
        }
        catch (InvalidAccessException e) {
            status.add(new ServerStatus(4, 400, e.getMessage(), null));
            return this.revert(status);
        }
        catch (Exception e) {
            String msg = NLS.bind((String)"An error occured when performing operation {0}", (Object)this.commandName);
            this.logger.error(msg, (Throwable)e);
            status.add(new ServerStatus(4, 500, msg, (Throwable)e));
            return this.revert(status);
        }
    }

    private String findServicePlanGUID(String service, String provider, String plan, JSONArray servicesJSON) throws JSONException {
        int i = 0;
        while (i < servicesJSON.length()) {
            JSONObject serviceJSON = servicesJSON.getJSONObject(i).getJSONObject("entity");
            if (service.equals(serviceJSON.getString("label")) && provider.equals(serviceJSON.getString("provider"))) {
                JSONArray servicePlans = serviceJSON.getJSONArray("service_plans");
                int j = 0;
                while (j < servicePlans.length()) {
                    JSONObject servicePlan = servicePlans.getJSONObject(j);
                    if (plan.equals(servicePlan.getJSONObject("entity").getString("name"))) {
                        return servicePlan.getJSONObject("metadata").getString("guid");
                    }
                    ++j;
                }
            }
            ++i;
        }
        return null;
    }
}

