/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.utils;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.orion.server.cf.CFExtServiceHelper;
import org.eclipse.orion.server.cf.objects.Cloud;
import org.eclipse.orion.server.cf.objects.Target;

public class TargetRegistry {
    private Map<String, UserTargets> cloudMap = Collections.synchronizedMap(new HashMap());

    public Target getTarget(String userId) {
        return this.getTarget(userId, null);
    }

    public Target getTarget(String userId, URL url) {
        UserTargets userClouds = this.getUserClouds(userId);
        return userClouds.get(url);
    }

    public void markDefault(String userId, Target target) {
        UserTargets userClouds = this.getUserClouds(userId);
        userClouds.markDefault(target);
    }

    private UserTargets getUserClouds(String userId) {
        UserTargets userClouds = this.cloudMap.get(userId);
        if (userClouds == null) {
            userClouds = new UserTargets(userId);
            this.cloudMap.put(userId, userClouds);
        }
        return userClouds;
    }

    private class UserTargets {
        private String userId;
        private Map<URL, Cloud> userCloudMap;
        private Target defaultTarget;

        private UserTargets(String userId) {
            this.userId = userId;
            this.userCloudMap = Collections.synchronizedMap(new HashMap());
        }

        private Cloud getCloud(URL url) {
            Cloud cloud = this.userCloudMap.get(url);
            if (cloud == null) {
                cloud = new Cloud(url, null, this.userId);
                this.userCloudMap.put(cloud.getUrl(), cloud);
            }
            this.setAuthToken(cloud);
            return cloud;
        }

        private Target get(URL url) {
            if ((url = this.normalizeURL(url)) == null || this.defaultTarget != null && url.equals(this.defaultTarget.getCloud().getUrl())) {
                return this.defaultTarget;
            }
            Cloud cloud = this.getCloud(url);
            return new Target(cloud);
        }

        private void markDefault(Target target) {
            Cloud cloud = this.getCloud(target.getCloud().getUrl());
            Target newTarget = new Target(cloud);
            newTarget.setOrg(target.getOrg());
            newTarget.setSpace(target.getSpace());
            this.defaultTarget = newTarget;
        }

        private void setAuthToken(Cloud cloud) {
            CFExtServiceHelper helper = CFExtServiceHelper.getDefault();
            if (cloud.getAccessToken() == null && helper != null && helper.getService() != null) {
                cloud.setAccessToken(helper.getService().getToken(cloud));
            }
        }

        private URL normalizeURL(URL url) {
            if (url == null) {
                return null;
            }
            String urlString = url.toString();
            if (urlString.endsWith("/")) {
                urlString = urlString.substring(0, urlString.length() - 1);
            }
            try {
                return new URL(urlString);
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
        }
    }
}

