/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.useradmin.servlets;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.orion.internal.server.servlets.ServletResourceHandler;
import org.eclipse.orion.internal.server.servlets.workspace.authorization.AuthorizationService;
import org.eclipse.orion.server.core.PreferenceHelper;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.orion.server.servlets.OrionServlet;
import org.eclipse.orion.server.useradmin.UserServiceHelper;
import org.eclipse.orion.server.useradmin.servlets.ServletUserHandler;
import org.eclipse.osgi.util.NLS;

public class UserServlet
extends OrionServlet {
    private static final long serialVersionUID = -6809742538472682623L;
    public static final String USERS_URI = "/users";
    private List<String> authorizedAccountCreators;
    private ServletResourceHandler<String> userSerializer;

    public void init() throws ServletException {
        this.userSerializer = new ServletUserHandler(UserServiceHelper.getDefault(), (ServletResourceHandler<IStatus>)this.getStatusHandler());
        String creators = PreferenceHelper.getString((String)"orion.auth.user.creation", null);
        if (creators != null) {
            this.authorizedAccountCreators = new ArrayList<String>();
            this.authorizedAccountCreators.addAll(Arrays.asList(creators.split(",")));
        }
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String login = req.getRemoteUser();
        if ("POST".equals(req.getMethod())) {
            if (req.getParameter("reset") == null && this.authorizedAccountCreators != null && !this.authorizedAccountCreators.contains(login)) {
                resp.sendError(403);
                return;
            }
        } else {
            if (login == null) {
                resp.sendError(403);
                return;
            }
            try {
                String requestPath = String.valueOf(req.getServletPath()) + (req.getPathInfo() == null ? "" : req.getPathInfo());
                if (!AuthorizationService.checkRights((String)login, (String)requestPath, (String)req.getMethod())) {
                    resp.sendError(403);
                    return;
                }
            }
            catch (CoreException coreException) {
                resp.sendError(500);
                return;
            }
        }
        this.traceRequest(req);
        String pathInfo = req.getPathInfo();
        if (pathInfo != null && !pathInfo.equals("/")) {
            String userId = pathInfo.split("\\/")[1];
            if (UserServiceHelper.getDefault().getUserProfileService().getUserProfileNode(userId, false) == null) {
                this.handleException(resp, (IStatus)new ServerStatus(4, 404, NLS.bind((String)"User not found: {0}", (Object)userId), null));
                return;
            }
        }
        if (this.userSerializer.handleRequest(req, resp, (Object)pathInfo)) {
            return;
        }
        super.service(req, resp);
    }
}

