/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.configurator.servlet;

import java.io.IOException;
import java.util.Properties;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.orion.server.authentication.IAuthenticationService;
import org.eclipse.orion.server.configurator.ConfiguratorActivator;
import org.eclipse.orion.server.core.LogHelper;

public class LoggedInUserFilter
implements Filter {
    private IAuthenticationService authenticationService;
    private Properties authProperties;
    private boolean redirect = true;

    public void init(FilterConfig filterConfig) throws ServletException {
        if (Boolean.FALSE.toString().equals(filterConfig.getInitParameter("redirect"))) {
            this.redirect = false;
        }
        this.authenticationService = ConfiguratorActivator.getDefault().getAuthService();
        if (this.authenticationService == null) {
            String msg = "Authentication service is missing. The server configuration must specify an authentication scheme, or use \"None\" to indicate no authentication";
            LogHelper.log((IStatus)new Status(4, "org.eclipse.orion.server.configurator", msg, null));
            throw new ServletException(msg);
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String login;
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        if (httpRequest.getRemoteUser() != null) {
            chain.doFilter(request, response);
            return;
        }
        if (this.redirect) {
            login = this.authenticationService.authenticateUser(httpRequest, httpResponse, this.authProperties);
            if (login == null) {
                return;
            }
        } else {
            login = this.authenticationService.getAuthenticatedUser(httpRequest, httpResponse, this.authProperties);
            if (login == null) {
                chain.doFilter(request, response);
                return;
            }
        }
        request.setAttribute("org.osgi.service.http.authentication.remote.user", (Object)login);
        request.setAttribute("org.osgi.service.http.authentication.type", (Object)this.authenticationService.getAuthType());
        chain.doFilter(request, response);
    }

    public void destroy() {
    }
}

