/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.commands;

import java.net.URI;
import java.net.URL;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.orion.server.cf.commands.AbstractCFCommand;
import org.eclipse.orion.server.cf.commands.GetAppCommand;
import org.eclipse.orion.server.cf.objects.Log;
import org.eclipse.orion.server.cf.objects.Target;
import org.eclipse.orion.server.cf.utils.HttpUtil;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.osgi.util.NLS;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetLogCommand
extends AbstractCFCommand {
    private final Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.cf");
    private String commandName = "Get App Log";
    private String appName;
    private String instanceNo;
    private String logName;
    private String baseRequestLocation;

    public GetLogCommand(Target target, String appName, String instanceNo, String logName, String baseRequestLocation) {
        super(target);
        this.appName = appName;
        this.instanceNo = instanceNo;
        this.logName = logName;
        this.baseRequestLocation = baseRequestLocation;
    }

    @Override
    public ServerStatus _doIt() {
        try {
            String response;
            URI targetURI = URIUtil.toURI((URL)this.target.getUrl());
            GetAppCommand getAppCommand = new GetAppCommand(this.target, this.appName);
            IStatus getAppStatus = getAppCommand.doIt();
            if (!getAppStatus.isOK()) {
                return (ServerStatus)getAppStatus;
            }
            String appUrl = getAppCommand.getApp().getAppJSON().getString("url");
            String computedInstanceNo = this.instanceNo;
            if ("Last Crash".equals(this.instanceNo)) {
                String crashedInstancesUrl = String.valueOf(appUrl) + "/crashes";
                URI crashedInstancesURI = targetURI.resolve(crashedInstancesUrl);
                GetMethod getCrashedInstancesMethod = new GetMethod(crashedInstancesURI.toString());
                HttpUtil.configureHttpMethod((HttpMethod)getCrashedInstancesMethod, this.target);
                ServerStatus getStatus = HttpUtil.executeMethod((HttpMethod)getCrashedInstancesMethod);
                if (!getStatus.isOK()) {
                    return getStatus;
                }
                response = getStatus.getJsonData().getString("response");
                JSONArray crashedInstances = new JSONArray(response);
                if (crashedInstances.length() > 0) {
                    JSONObject crashedInstance = crashedInstances.getJSONObject(crashedInstances.length() - 1);
                    computedInstanceNo = crashedInstance.getString("instance");
                }
            }
            String instanceLogsAppUrl = String.valueOf(appUrl) + "/instances/" + computedInstanceNo + "/files/logs";
            if (this.logName != null) {
                instanceLogsAppUrl = String.valueOf(instanceLogsAppUrl) + "/" + this.logName;
            }
            URI instanceLogsAppURI = targetURI.resolve(instanceLogsAppUrl);
            GetMethod getInstanceLogMethod = new GetMethod(instanceLogsAppURI.toString());
            HttpUtil.configureHttpMethod((HttpMethod)getInstanceLogMethod, this.target);
            ServerStatus getInstanceLogStatus = HttpUtil.executeMethod((HttpMethod)getInstanceLogMethod);
            if (!getInstanceLogStatus.isOK()) {
                return getInstanceLogStatus;
            }
            response = getInstanceLogStatus.getJsonData().optString("response");
            JSONObject jsonResp = new JSONObject();
            Log log = new Log(this.appName, this.logName);
            log.setContents(response);
            log.setLocation(new URI(this.baseRequestLocation));
            jsonResp.put(this.instanceNo, (Object)log.toJSON());
            return new ServerStatus(Status.OK_STATUS, 200, jsonResp);
        }
        catch (Exception e) {
            String msg = NLS.bind((String)"An error occured when performing operation {0}", (Object)this.commandName);
            this.logger.error(msg, (Throwable)e);
            return new ServerStatus(4, 500, msg, (Throwable)e);
        }
    }
}

