/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.commands;

import java.io.File;
import java.net.URI;
import java.net.URL;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.orion.server.cf.commands.AbstractRevertableCFCommand;
import org.eclipse.orion.server.cf.objects.App;
import org.eclipse.orion.server.cf.objects.Target;
import org.eclipse.orion.server.cf.utils.HttpUtil;
import org.eclipse.orion.server.cf.utils.MultiServerStatus;
import org.eclipse.orion.server.cf.utils.PackageUtils;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.osgi.util.NLS;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UploadBitsCommand
extends AbstractRevertableCFCommand {
    private static final int MAX_ATTEMPTS = 150;
    private final Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.cf");
    private String commandName;
    private String deployedAppPackageName;

    public UploadBitsCommand(Target target, App app) {
        super(target, app);
        Object[] bindings = new String[]{app.getName(), app.getGuid()};
        this.commandName = NLS.bind((String)"Upload application {0} bits (guid: {1})", (Object[])bindings);
    }

    public String getDeployedAppPackageName() {
        return this.deployedAppPackageName;
    }

    @Override
    protected ServerStatus _doIt() {
        MultiServerStatus status = new MultiServerStatus();
        try {
            File appPackage = PackageUtils.getApplicationPackage(this.application.getAppStore());
            this.deployedAppPackageName = PackageUtils.getApplicationPackageType(this.application.getAppStore());
            if (appPackage == null) {
                status.add(new ServerStatus(4, 500, "Failed to read application content", null));
                return this.revert(status);
            }
            URI targetURI = URIUtil.toURI((URL)this.target.getUrl());
            PutMethod uploadMethod = new PutMethod(targetURI.resolve("/v2/apps/" + this.application.getGuid() + "/bits?async=true").toString());
            uploadMethod.addRequestHeader(new Header("Authorization", "bearer " + this.target.getCloud().getAccessToken().getString("access_token")));
            Part[] parts = new Part[]{new StringPart("resources", "[]"), new FilePart("application", appPackage)};
            uploadMethod.setRequestEntity((RequestEntity)new MultipartRequestEntity(parts, uploadMethod.getParams()));
            ServerStatus jobStatus = HttpUtil.executeMethod((HttpMethod)uploadMethod);
            status.add(jobStatus);
            if (!jobStatus.isOK()) {
                return this.revert(status);
            }
            int attemptsLeft = 150;
            JSONObject resp = jobStatus.getJsonData();
            String taksStatus = resp.getJSONObject("entity").getString("status");
            while (!"finished".equals(taksStatus) && !"failure".equals(taksStatus)) {
                if ("failed".equals(taksStatus)) {
                    appPackage.delete();
                    status.add(new ServerStatus(4, 400, "Upload failed", null));
                    return status;
                }
                if (attemptsLeft == 0) {
                    appPackage.delete();
                    status.add(new ServerStatus(4, 400, "Upload timeout exceeded", null));
                    return this.revert(status);
                }
                Thread.sleep(2000L);
                URI jobLocation = targetURI.resolve(resp.getJSONObject("metadata").getString("url"));
                GetMethod jobRequest = new GetMethod(jobLocation.toString());
                HttpUtil.configureHttpMethod((HttpMethod)jobRequest, this.target);
                jobStatus = HttpUtil.executeMethod((HttpMethod)jobRequest);
                status.add(jobStatus);
                if (!jobStatus.isOK()) {
                    return this.revert(status);
                }
                resp = jobStatus.getJsonData();
                taksStatus = resp.getJSONObject("entity").getString("status");
                --attemptsLeft;
            }
            if ("failure".equals(jobStatus)) {
                status.add(new ServerStatus(4, 500, "Failed to upload application bits", null));
                return this.revert(status);
            }
            appPackage.delete();
            return status;
        }
        catch (Exception e) {
            String msg = NLS.bind((String)"An error occured when performing operation {0}", (Object)this.commandName);
            this.logger.error(msg, (Throwable)e);
            status.add(new ServerStatus(4, 500, msg, (Throwable)e));
            return this.revert(status);
        }
    }
}

