/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.docker.server;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.SecureRandom;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerFile {
    private static final SecureRandom random = new SecureRandom();
    private File dockerfile;
    private File dockerTarFile;
    private String groupId;
    private File tempFolder;
    private String userName;
    private String userId;
    private final Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.docker");

    public DockerFile(String userName, String userId, String groupId) {
        this.userName = userName;
        this.userId = userId;
        this.groupId = groupId;
        this.tempFolder = null;
        this.dockerfile = null;
        this.dockerTarFile = null;
    }

    public void cleanup() {
        if (this.dockerfile != null && this.dockerfile.exists()) {
            this.dockerfile.delete();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Dockerfile: Deleted " + this.dockerfile.toString());
            }
            this.dockerfile = null;
        }
        if (this.dockerTarFile != null && this.dockerTarFile.exists()) {
            this.dockerTarFile.delete();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Dockerfile: Deleted " + this.dockerTarFile.toString());
            }
            this.dockerTarFile = null;
        }
        if (this.tempFolder != null && this.tempFolder.exists()) {
            this.tempFolder.delete();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Dockerfile: Deleted folder " + this.tempFolder.toString());
            }
            this.tempFolder = null;
        }
    }

    public File getTarFile() {
        block10: {
            File tmpDir;
            block9: {
                String tmpDirName = System.getProperty("java.io.tmpdir");
                tmpDir = new File(tmpDirName);
                if (tmpDir.exists() && tmpDir.isDirectory()) break block9;
                if (this.logger.isDebugEnabled()) {
                    this.logger.error("Cannot find the default temporary-file directory: " + tmpDirName);
                }
                return null;
            }
            long n = random.nextLong();
            n = n == Long.MIN_VALUE ? 0L : Math.abs(n);
            String tmpDirStr = Long.toString(n);
            this.tempFolder = new File(tmpDir, tmpDirStr);
            if (this.tempFolder.mkdir()) break block10;
            if (this.logger.isDebugEnabled()) {
                this.logger.error("Cannot create a temporary directory at " + this.tempFolder.toString());
            }
            return null;
        }
        try {
            int bytes_read;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Dockerfile: Created a temporary directory at " + this.tempFolder.toString());
            }
            this.dockerfile = new File(this.tempFolder, "Dockerfile");
            FileOutputStream fileOutputStream = new FileOutputStream(this.dockerfile);
            Charset utf8 = Charset.forName("UTF-8");
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, utf8);
            outputStreamWriter.write(this.getDockerfileContent());
            outputStreamWriter.flush();
            outputStreamWriter.close();
            fileOutputStream.close();
            this.dockerTarFile = new File(this.tempFolder, "Dockerfile.tar");
            TarArchiveOutputStream tarArchiveOutputStream = new TarArchiveOutputStream((OutputStream)new FileOutputStream(this.dockerTarFile));
            tarArchiveOutputStream.setLongFileMode(2);
            TarArchiveEntry tarEntry = new TarArchiveEntry(this.dockerfile);
            tarEntry.setName(this.dockerfile.getName());
            tarArchiveOutputStream.putArchiveEntry((ArchiveEntry)tarEntry);
            FileInputStream fileInputStream = new FileInputStream(this.dockerfile);
            BufferedInputStream inputStream = new BufferedInputStream(fileInputStream);
            byte[] buffer = new byte[4096];
            while ((bytes_read = inputStream.read(buffer)) != -1) {
                tarArchiveOutputStream.write(buffer, 0, bytes_read);
            }
            inputStream.close();
            tarArchiveOutputStream.closeArchiveEntry();
            tarArchiveOutputStream.close();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Dockerfile: Created a docker tar file at " + this.dockerTarFile.toString());
            }
            return this.dockerTarFile;
        }
        catch (IOException e) {
            this.logger.error(e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    protected String getDockerfileContent() {
        try {
            String dockerfileName = "Dockerfile.user";
            URL dockerFileURL = Platform.getBundle((String)"org.eclipse.orion.server.docker").getEntry(dockerfileName);
            File dockerfile = new File(FileLocator.toFileURL((URL)dockerFileURL).getPath());
            FileInputStream fileInputStream = new FileInputStream(dockerfile);
            char[] chars = new char[(int)dockerfile.length()];
            Charset utf8 = Charset.forName("UTF-8");
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, utf8);
            inputStreamReader.read(chars);
            inputStreamReader.close();
            fileInputStream.close();
            String result = new String(chars);
            result = result.replaceAll("USERNAME", this.userName);
            result = result.replaceAll("UID", this.userId);
            result = result.replaceAll("GID", this.groupId);
            return result;
        }
        catch (IOException e) {
            this.logger.error(e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }
}

