/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.docker.servlets;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.orion.internal.server.servlets.ServletResourceHandler;
import org.eclipse.orion.server.core.OrionConfiguration;
import org.eclipse.orion.server.core.PreferenceHelper;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.orion.server.core.metastore.IMetaStore;
import org.eclipse.orion.server.core.metastore.UserInfo;
import org.eclipse.orion.server.docker.server.DockerContainer;
import org.eclipse.orion.server.docker.server.DockerContainers;
import org.eclipse.orion.server.docker.server.DockerImage;
import org.eclipse.orion.server.docker.server.DockerImages;
import org.eclipse.orion.server.docker.server.DockerResponse;
import org.eclipse.orion.server.docker.server.DockerServer;
import org.eclipse.orion.server.docker.server.DockerVersion;
import org.eclipse.orion.server.servlets.OrionServlet;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerHandler
extends ServletResourceHandler<String> {
    private DockerServer dockerServer = null;
    protected ServletResourceHandler<IStatus> statusHandler;
    private final Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.docker");

    public DockerHandler(ServletResourceHandler<IStatus> statusHandler) {
        this.statusHandler = statusHandler;
        this.initDockerServer();
    }

    private void createBashrc(String user) {
        try {
            IMetaStore metaStore = OrionConfiguration.getMetaStore();
            UserInfo userInfo = metaStore.readUser(user);
            List workspaceIds = userInfo.getWorkspaceIds();
            if (workspaceIds.isEmpty()) {
                return;
            }
            String workspaceId = (String)workspaceIds.get(0);
            IFileStore workspaceContentLocation = metaStore.getWorkspaceContentLocation(workspaceId);
            IFileStore bashrc = workspaceContentLocation.getChild(".bashrc");
            if (bashrc.fetchInfo().exists()) {
                return;
            }
            File skelFile = new File("/etc/skel/.bashrc");
            IFileStore skel = EFS.getLocalFileSystem().fromLocalFile(skelFile);
            if (skel.fetchInfo().exists()) {
                skel.copy(bashrc, 0, null);
            }
            File bashrcFile = bashrc.toLocalFile(0, null);
            String lines = new String("set -o vi\nPS1=\"\\u:\\w[\\!] % \"\n");
            FileWriter fileWritter = new FileWriter(bashrcFile, true);
            BufferedWriter bufferWritter = new BufferedWriter(fileWritter);
            bufferWritter.write(lines);
            bufferWritter.close();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Created new file " + bashrcFile.toString() + " for user " + user);
            }
        }
        catch (CoreException e) {
            this.logger.error(e.getLocalizedMessage(), (Throwable)e);
        }
        catch (IOException e) {
            this.logger.error(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private DockerServer getDockerServer() {
        return this.dockerServer;
    }

    private String getDockerVolume(String user) {
        List workspaceIds;
        IMetaStore metaStore;
        block4: {
            try {
                metaStore = OrionConfiguration.getMetaStore();
                UserInfo userInfo = metaStore.readUser(user);
                workspaceIds = userInfo.getWorkspaceIds();
                if (!workspaceIds.isEmpty()) break block4;
                return null;
            }
            catch (CoreException e) {
                this.logger.error(e.getLocalizedMessage(), (Throwable)e);
                return null;
            }
        }
        String workspaceId = (String)workspaceIds.get(0);
        IFileStore workspaceContentLocation = metaStore.getWorkspaceContentLocation(workspaceId);
        String localVolume = workspaceContentLocation.toLocalFile(0, null).getAbsolutePath();
        String volume = String.valueOf(localVolume) + ":/home/" + user + ":rw";
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Created Docker Volume \"" + volume + "\" for user " + user);
        }
        return volume;
    }

    private boolean handleConnectDockerContainerRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        try {
            String originURL;
            DockerResponse dockerResponse;
            String userBase;
            DockerImage dockerImage;
            String user = request.getRemoteUser();
            DockerServer dockerServer = this.getDockerServer();
            if (dockerServer.isAttachedDockerContainer(user)) {
                DockerContainer dockerContainer = dockerServer.getDockerContainer(user);
                if (dockerContainer.getStatusCode() == DockerResponse.StatusCode.OK && (dockerContainer = dockerServer.stopDockerContainer(dockerContainer.getId())).getStatusCode() == DockerResponse.StatusCode.STOPPED && this.logger.isInfoEnabled()) {
                    this.logger.info("Stopped Docker Container " + dockerContainer.getIdShort() + " for user " + user);
                }
                dockerServer.detachDockerContainer(user);
            }
            if ((dockerImage = dockerServer.getDockerImage(userBase = String.valueOf(user) + "-base")).getStatusCode() != DockerResponse.StatusCode.OK) {
                dockerImage = dockerServer.createDockerUserBaseImage(user);
                if (dockerImage.getStatusCode() != DockerResponse.StatusCode.CREATED) {
                    return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, dockerImage.getStatusMessage(), null));
                }
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Created Docker Image " + userBase + " for user " + user);
                }
            }
            String volume = this.getDockerVolume(user);
            DockerContainer dockerContainer = dockerServer.getDockerContainer(user);
            if (dockerContainer.getStatusCode() != DockerResponse.StatusCode.OK) {
                dockerContainer = dockerServer.createDockerContainer(userBase, user, volume);
                if (dockerContainer.getStatusCode() != DockerResponse.StatusCode.CREATED) {
                    return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, dockerContainer.getStatusMessage(), null));
                }
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Created Docker Container " + dockerContainer.getIdShort() + " for user " + user);
                }
                this.createBashrc(user);
            }
            ArrayList<String> portNumbers = new ArrayList<String>();
            for (String port : dockerImage.getPorts()) {
                if (port.contains("/tcp")) {
                    port = port.substring(0, port.indexOf("/tcp"));
                }
                portNumbers.add(port);
            }
            dockerContainer = dockerServer.startDockerContainer(user, volume, portNumbers);
            if (dockerContainer.getStatusCode() == DockerResponse.StatusCode.STARTED) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Started Docker Container " + dockerContainer.getIdShort() + " for user " + user);
                }
            } else if (dockerContainer.getStatusCode() == DockerResponse.StatusCode.RUNNING) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Docker Container " + dockerContainer.getIdShort() + " for user " + user + " is already running");
                }
            } else {
                return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, dockerContainer.getStatusMessage(), null));
            }
            if ((dockerResponse = dockerServer.attachDockerContainer(user, originURL = request.getRequestURL().toString())).getStatusCode() != DockerResponse.StatusCode.ATTACHED) {
                return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, dockerContainer.getStatusMessage(), null));
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Attach Docker Container " + dockerContainer.getIdShort() + " for user " + user + " successful");
            }
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("attachWsURI", (Object)dockerResponse.getStatusMessage());
            OrionServlet.writeJSONResponse((HttpServletRequest)request, (HttpServletResponse)response, (Object)jsonObject);
            return true;
        }
        catch (IOException e) {
            return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, "IOException with request", (Throwable)e));
        }
        catch (JSONException e) {
            return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, "JSONException with request", (Throwable)e));
        }
    }

    private boolean handleDisconnectDockerContainerRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        String user = request.getRemoteUser();
        DockerServer dockerServer = this.getDockerServer();
        DockerContainer dockerContainer = dockerServer.getDockerContainer(user);
        if (dockerContainer.getStatusCode() == DockerResponse.StatusCode.NO_SUCH_CONTAINER) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Docker Container for user " + user + " is not running, no need to stop it.");
            }
            return true;
        }
        if (dockerServer.isAttachedDockerContainer(user)) {
            if ((dockerContainer = dockerServer.stopDockerContainer(dockerContainer.getId())).getStatusCode() != DockerResponse.StatusCode.STOPPED) {
                return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, dockerContainer.getStatusMessage(), null));
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Stopped Docker Container " + dockerContainer.getIdShort() + " for user " + user);
            }
            dockerServer.detachDockerContainer(user);
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean handleDockerContainerRequest(HttpServletRequest request, HttpServletResponse response, String string) throws ServletException {
        try {
            DockerServer dockerServer = this.getDockerServer();
            DockerContainer dockerContainer = dockerServer.getDockerContainer(string);
            switch (dockerContainer.getStatusCode()) {
                case SERVER_ERROR: {
                    response.sendError(500, dockerContainer.getStatusMessage());
                    return false;
                }
                case NO_SUCH_IMAGE: {
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("Image", (Object)dockerContainer.getStatusMessage());
                    OrionServlet.writeJSONResponse((HttpServletRequest)request, (HttpServletResponse)response, (Object)jsonObject);
                    return true;
                }
                case CONNECTION_REFUSED: {
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("Image", (Object)dockerContainer.getStatusMessage());
                    OrionServlet.writeJSONResponse((HttpServletRequest)request, (HttpServletResponse)response, (Object)jsonObject);
                    return true;
                }
                case OK: {
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("Id", (Object)dockerContainer.getIdShort());
                    jsonObject.put("Image", (Object)dockerContainer.getImage());
                    jsonObject.put("Command", (Object)dockerContainer.getCommand());
                    jsonObject.put("Created", (Object)dockerContainer.getCreated());
                    jsonObject.put("Status", (Object)dockerContainer.getStatus());
                    jsonObject.put("Ports", (Object)dockerContainer.getPorts());
                    jsonObject.put("Name", (Object)dockerContainer.getName());
                    OrionServlet.writeJSONResponse((HttpServletRequest)request, (HttpServletResponse)response, (Object)jsonObject);
                    return true;
                }
            }
            return false;
        }
        catch (IOException e) {
            return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, "IOException with request", (Throwable)e));
        }
        catch (JSONException e) {
            return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, "JSONException with request", (Throwable)e));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean handleDockerContainersRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        try {
            DockerServer dockerServer = this.getDockerServer();
            DockerContainers dockerContainers = dockerServer.getDockerContainers();
            switch (dockerContainers.getStatusCode()) {
                case SERVER_ERROR: {
                    response.sendError(500, dockerContainers.getStatusMessage());
                    return false;
                }
                case CONNECTION_REFUSED: {
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("Containers", (Object)dockerContainers.getStatusMessage());
                    OrionServlet.writeJSONResponse((HttpServletRequest)request, (HttpServletResponse)response, (Object)jsonObject);
                    return true;
                }
                case OK: {
                    JSONArray jsonArray = new JSONArray();
                    Iterator<DockerContainer> iterator = dockerContainers.getContainers().iterator();
                    while (true) {
                        JSONObject jsonObject;
                        if (!iterator.hasNext()) {
                            jsonObject = new JSONObject();
                            jsonObject.put("Containers", (Object)jsonArray);
                            OrionServlet.writeJSONResponse((HttpServletRequest)request, (HttpServletResponse)response, (Object)jsonObject);
                            return true;
                        }
                        DockerContainer dockerContainer = iterator.next();
                        jsonObject = new JSONObject();
                        jsonObject.put("Id", (Object)dockerContainer.getIdShort());
                        jsonObject.put("Image", (Object)dockerContainer.getImage());
                        jsonObject.put("Command", (Object)dockerContainer.getCommand());
                        jsonObject.put("Created", (Object)dockerContainer.getCreated());
                        jsonObject.put("Status", (Object)dockerContainer.getStatus());
                        jsonObject.put("Ports", (Object)dockerContainer.getPorts());
                        jsonObject.put("Name", (Object)dockerContainer.getName());
                        jsonArray.put((Object)jsonObject);
                    }
                }
            }
            return false;
        }
        catch (IOException e) {
            return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, "IOException with request", (Throwable)e));
        }
        catch (JSONException e) {
            return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, "JSONException with request", (Throwable)e));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean handleDockerImageRequest(HttpServletRequest request, HttpServletResponse response, String string) throws ServletException {
        try {
            DockerServer dockerServer = this.getDockerServer();
            DockerImage dockerImage = dockerServer.getDockerImage(string);
            switch (dockerImage.getStatusCode()) {
                case SERVER_ERROR: {
                    response.sendError(500, dockerImage.getStatusMessage());
                    return false;
                }
                case NO_SUCH_IMAGE: {
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("Image", (Object)dockerImage.getStatusMessage());
                    OrionServlet.writeJSONResponse((HttpServletRequest)request, (HttpServletResponse)response, (Object)jsonObject);
                    return true;
                }
                case CONNECTION_REFUSED: {
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("Image", (Object)dockerImage.getStatusMessage());
                    OrionServlet.writeJSONResponse((HttpServletRequest)request, (HttpServletResponse)response, (Object)jsonObject);
                    return true;
                }
                case OK: {
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("Repository", (Object)dockerImage.getRepository());
                    jsonObject.put("Tag", (Object)dockerImage.getTag());
                    jsonObject.put("Id", (Object)dockerImage.getId());
                    jsonObject.put("Created", (Object)dockerImage.getCreated());
                    jsonObject.put("Size", dockerImage.getSize());
                    JSONObject ports = new JSONObject();
                    Iterator<String> iterator = dockerImage.getPorts().iterator();
                    while (true) {
                        if (!iterator.hasNext()) {
                            jsonObject.put("ExposedPorts", (Object)ports);
                            OrionServlet.writeJSONResponse((HttpServletRequest)request, (HttpServletResponse)response, (Object)jsonObject);
                            return true;
                        }
                        String port = iterator.next();
                        ports.put(port, (Object)new JSONObject());
                    }
                }
            }
            return false;
        }
        catch (IOException e) {
            return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, "IOException with request", (Throwable)e));
        }
        catch (JSONException e) {
            return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, "JSONException with request", (Throwable)e));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean handleDockerImagesRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        try {
            DockerServer dockerServer = this.getDockerServer();
            DockerImages dockerImages = dockerServer.getDockerImages();
            switch (dockerImages.getStatusCode()) {
                case SERVER_ERROR: {
                    response.sendError(500, dockerImages.getStatusMessage());
                    return false;
                }
                case CONNECTION_REFUSED: {
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("Images", (Object)dockerImages.getStatusMessage());
                    OrionServlet.writeJSONResponse((HttpServletRequest)request, (HttpServletResponse)response, (Object)jsonObject);
                    return true;
                }
                case OK: {
                    JSONArray jsonArray = new JSONArray();
                    Iterator<DockerImage> iterator = dockerImages.getImages().iterator();
                    while (true) {
                        JSONObject jsonObject;
                        if (!iterator.hasNext()) {
                            jsonObject = new JSONObject();
                            jsonObject.put("Images", (Object)jsonArray);
                            OrionServlet.writeJSONResponse((HttpServletRequest)request, (HttpServletResponse)response, (Object)jsonObject);
                            return true;
                        }
                        DockerImage dockerImage = iterator.next();
                        jsonObject = new JSONObject();
                        jsonObject.put("Repository", (Object)dockerImage.getRepository());
                        jsonObject.put("Tag", (Object)dockerImage.getTag());
                        jsonObject.put("Id", (Object)dockerImage.getId());
                        jsonObject.put("Created", (Object)dockerImage.getCreated());
                        jsonObject.put("Size", dockerImage.getSize());
                        jsonArray.put((Object)jsonObject);
                    }
                }
            }
            return false;
        }
        catch (IOException e) {
            return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, "IOException with request", (Throwable)e));
        }
        catch (JSONException e) {
            return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, "JSONException with request", (Throwable)e));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean handleDockerVersionRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        try {
            DockerServer dockerServer = this.getDockerServer();
            DockerVersion dockerVersion = dockerServer.getDockerVersion();
            switch (dockerVersion.getStatusCode()) {
                case BAD_PARAMETER: {
                    response.sendError(400, dockerVersion.getStatusMessage());
                    return false;
                }
                case SERVER_ERROR: {
                    response.sendError(500, dockerVersion.getStatusMessage());
                    return false;
                }
                case CONNECTION_REFUSED: {
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("Version", (Object)dockerVersion.getStatusMessage());
                    OrionServlet.writeJSONResponse((HttpServletRequest)request, (HttpServletResponse)response, (Object)jsonObject);
                    return true;
                }
                case OK: {
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("Version", (Object)dockerVersion.getVersion());
                    OrionServlet.writeJSONResponse((HttpServletRequest)request, (HttpServletResponse)response, (Object)jsonObject);
                    return true;
                }
            }
            return false;
        }
        catch (IOException e) {
            return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, "IOException with request", (Throwable)e));
        }
        catch (JSONException e) {
            return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, "JSONException with request", (Throwable)e));
        }
    }

    private boolean handleGetRequest(HttpServletRequest request, HttpServletResponse response, String path) throws ServletException {
        String[] pathSplit = path.split("\\/", 2);
        String dockerRequest = pathSplit[0];
        if (dockerRequest.equals("version")) {
            return this.handleDockerVersionRequest(request, response);
        }
        if (dockerRequest.equals("images")) {
            return this.handleDockerImagesRequest(request, response);
        }
        if (dockerRequest.equals("image")) {
            return this.handleDockerImageRequest(request, response, pathSplit[1]);
        }
        if (dockerRequest.equals("containers")) {
            return this.handleDockerContainersRequest(request, response);
        }
        if (dockerRequest.equals("container")) {
            return this.handleDockerContainerRequest(request, response, pathSplit[1]);
        }
        return false;
    }

    private boolean handlePostRequest(HttpServletRequest request, HttpServletResponse response, String path) throws ServletException {
        String[] pathSplit = path.split("\\/", 2);
        String dockerRequest = pathSplit[0];
        if (dockerRequest.equals("connect")) {
            return this.handleConnectDockerContainerRequest(request, response);
        }
        if (dockerRequest.equals("disconnect")) {
            return this.handleDisconnectDockerContainerRequest(request, response);
        }
        return false;
    }

    public boolean handleRequest(HttpServletRequest request, HttpServletResponse response, String path) throws ServletException {
        if (this.dockerServer == null) {
            return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, "A Docker server required for terminal support is not enabled on this Orion server.", null));
        }
        switch (DockerHandler.getMethod((HttpServletRequest)request)) {
            case GET: {
                return this.handleGetRequest(request, response, path);
            }
            case POST: {
                return this.handlePostRequest(request, response, path);
            }
        }
        return false;
    }

    private void initDockerServer() {
        try {
            URI dockerLocationURI;
            String dockerLocation = PreferenceHelper.getString((String)"orion.core.docker.uri", (String)"none").toLowerCase();
            if ("none".equals(dockerLocation)) {
                dockerLocation = "http://localhost:4243";
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn("No Docker Server specified by \"orion.core.docker.uri\" in orion.conf, trying " + dockerLocation);
                }
            }
            if (!OrionConfiguration.getMetaStorePreference().equals("simple2")) {
                this.dockerServer = null;
                this.logger.error("Docker Support requires version two of the simple metadata storage, see https://wiki.eclipse.org/Orion/Metadata_migration to migrate to the current version");
                return;
            }
            URI dockerProxyURI = dockerLocationURI = new URI(dockerLocation);
            String dockerProxy = PreferenceHelper.getString((String)"orion.core.docker.proxy.uri", (String)"none").toLowerCase();
            if (!"none".equals(dockerProxy)) {
                dockerProxyURI = new URI(dockerProxy);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Docker Proxy Server " + dockerProxy + " is enabled");
                }
            }
            String portStart = PreferenceHelper.getString((String)"orion.core.docker.port.start", (String)"none").toLowerCase();
            String portEnd = PreferenceHelper.getString((String)"orion.core.docker.port.end", (String)"none").toLowerCase();
            if ("none".equals(portStart) || "none".equals(portEnd)) {
                portStart = null;
                portEnd = null;
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Docker Server does not have port mapping enabled, start and end host ports not specified");
                }
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug("Docker Server using ports " + portStart + " to " + portEnd + " for host port mapping");
            }
            String userId = PreferenceHelper.getString((String)"orion.core.docker.uid", (String)"1000").toLowerCase();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Orion Server running as UID " + userId);
            }
            String groupId = PreferenceHelper.getString((String)"orion.core.docker.gid", (String)"1000").toLowerCase();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Orion Server running as GID " + groupId);
            }
            this.dockerServer = new DockerServer(dockerLocationURI, dockerProxyURI, portStart, portEnd, userId, groupId);
            DockerVersion dockerVersion = this.dockerServer.getDockerVersion();
            if (this.logger.isDebugEnabled()) {
                if (dockerVersion.getStatusCode() != DockerResponse.StatusCode.OK) {
                    this.logger.error("Cound not connect to docker server " + dockerLocation + ": " + dockerVersion.getStatusMessage());
                } else if (this.logger.isInfoEnabled()) {
                    this.logger.info("Docker Server " + dockerLocation + " is running version " + dockerVersion.getVersion());
                }
            }
        }
        catch (URISyntaxException e) {
            this.logger.error(e.getLocalizedMessage(), (Throwable)e);
            this.dockerServer = null;
        }
    }
}

