/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.hosting;

import java.util.Collection;
import org.eclipse.orion.internal.server.hosting.HostedStatusDecorator;
import org.eclipse.orion.internal.server.hosting.SiteHostingConfig;
import org.eclipse.orion.internal.server.hosting.SiteHostingService;
import org.eclipse.orion.internal.server.servlets.hosting.ISiteHostingService;
import org.eclipse.orion.server.core.IWebResourceDecorator;
import org.eclipse.orion.server.core.PreferenceHelper;
import org.eclipse.orion.server.core.metastore.IMetaStore;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class HostingActivator
implements BundleActivator {
    public static final String PI_SERVER_HOSTING = "org.eclipse.orion.server.hosting";
    private static BundleContext bundleContext;
    private static HostingActivator singleton;
    private IMetaStore metastore;
    private SiteHostingService siteHostingService;
    private ServiceRegistration<ISiteHostingService> siteHostingRegistration;
    private ServiceReference<IMetaStore> metastoreServiceReference;
    private ServiceRegistration<IWebResourceDecorator> hostedStatusDecoratorRegistration;

    static BundleContext getContext() {
        return bundleContext;
    }

    public static HostingActivator getDefault() {
        return singleton;
    }

    public void start(BundleContext bundleContext) throws Exception {
        singleton = this;
        HostingActivator.bundleContext = bundleContext;
        this.registerHostingService();
        this.registerDecorators();
    }

    public synchronized IMetaStore getMetastore() {
        if (this.metastore == null) {
            Collection services;
            String filter = null;
            try {
                services = bundleContext.getServiceReferences(IMetaStore.class, filter);
            }
            catch (InvalidSyntaxException e) {
                throw new RuntimeException(e);
            }
            if (services.size() == 1) {
                this.metastoreServiceReference = (ServiceReference)services.iterator().next();
                this.metastore = (IMetaStore)bundleContext.getService(this.metastoreServiceReference);
            }
            if (this.metastore == null) {
                throw new IllegalStateException("Invalid server configuration. Failed to initialize a metadata store");
            }
        }
        return this.metastore;
    }

    private void registerHostingService() {
        SiteHostingConfig config = SiteHostingConfig.getSiteHostingConfig(PreferenceHelper.getString((String)"orion.site.virtualHosts"));
        this.siteHostingService = new SiteHostingService(config);
        this.siteHostingRegistration = bundleContext.registerService(ISiteHostingService.class, (Object)this.siteHostingService, null);
    }

    private void registerDecorators() {
        this.hostedStatusDecoratorRegistration = bundleContext.registerService(IWebResourceDecorator.class, (Object)new HostedStatusDecorator(), null);
    }

    SiteHostingService getHostingService() {
        return this.siteHostingService;
    }

    public void stop(BundleContext bundleContext) throws Exception {
        HostingActivator.bundleContext = null;
        this.unregisterHostingService();
        this.unregisterDecorators();
        this.siteHostingService = null;
    }

    private void unregisterHostingService() {
        if (this.siteHostingRegistration != null) {
            this.siteHostingRegistration.unregister();
            this.siteHostingRegistration = null;
        }
    }

    private void unregisterDecorators() {
        if (this.hostedStatusDecoratorRegistration != null) {
            this.hostedStatusDecoratorRegistration.unregister();
            this.hostedStatusDecoratorRegistration = null;
        }
    }
}

