/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.useradmin.simple;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.orion.internal.server.core.metastore.SimpleUserPasswordUtil;
import org.eclipse.orion.internal.server.servlets.workspace.authorization.AuthorizationService;
import org.eclipse.orion.internal.server.useradmin.simple.SimpleUserProfileRoot;
import org.eclipse.orion.server.core.LogHelper;
import org.eclipse.orion.server.core.OrionConfiguration;
import org.eclipse.orion.server.core.PreferenceHelper;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.orion.server.core.metastore.UserInfo;
import org.eclipse.orion.server.user.profile.IOrionUserProfileNode;
import org.eclipse.orion.server.useradmin.EmptyAuthorization;
import org.eclipse.orion.server.useradmin.IOrionCredentialsService;
import org.eclipse.orion.server.useradmin.Role;
import org.eclipse.orion.server.useradmin.User;
import org.eclipse.orion.server.useradmin.UserServiceHelper;
import org.eclipse.orion.server.useradmin.WebIdeAuthorization;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.useradmin.Authorization;

public class SimpleUserCredentialsService
implements IOrionCredentialsService {
    IOrionUserProfileNode root = null;
    public static final String USER_PROPERTIES = "profileProperties";
    static final String ADMIN_LOGIN_VALUE = "admin";
    static final String ADMIN_NAME_VALUE = "Administrative User";
    private Map<String, String> emailCache = new HashMap<String, String>();
    private Map<String, String> openidCache = new HashMap<String, String>();

    public SimpleUserCredentialsService() {
        this.initStorage();
    }

    private void initStorage() {
        try {
            IFileStore fileStore = OrionConfiguration.getRootLocation();
            File rootLocation = fileStore.toLocalFile(0, null);
            this.root = new SimpleUserProfileRoot(rootLocation);
        }
        catch (CoreException e) {
            LogHelper.log((Throwable)e);
        }
        String adminDefaultPassword = PreferenceHelper.getString((String)"orion.auth.admin.default.password");
        User admin = this.getUser("login", ADMIN_LOGIN_VALUE);
        if (admin == null && adminDefaultPassword != null) {
            UserInfo userInfo = new UserInfo();
            userInfo.setUserName(ADMIN_LOGIN_VALUE);
            userInfo.setFullName(ADMIN_NAME_VALUE);
            try {
                OrionConfiguration.getMetaStore().createUser(userInfo);
            }
            catch (CoreException e) {
                LogHelper.log((Throwable)e);
            }
            admin = this.createUser(new User(userInfo.getUniqueId(), ADMIN_LOGIN_VALUE, ADMIN_NAME_VALUE, adminDefaultPassword));
        }
        Collection<User> users = this.getUsers();
        users.clear();
        if (admin == null) {
            return;
        }
        try {
            AuthorizationService.addUserRight((String)admin.getUid(), (String)"/users");
            AuthorizationService.addUserRight((String)admin.getUid(), (String)"/users/*");
        }
        catch (CoreException e) {
            LogHelper.log((Throwable)e);
        }
    }

    public boolean deleteUser(User user) {
        String oldEmail = user.getEmail();
        if (oldEmail != null && !oldEmail.equals("")) {
            this.emailCache.remove(oldEmail.toLowerCase());
        }
        Enumeration keys = user.getProperties().keys();
        while (keys.hasMoreElements()) {
            String property = (String)keys.nextElement();
            String value = (String)user.getProperty(property);
            if (!property.equals("openid") || value.equals("")) continue;
            this.openidCache.remove(value);
        }
        return true;
    }

    public IStatus updateUser(String uid, User user) {
        if (!user.getUid().equals(uid)) {
            throw new RuntimeException("SimpleUserCredentialsService.updateUser: cannot change the user id " + uid + " for " + user.getName());
        }
        IOrionUserProfileNode userProfileNode = this.root.getUserProfileNode(uid);
        if (userProfileNode == null) {
            return new ServerStatus(4, 404, "User not found: " + uid, null);
        }
        if (!uid.equals(user.getLogin()) && UserServiceHelper.getDefault().getUserProfileService().getUserProfileNode(user.getLogin(), false) != null) {
            return new ServerStatus(4, 409, "Cannot update profile: a user already exists with login " + user.getLogin(), null);
        }
        this.createOrUpdateUser(userProfileNode, user);
        return new Status(0, "org.eclipse.orion.server.useradmin.simple", "User updated " + user.getLogin());
    }

    public User createUser(User newUser) {
        try {
            IOrionUserProfileNode userProfileNode = this.root.getUserProfileNode(newUser.getUid());
            if (!newUser.getLogin().equals(userProfileNode.get("login", ""))) {
                throw new RuntimeException("SimpleUserCredentialsService.createUser: names do not match for " + newUser.getLogin());
            }
            return this.createOrUpdateUser(userProfileNode, newUser);
        }
        catch (CoreException e) {
            LogHelper.log((Throwable)e);
            return null;
        }
    }

    private User createOrUpdateUser(IOrionUserProfileNode userProfileNode, User user) {
        try {
            if (user.getName() != null) {
                userProfileNode.put("name", user.getName(), false);
            }
            if (user.getPassword() != null) {
                userProfileNode.put("password", user.getPassword(), true);
            }
            if (user.getBlocked()) {
                userProfileNode.put("blocked", String.valueOf(user.getBlocked()), false);
            } else {
                userProfileNode.remove("blocked");
            }
            if (user.getEmail() != null) {
                String oldEmail = userProfileNode.get("email", null);
                if (user.getEmail().length() > 0 && !user.getEmail().equals(oldEmail)) {
                    user.setConfirmationId();
                }
                userProfileNode.put("email", user.getEmail(), false);
                if (!user.getEmail().equals(oldEmail)) {
                    if (oldEmail != null && !oldEmail.equals("")) {
                        this.emailCache.remove(oldEmail.toLowerCase());
                    }
                    if (!user.getEmail().equals("")) {
                        this.emailCache.put(user.getEmail().toLowerCase(), user.getLogin());
                    }
                }
            }
            if (user.getConfirmationId() == null) {
                userProfileNode.remove("email_confirmation");
            } else {
                userProfileNode.put("email_confirmation", user.getConfirmationId(), false);
            }
            IOrionUserProfileNode profileProperties = userProfileNode.getUserProfileNode(USER_PROPERTIES);
            String oldOpenid = profileProperties.get("openid", null);
            String newOpenid = "";
            Enumeration keys = user.getProperties().keys();
            while (keys.hasMoreElements()) {
                String property = (String)keys.nextElement();
                String value = (String)user.getProperty(property);
                profileProperties.put(property, value, false);
                if (!property.equals("openid")) continue;
                newOpenid = value;
            }
            if (!newOpenid.equals(oldOpenid)) {
                if (oldOpenid != null && !oldOpenid.equals("")) {
                    this.openidCache.remove(oldOpenid);
                }
                if (!newOpenid.equals("")) {
                    this.openidCache.put(newOpenid, user.getLogin());
                }
            }
            if (user.getLogin() != null) {
                userProfileNode.put("login", user.getLogin(), false);
            }
            userProfileNode.flush();
            return this.formUser(userProfileNode);
        }
        catch (CoreException e) {
            LogHelper.log((Throwable)e);
            return null;
        }
    }

    public String getStoreName() {
        return "Orion";
    }

    public boolean canCreateUsers() {
        return true;
    }

    public Collection<User> getUsers() {
        ArrayList<User> users = new ArrayList<User>();
        String[] stringArray = this.root.childrenNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String childName = stringArray[n2];
            IOrionUserProfileNode userProfileNode = this.root.getUserProfileNode(childName);
            try {
                String[] keys;
                String blocked;
                User user = new User(childName, userProfileNode.get("login", childName), userProfileNode.get("name", ""), userProfileNode.get("password", null) == null ? null : "");
                user.setEmail(userProfileNode.get("email", ""));
                if (!user.getEmail().equals("")) {
                    this.emailCache.put(user.getEmail(), childName);
                }
                if ((blocked = userProfileNode.get("blocked", "false")).equals("true")) {
                    user.setBlocked(true);
                }
                if (userProfileNode.get("email_confirmation", null) != null) {
                    user.setConfirmationId(userProfileNode.get("email_confirmation", null));
                }
                if ((keys = userProfileNode.getUserProfileNode(USER_PROPERTIES).keys()).length > 0) {
                    int i = 0;
                    while (i < keys.length) {
                        String key = keys[i];
                        String value = userProfileNode.getUserProfileNode(USER_PROPERTIES).get(key, "");
                        user.addProperty(key, value);
                        if (key.equals("openid")) {
                            this.openidCache.put(value, childName);
                        }
                        ++i;
                    }
                }
                users.add(user);
            }
            catch (CoreException e) {
                LogHelper.log((Throwable)e);
            }
            ++n2;
        }
        Collections.sort(users, new UserComparator());
        return users;
    }

    public Role createRole(String name, int type) {
        throw new UnsupportedOperationException("Roles are not supported by SimpleUserCredentialsService.");
    }

    public IStatus removeRole(String name) {
        throw new UnsupportedOperationException("Roles are not supported by SimpleUserCredentialsService.");
    }

    public Role getRole(String name) {
        throw new UnsupportedOperationException("Roles are not supported by SimpleUserCredentialsService.");
    }

    public Role[] getRoles(String filter) throws InvalidSyntaxException {
        throw new UnsupportedOperationException("Roles are not supported by SimpleUserCredentialsService.");
    }

    public User getUser(String key, String value) {
        String email;
        if (key.equals("login") || key.equals("uid")) {
            if (this.root.userProfileNodeExists(value)) {
                IOrionUserProfileNode userProfileNode = this.root.getUserProfileNode(value);
                return this.formUser(userProfileNode);
            }
        } else if (key.equals("email") && this.emailCache.containsKey(email = value.toLowerCase())) {
            String uid = this.emailCache.get(email);
            IOrionUserProfileNode userProfileNode = this.root.getUserProfileNode(uid);
            return this.formUser(userProfileNode);
        }
        return null;
    }

    private User formUser(IOrionUserProfileNode userProfileNode) {
        block8: {
            if (userProfileNode != null) break block8;
            return null;
        }
        try {
            String[] keys;
            String emailConfirmation;
            String blocked;
            String encryptedPassword = userProfileNode.get("password", "");
            String password = SimpleUserPasswordUtil.decryptPassword((String)encryptedPassword);
            String uid = userProfileNode.get("uid", "");
            String login = userProfileNode.get("login", "");
            String fullName = userProfileNode.get("name", "");
            User user = new User(uid, login, fullName, password);
            String email = userProfileNode.get("email", "");
            if (!email.equals("")) {
                user.setEmail(email);
            }
            if ((blocked = userProfileNode.get("blocked", "false")).equals("true")) {
                user.setBlocked(true);
            }
            if (!(emailConfirmation = userProfileNode.get("email_confirmation", "")).equals("")) {
                user.setConfirmationId(emailConfirmation);
            }
            if ((keys = userProfileNode.getUserProfileNode(USER_PROPERTIES).keys()).length > 0) {
                int i = 0;
                while (i < keys.length) {
                    String key = keys[i];
                    String value = userProfileNode.getUserProfileNode(USER_PROPERTIES).get(key, "");
                    user.addProperty(key, value);
                    ++i;
                }
            }
            return user;
        }
        catch (CoreException e) {
            LogHelper.log((Throwable)e);
            return null;
        }
    }

    public Authorization getAuthorization(User user) {
        if (user instanceof User) {
            return new WebIdeAuthorization(user);
        }
        return new EmptyAuthorization();
    }

    public Set<User> getUsersByProperty(String key, String value, boolean regExp, boolean ignoreCase) {
        Pattern p;
        HashSet<User> ret = new HashSet<User>();
        Pattern pattern = p = regExp ? Pattern.compile(value, 40) : null;
        if (key.equals("openid")) {
            for (Map.Entry<String, String> entry : this.openidCache.entrySet()) {
                boolean hasMatch;
                String openid = entry.getKey();
                String uid = entry.getValue();
                if (p != null) {
                    hasMatch = p.matcher(openid).matches();
                } else {
                    boolean bl = hasMatch = ignoreCase ? openid.equalsIgnoreCase(value) : openid.equals(value);
                }
                if (!hasMatch) continue;
                IOrionUserProfileNode userNode = this.root.getUserProfileNode(uid);
                ret.add(this.formUser(userNode));
            }
        } else {
            String[] stringArray = this.root.childrenNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String uid = stringArray[n2];
                IOrionUserProfileNode userNode = this.root.getUserProfileNode(uid);
                IOrionUserProfileNode propsNode = userNode.getUserProfileNode(USER_PROPERTIES);
                if (propsNode != null) {
                    try {
                        String propertyValue = propsNode.get(key, null);
                        if (propertyValue != null) {
                            boolean hasMatch;
                            if (p != null) {
                                hasMatch = p.matcher(propertyValue).matches();
                            } else {
                                boolean bl = hasMatch = ignoreCase ? propertyValue.equalsIgnoreCase(value) : propertyValue.equals(value);
                            }
                            if (hasMatch) {
                                ret.add(this.formUser(userNode));
                            }
                        }
                    }
                    catch (CoreException e) {
                        LogHelper.log((Throwable)e);
                    }
                }
                ++n2;
            }
        }
        return ret;
    }

    public class UserComparator
    implements Comparator<User> {
        @Override
        public int compare(User user1, User user2) {
            return user1.getLogin().toLowerCase().compareTo(user2.getLogin().toLowerCase());
        }
    }
}

