/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.servlets;

import java.util.Collection;
import org.eclipse.orion.internal.server.servlets.hosting.ISiteHostingService;
import org.eclipse.orion.internal.server.servlets.workspace.ProjectParentDecorator;
import org.eclipse.orion.internal.server.servlets.xfer.TransferResourceDecorator;
import org.eclipse.orion.server.core.IWebResourceDecorator;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator {
    public static volatile BundleContext bundleContext;
    public static final boolean DEBUG = true;
    public static final String LOCATION_FILE_SERVLET = "/file";
    public static final String LOCATION_WORKSPACE_SERVLET = "/workspace";
    public static final String PI_SERVER_SERVLETS = "org.eclipse.orion.server.servlets";
    public static final String PROP_USER_AREA = "org.eclipse.orion.server.core.userArea";
    static Activator singleton;
    private ServiceTracker<IWebResourceDecorator, IWebResourceDecorator> decoratorTracker;
    private ServiceTracker<ISiteHostingService, ISiteHostingService> siteHostingTracker;
    private ServiceRegistration<IWebResourceDecorator> transferDecoratorRegistration;
    private ServiceRegistration<IWebResourceDecorator> parentDecoratorRegistration;

    public static Activator getDefault() {
        return singleton;
    }

    public BundleContext getContext() {
        return bundleContext;
    }

    private synchronized ServiceTracker<IWebResourceDecorator, IWebResourceDecorator> getDecoratorTracker() {
        if (this.decoratorTracker == null) {
            this.decoratorTracker = new ServiceTracker(bundleContext, IWebResourceDecorator.class, null);
            this.decoratorTracker.open();
        }
        return this.decoratorTracker;
    }

    private synchronized ServiceTracker<ISiteHostingService, ISiteHostingService> getSiteHostingTracker() {
        if (this.siteHostingTracker == null) {
            this.siteHostingTracker = new ServiceTracker(bundleContext, ISiteHostingService.class, null);
            this.siteHostingTracker.open();
        }
        return this.siteHostingTracker;
    }

    public Collection<IWebResourceDecorator> getWebResourceDecorators() {
        ServiceTracker<IWebResourceDecorator, IWebResourceDecorator> tracker = this.getDecoratorTracker();
        return tracker.getTracked().values();
    }

    public ISiteHostingService getSiteHostingService() {
        ServiceTracker<ISiteHostingService, ISiteHostingService> tracker = this.getSiteHostingTracker();
        Collection hostingServices = tracker.getTracked().values();
        return hostingServices.size() == 0 ? null : (ISiteHostingService)hostingServices.iterator().next();
    }

    private void registerServices() {
        this.transferDecoratorRegistration = bundleContext.registerService(IWebResourceDecorator.class, (Object)new TransferResourceDecorator(), null);
        this.parentDecoratorRegistration = bundleContext.registerService(IWebResourceDecorator.class, (Object)new ProjectParentDecorator(), null);
    }

    public void start(BundleContext context) throws Exception {
        singleton = this;
        bundleContext = context;
        this.registerServices();
    }

    public void stop(BundleContext context) throws Exception {
        if (this.decoratorTracker != null) {
            this.decoratorTracker.close();
            this.decoratorTracker = null;
        }
        if (this.siteHostingTracker != null) {
            this.siteHostingTracker.close();
            this.siteHostingTracker = null;
        }
        this.unregisterServices();
        bundleContext = null;
    }

    private void unregisterServices() {
        if (this.transferDecoratorRegistration != null) {
            this.transferDecoratorRegistration.unregister();
            this.transferDecoratorRegistration = null;
        }
        if (this.parentDecoratorRegistration != null) {
            this.parentDecoratorRegistration.unregister();
            this.parentDecoratorRegistration = null;
        }
    }
}

