/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.manifest.v2.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.orion.server.cf.manifest.v2.Analyzer;
import org.eclipse.orion.server.cf.manifest.v2.AnalyzerException;
import org.eclipse.orion.server.cf.manifest.v2.InvalidAccessException;
import org.eclipse.orion.server.cf.manifest.v2.ManifestParseTree;
import org.eclipse.osgi.util.NLS;

public class ApplicationSanizator
implements Analyzer {
    Pattern memoryPattern = Pattern.compile("[1-9][0-9]*(M|MB|G|GB|m|mb|g|gb)");
    Pattern nonNegativePattern = Pattern.compile("[1-9][0-9]*");

    @Override
    public void apply(ManifestParseTree node) throws AnalyzerException {
        if (!node.has("applications")) {
            return;
        }
        try {
            ManifestParseTree applications = node.get("applications");
            for (ManifestParseTree application : applications.getChildren()) {
                String applicationName = application.get("name").getValue();
                ManifestParseTree memory = application.getOpt("memory");
                this.checkMemory(applicationName, memory);
                ManifestParseTree instances = application.getOpt("instances");
                this.checkInstances(applicationName, instances);
                ManifestParseTree timeout = application.getOpt("timeout");
                this.checkTimeout(applicationName, timeout);
                ManifestParseTree noRoute = application.getOpt("no-route");
                this.checkNoRoute(applicationName, noRoute);
            }
        }
        catch (InvalidAccessException ex) {
            throw new AnalyzerException(ex.getMessage());
        }
    }

    private void checkMemory(String applicationName, ManifestParseTree memory) throws AnalyzerException, InvalidAccessException {
        if (memory == null) {
            return;
        }
        String memoryValue = memory.getValue();
        Matcher matcher = this.memoryPattern.matcher(memoryValue);
        if (!matcher.matches()) {
            throw new AnalyzerException(NLS.bind((String)"Invalid memory limit for application \"{0}\". Supported measurement units are M/MB, G/GB.", (Object)applicationName));
        }
    }

    private void checkInstances(String applicationName, ManifestParseTree instances) throws AnalyzerException, InvalidAccessException {
        if (instances == null) {
            return;
        }
        String instancesValue = instances.getValue();
        Matcher matcher = this.nonNegativePattern.matcher(instancesValue);
        if (!matcher.matches()) {
            throw new AnalyzerException(NLS.bind((String)"Invalid \"instances\" value for application \"{0}\". Expected a non-negative integer value.", (Object)applicationName));
        }
    }

    private void checkTimeout(String applicationName, ManifestParseTree timeout) throws AnalyzerException, InvalidAccessException {
        if (timeout == null) {
            return;
        }
        String timeoutValue = timeout.getValue();
        Matcher matcher = this.nonNegativePattern.matcher(timeoutValue);
        if (!matcher.matches()) {
            throw new AnalyzerException(NLS.bind((String)"Invalid \"timeout\" value for application \"{0}\". Expected a non-negative integer value.", (Object)applicationName));
        }
    }

    private void checkNoRoute(String applicationName, ManifestParseTree noRoute) throws AnalyzerException, InvalidAccessException {
        if (noRoute == null) {
            return;
        }
        String noRouteValue = noRoute.getValue();
        if (!"true".equals(noRouteValue)) {
            throw new AnalyzerException(NLS.bind((String)"Invalid \"no-route\" value for application \"{0}\". Expected a string literal \"true\".", (Object)applicationName));
        }
    }
}

