/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.UUID;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.internal.filesystem.local.LocalFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.orion.server.cf.utils.Packager;

public class PackageUtils {
    public static void writeZip(IFileStore source, ZipOutputStream zos) throws IOException, CoreException {
        Packager packager = new Packager(source);
        packager.writeZip(source, zos);
    }

    public static File getApplicationPackage(IFileStore applicationStore) throws IOException, CoreException {
        if (applicationStore == null || !applicationStore.fetchInfo().exists()) {
            return null;
        }
        File tmp = null;
        ZipOutputStream zos = null;
        try {
            String randomName = UUID.randomUUID().toString();
            tmp = File.createTempFile(randomName, ".zip");
            if (applicationStore.getName().endsWith(".war")) {
                applicationStore.copy((IFileStore)new LocalFile(tmp), 2, null);
                File file = tmp;
                return file;
            }
            IFileStore[] iFileStoreArray = applicationStore.childStores(0, null);
            int n = iFileStoreArray.length;
            int n2 = 0;
            while (n2 < n) {
                IFileStore child = iFileStoreArray[n2];
                if (child.getName().endsWith(".war")) {
                    child.copy((IFileStore)new LocalFile(tmp), 2, null);
                    File file = tmp;
                    return file;
                }
                ++n2;
            }
            zos = new ZipOutputStream(new FileOutputStream(tmp));
            PackageUtils.writeZip(applicationStore, zos);
            File file = tmp;
            return file;
        }
        catch (Exception exception) {
            if (tmp != null) {
                tmp.delete();
            }
            return null;
        }
        finally {
            if (zos != null) {
                zos.close();
            }
        }
    }

    public static String getApplicationPackageType(IFileStore applicationStore) throws IOException, CoreException {
        if (applicationStore == null || !applicationStore.fetchInfo().exists()) {
            return "unknown";
        }
        if (applicationStore.getName().endsWith(".war")) {
            return "war";
        }
        IFileStore[] iFileStoreArray = applicationStore.childStores(0, null);
        int n = iFileStoreArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFileStore child = iFileStoreArray[n2];
            if (child.getName().endsWith(".war")) {
                return "war";
            }
            ++n2;
        }
        return "zip";
    }
}

