/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.events;

import org.eclipse.orion.server.core.PreferenceHelper;
import org.eclipse.orion.server.core.events.IEventService;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventService
implements IEventService {
    private MqttClient mqttClient;
    private MqttConnectOptions mqttConnectOptions;
    private Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.config");

    public EventService() {
        this.mqttClient = this.initClient();
    }

    private MqttClient initClient() {
        String password;
        String username;
        this.mqttConnectOptions = new MqttConnectOptions();
        String serverURI = PreferenceHelper.getString((String)"orion.events.uri", null);
        if (serverURI == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.warn("No MQTT message broker specified in the orion.conf with orion.events.uri");
            }
            return null;
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Using MQTT message broker at " + serverURI);
        }
        if ((username = PreferenceHelper.getString((String)"orion.events.username", null)) != null) {
            this.mqttConnectOptions.setUserName(username);
        }
        if ((password = PreferenceHelper.getString((String)"orion.events.password", null)) != null) {
            this.mqttConnectOptions.setPassword(password.toCharArray());
        }
        try {
            return new MqttClient(serverURI, MqttClient.generateClientId(), (MqttClientPersistence)new MemoryPersistence());
        }
        catch (MqttException e) {
            this.logger.warn("Failed to initialize MQTT event client", (Throwable)e);
            return null;
        }
    }

    public void publish(String topic, JSONObject message) {
        if (this.mqttClient == null) {
            return;
        }
        MqttMessage mqttMessage = new MqttMessage(message.toString().getBytes());
        try {
            this.mqttClient.connect(this.mqttConnectOptions);
            this.mqttClient.publish(topic, mqttMessage);
            this.mqttClient.disconnect();
        }
        catch (MqttException e) {
            this.logger.warn("Failure publishing event on topic: " + topic, (Object)(", message: " + message.toString()), (Object)e);
        }
        if (this.logger.isDebugEnabled()) {
            try {
                this.logger.debug("Published event on topic: " + topic + " message:\n" + message.toString(4));
            }
            catch (JSONException e) {
                this.logger.error(e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }
}

