/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.authentication.form;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.orion.server.authentication.Activator;
import org.eclipse.orion.server.core.LogHelper;
import org.eclipse.orion.server.core.PreferenceHelper;
import org.eclipse.orion.server.core.events.IEventService;
import org.eclipse.orion.server.user.profile.IOrionUserProfileNode;
import org.eclipse.orion.server.user.profile.IOrionUserProfileService;
import org.eclipse.orion.server.useradmin.IOrionCredentialsService;
import org.eclipse.orion.server.useradmin.UnsupportedUserStoreException;
import org.eclipse.orion.server.useradmin.User;
import org.json.JSONException;
import org.json.JSONObject;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormAuthHelper {
    private static IOrionCredentialsService userAdmin;
    private static IOrionUserProfileService userProfileService;
    private static IEventService eventService;

    public static LoginResult performAuthentication(HttpServletRequest req, HttpServletResponse resp) throws IOException, UnsupportedUserStoreException {
        Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.login");
        String login = req.getParameter("login");
        User user = FormAuthHelper.getUserForCredentials(login, req.getParameter("password"));
        if (user != null) {
            if (user.getBlocked()) {
                return LoginResult.BLOCKED;
            }
            String userId = user.getUid();
            if (logger.isInfoEnabled()) {
                logger.info("Login success: " + login);
            }
            req.getSession().setAttribute("user", (Object)userId);
            if (FormAuthHelper.getEventService() != null) {
                JSONObject message = new JSONObject();
                try {
                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.US);
                    Date date = new Date(System.currentTimeMillis());
                    message.put("event", (Object)"login");
                    message.put("published", (Object)format.format(date));
                    message.put("user", (Object)userId);
                }
                catch (JSONException e1) {
                    LogHelper.log((Throwable)e1);
                }
                FormAuthHelper.getEventService().publish("orion/login", message);
            }
            IOrionUserProfileNode userProfileNode = FormAuthHelper.getUserProfileService().getUserProfileNode(userId, "general");
            try {
                userProfileNode.put("lastlogintimestamp", new Long(System.currentTimeMillis()).toString(), false);
                userProfileNode.flush();
            }
            catch (CoreException e) {
                LogHelper.log((Throwable)e);
            }
            return LoginResult.OK;
        }
        if (login != null) {
            logger.info("Login failed: " + login);
        }
        return LoginResult.FAIL;
    }

    private static User getUserForCredentials(String login, String password) throws UnsupportedUserStoreException {
        if (userAdmin == null) {
            throw new UnsupportedUserStoreException();
        }
        User user = userAdmin.getUser("login", login);
        if (user != null && user.hasCredential("password", (Object)password)) {
            return user;
        }
        return null;
    }

    public static boolean canAddUsers() {
        boolean allowAnonymousAccountCreation;
        boolean bl = allowAnonymousAccountCreation = PreferenceHelper.getString((String)"orion.auth.user.creation", null) == null;
        return allowAnonymousAccountCreation ? (userAdmin == null ? false : userAdmin.canCreateUsers()) : false;
    }

    public static boolean forceEmail() {
        return PreferenceHelper.getString((String)"orion.auth.user.creation.force.email", (String)"false").equalsIgnoreCase("true");
    }

    public static String registrationURI() {
        return PreferenceHelper.getString((String)"orion.auth.registration.uri", null);
    }

    public static IOrionCredentialsService getDefaultUserAdmin() {
        return userAdmin;
    }

    public void setUserAdmin(IOrionCredentialsService userAdmin) {
        FormAuthHelper.userAdmin = userAdmin;
    }

    public void unsetUserAdmin(IOrionCredentialsService userAdmin) {
        if (userAdmin.equals(FormAuthHelper.userAdmin)) {
            FormAuthHelper.userAdmin = null;
        }
    }

    public static JSONObject getUserJson(String uid, String contextPath) throws JSONException {
        User user;
        JSONObject obj;
        block7: {
            obj = new JSONObject();
            obj.put("login", (Object)uid);
            user = userAdmin.getUser("uid", uid);
            if (user != null) break block7;
            return null;
        }
        try {
            Object lastLogin;
            IOrionUserProfileNode generalUserProfile = FormAuthHelper.getUserProfileService().getUserProfileNode(uid, "general");
            obj.put("uid", (Object)uid);
            obj.put("login", (Object)user.getLogin());
            obj.put("Location", (Object)(String.valueOf(contextPath) + user.getLocation()));
            obj.put("Name", (Object)user.getName());
            if (generalUserProfile.get("lastlogintimestamp", null) != null) {
                lastLogin = Long.parseLong(generalUserProfile.get("lastlogintimestamp", ""));
                obj.put("lastlogintimestamp", lastLogin);
            }
            if (generalUserProfile.get("diskusagetimestamp", null) != null) {
                lastLogin = Long.parseLong(generalUserProfile.get("diskusagetimestamp", ""));
                obj.put("diskusagetimestamp", lastLogin);
            }
            if (generalUserProfile.get("diskusage", null) != null) {
                lastLogin = generalUserProfile.get("diskusage", "");
                obj.put("diskusage", lastLogin);
            }
        }
        catch (IllegalArgumentException e) {
            LogHelper.log((Throwable)e);
        }
        catch (CoreException e) {
            LogHelper.log((Throwable)e);
        }
        return obj;
    }

    private static IOrionUserProfileService getUserProfileService() {
        return userProfileService;
    }

    public static void bindUserProfileService(IOrionUserProfileService _userProfileService) {
        userProfileService = _userProfileService;
    }

    public static void unbindUserProfileService(IOrionUserProfileService userProfileService) {
        userProfileService = null;
    }

    private static IEventService getEventService() {
        if (eventService == null) {
            BundleContext context = Activator.getBundleContext();
            ServiceReference eventServiceRef = context.getServiceReference(IEventService.class);
            if (eventServiceRef == null) {
                return null;
            }
            eventService = (IEventService)context.getService(eventServiceRef);
            if (eventService == null) {
                return null;
            }
        }
        return eventService;
    }

    public static enum LoginResult {
        OK,
        FAIL,
        BLOCKED;

    }
}

