/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.authentication.formopenid;

import java.io.IOException;
import java.util.Properties;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.orion.server.authentication.IAuthenticationService;
import org.eclipse.orion.server.authentication.formopenid.FormOpenIdLoginServlet;
import org.eclipse.orion.server.authentication.formopenid.FormOpenIdLogoutServlet;
import org.eclipse.orion.server.authentication.formopenid.ManageOpenidsServlet;
import org.eclipse.orion.server.core.LogHelper;
import org.json.JSONException;
import org.json.JSONObject;
import org.osgi.framework.Version;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;

public class FormOpenIdAuthenticationService
implements IAuthenticationService {
    private Properties defaultAuthenticationProperties;
    public static final String OPENIDS_PROPERTY = "openids";
    private boolean registered = false;

    public Properties getDefaultAuthenticationProperties() {
        return this.defaultAuthenticationProperties;
    }

    @Override
    public String authenticateUser(HttpServletRequest req, HttpServletResponse resp, Properties properties) throws IOException {
        String user = this.getAuthenticatedUser(req, resp, properties);
        if (user == null) {
            this.setNotAuthenticated(req, resp, properties);
        }
        return user;
    }

    @Override
    public String getAuthenticatedUser(HttpServletRequest req, HttpServletResponse resp, Properties properties) throws IOException {
        HttpSession s = req.getSession(true);
        return (String)s.getAttribute("user");
    }

    @Override
    public String getAuthType() {
        return "FORM";
    }

    @Override
    public void configure(Properties properties) {
        this.defaultAuthenticationProperties = properties;
    }

    private void setNotAuthenticated(HttpServletRequest req, HttpServletResponse resp, Properties properties) throws IOException {
        resp.setHeader("WWW-Authenticate", "FORM");
        resp.setStatus(401);
        String versionString = req.getHeader("Orion-Version");
        Version version = versionString == null ? null : new Version(versionString);
        String xRequestedWith = req.getHeader("X-Requested-With");
        if (version == null && !"XMLHttpRequest".equals(xRequestedWith)) {
            resp.sendRedirect(String.valueOf(req.getContextPath()) + "/mixloginstatic/LoginWindow.html?redirect=" + req.getRequestURL());
        } else {
            resp.setContentType("application/json; charset=UTF-8");
            JSONObject result = new JSONObject();
            try {
                result.put("SignInLocation", (Object)(String.valueOf(req.getContextPath()) + "/mixloginstatic/LoginWindow.html"));
                result.put("label", (Object)"Orion workspace server");
                result.put("SignInKey", (Object)"FORMOpenIdUser");
            }
            catch (JSONException e) {
                LogHelper.log((IStatus)new Status(4, "org.eclipse.orion.server.authentication", 1, "An error occured during authenitcation", (Throwable)e));
            }
            resp.getWriter().print(result.toString());
        }
    }

    public void setHttpService(HttpService httpService) {
        try {
            httpService.registerServlet("/mixlogin/manageopenids", (Servlet)new ManageOpenidsServlet(this), null, null);
            httpService.registerServlet("/login", (Servlet)new FormOpenIdLoginServlet(this), null, null);
            httpService.registerServlet("/logout", (Servlet)new FormOpenIdLogoutServlet(), null, null);
        }
        catch (ServletException e) {
            LogHelper.log((IStatus)new Status(4, "org.eclipse.orion.server.authentication", 1, "An error occured when registering servlets", (Throwable)e));
        }
        catch (NamespaceException e) {
            LogHelper.log((IStatus)new Status(4, "org.eclipse.orion.server.authentication", 1, "A namespace error occured when registering servlets", (Throwable)e));
        }
    }

    public void unsetHttpService(HttpService httpService) {
        if (httpService != null) {
            httpService.unregister("/mixlogin/manageopenids");
            httpService.unregister("/login");
            httpService.unregister("/logout");
            httpService = null;
        }
    }

    @Override
    public void setRegistered(boolean registered) {
        this.registered = registered;
    }

    @Override
    public boolean getRegistered() {
        return this.registered;
    }
}

