/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.commands;

import java.net.URI;
import java.net.URL;
import java.util.UUID;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.orion.server.cf.commands.AbstractCFCommand;
import org.eclipse.orion.server.cf.manifest.v2.InvalidAccessException;
import org.eclipse.orion.server.cf.manifest.v2.ManifestParseTree;
import org.eclipse.orion.server.cf.objects.App;
import org.eclipse.orion.server.cf.objects.Target;
import org.eclipse.orion.server.cf.utils.HttpUtil;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.osgi.util.NLS;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateRouteCommand
extends AbstractCFCommand {
    private final Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.cf");
    private String commandName;
    private App application;
    private String appName;
    private String appHost;
    private String domainGUID;

    public CreateRouteCommand(Target target, App app, String domainGUID) {
        super(target);
        Object[] bindings = new String[]{domainGUID};
        this.commandName = NLS.bind((String)"Create a new route (domain guid: {0})", (Object[])bindings);
        this.application = app;
        this.domainGUID = domainGUID;
    }

    @Override
    protected ServerStatus _doIt() {
        try {
            URI targetURI = URIUtil.toURI((URL)this.target.getUrl());
            URI routesURI = targetURI.resolve("/v2/routes");
            PostMethod createRouteMethod = new PostMethod(routesURI.toString());
            HttpUtil.configureHttpMethod((HttpMethod)createRouteMethod, this.target);
            JSONObject routeRequest = new JSONObject();
            routeRequest.put("space_guid", (Object)this.target.getSpace().getCFJSON().getJSONObject("metadata").getString("guid"));
            routeRequest.put("host", (Object)this.appHost);
            routeRequest.put("domain_guid", (Object)this.domainGUID);
            createRouteMethod.setRequestEntity((RequestEntity)new StringRequestEntity(routeRequest.toString(), "application/json", "utf-8"));
            return HttpUtil.executeMethod((HttpMethod)createRouteMethod);
        }
        catch (Exception e) {
            String msg = NLS.bind((String)"An error occured when performing operation {0}", (Object)this.commandName);
            this.logger.error(msg, (Throwable)e);
            return new ServerStatus(4, 500, msg, (Throwable)e);
        }
    }

    @Override
    protected IStatus validateParams() {
        try {
            ManifestParseTree manifest = this.application.getManifest();
            ManifestParseTree app = manifest.get("applications").get(0);
            this.appName = this.application.getName() != null ? this.application.getName() : app.get("name").getValue();
            ManifestParseTree hostNode = app.getOpt("host");
            this.appHost = hostNode != null ? hostNode.getValue() : String.valueOf(this.appName) + "-" + UUID.randomUUID();
            return Status.OK_STATUS;
        }
        catch (InvalidAccessException e) {
            return new ServerStatus(4, 400, e.getMessage(), null);
        }
    }
}

