/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.commands;

import java.net.URI;
import java.net.URL;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.orion.internal.server.servlets.file.NewFileServlet;
import org.eclipse.orion.internal.server.servlets.workspace.authorization.AuthorizationService;
import org.eclipse.orion.server.cf.commands.AbstractCFCommand;
import org.eclipse.orion.server.cf.manifest.v2.AnalyzerException;
import org.eclipse.orion.server.cf.manifest.v2.InvalidAccessException;
import org.eclipse.orion.server.cf.manifest.v2.ManifestParseTree;
import org.eclipse.orion.server.cf.manifest.v2.ParserException;
import org.eclipse.orion.server.cf.manifest.v2.TokenizerException;
import org.eclipse.orion.server.cf.manifest.v2.utils.ManifestUtils;
import org.eclipse.orion.server.cf.objects.Target;
import org.eclipse.orion.server.core.OrionConfiguration;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.orion.server.core.metastore.ProjectInfo;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParseManifestCommand
extends AbstractCFCommand {
    private final Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.cf");
    private String userId;
    private String contentLocation;
    private String commandName;
    private ManifestParseTree manifest;
    private IFileStore appStore;

    public ParseManifestCommand(Target target, String userId, String contentLocation) {
        super(target);
        this.userId = userId;
        this.contentLocation = contentLocation;
        this.commandName = NLS.bind((String)"Parse application manifest: {0}", (Object)contentLocation);
    }

    public ManifestParseTree getManifest() {
        return this.manifest;
    }

    public IFileStore getAppStore() {
        return this.appStore;
    }

    private ServerStatus canAccess(IPath contentPath) throws CoreException {
        String accessLocation = "/file/" + contentPath.toString();
        if (contentPath.segmentCount() < 1) {
            return new ServerStatus(4, 403, "Forbidden access to application contents", null);
        }
        if (!AuthorizationService.checkRights((String)this.userId, (String)accessLocation, (String)"GET")) {
            return new ServerStatus(4, 403, "Forbidden access to application contents", null);
        }
        return new ServerStatus(Status.OK_STATUS, 200);
    }

    private ServerStatus cannotFindManifest(IPath contentPath) {
        IPath manifestPath = contentPath.removeFirstSegments(2).append("manifest.yml");
        String msg = "Failed to find /" + manifestPath + ". If the manifest is in a different folder, please select the manifest file or folder before deploying.";
        return new ServerStatus(4, 400, msg, null);
    }

    @Override
    protected ServerStatus _doIt() {
        try {
            String path;
            URI targetURI;
            String targetBase;
            IPath contentPath = new Path(this.contentLocation).removeFirstSegments(1);
            ServerStatus accessStatus = this.canAccess(contentPath);
            if (!accessStatus.isOK()) {
                return accessStatus;
            }
            IFileStore fileStore = NewFileServlet.getFileStore(null, (IPath)contentPath);
            if (!fileStore.fetchInfo().isDirectory()) {
                fileStore = fileStore.getParent();
                contentPath = contentPath.removeLastSegments(1);
            }
            if (fileStore == null) {
                return this.cannotFindManifest(contentPath);
            }
            IFileStore manifestStore = fileStore.getChild("manifest.yml");
            if (!manifestStore.fetchInfo().exists()) {
                return this.cannotFindManifest(contentPath);
            }
            ProjectInfo project = OrionConfiguration.getMetaStore().readProject(contentPath.segment(0), contentPath.segment(1));
            IFileStore projectStore = NewFileServlet.getFileStore(null, (ProjectInfo)project);
            ManifestParseTree manifest = ManifestUtils.parse(projectStore, manifestStore, targetBase = (targetURI = URIUtil.toURI((URL)this.target.getUrl())).getHost().substring(4));
            ManifestParseTree app = manifest.get("applications").get(0);
            ManifestParseTree pathNode = app.getOpt("path");
            String string = path = pathNode != null ? pathNode.getValue() : "";
            if (path.isEmpty()) {
                path = ".";
            }
            try {
                IPath appStorePath = contentPath.append(path);
                accessStatus = this.canAccess(appStorePath);
                if (!accessStatus.isOK()) {
                    return accessStatus;
                }
                this.appStore = NewFileServlet.getFileStore(null, (IPath)appStorePath);
                if (this.appStore == null) {
                    String msg = NLS.bind((String)"Failed to find application content due to incorrect path parameter: {0}", (Object)appStorePath);
                    return new ServerStatus(4, 400, msg, null);
                }
                this.manifest = manifest;
            }
            catch (Exception exception) {
                return new ServerStatus(4, 400, "Failed to locate application contents as specified in the manifest.", null);
            }
            return new ServerStatus(Status.OK_STATUS, 200);
        }
        catch (TokenizerException e) {
            return new ServerStatus(4, 400, e.getMessage(), null);
        }
        catch (ParserException e) {
            return new ServerStatus(4, 400, e.getMessage(), null);
        }
        catch (AnalyzerException e) {
            return new ServerStatus(4, 400, e.getMessage(), null);
        }
        catch (InvalidAccessException e) {
            return new ServerStatus(4, 400, e.getMessage(), null);
        }
        catch (Exception e) {
            String msg = NLS.bind((String)"An error occured when performing operation {0}", (Object)this.commandName);
            this.logger.error(msg, (Throwable)e);
            return new ServerStatus(4, 500, msg, (Throwable)e);
        }
    }
}

