/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.manifest.v2.utils;

import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IPath;
import org.eclipse.orion.server.cf.manifest.v2.InvalidAccessException;
import org.eclipse.orion.server.cf.manifest.v2.ManifestParseTree;
import org.eclipse.orion.server.cf.manifest.v2.Token;
import org.eclipse.orion.server.cf.manifest.v2.utils.ManifestUtils;

public class InheritanceUtils {
    private static boolean hasApplication(ManifestParseTree applications, String applicationName) throws InvalidAccessException {
        for (ManifestParseTree application : applications.getChildren()) {
            if (!application.get("name").getValue().equals(applicationName)) continue;
            return true;
        }
        return false;
    }

    private static ManifestParseTree getApplication(ManifestParseTree applications, String applicationName) throws InvalidAccessException {
        for (ManifestParseTree application : applications.getChildren()) {
            if (!application.get("name").getValue().equals(applicationName)) continue;
            return application;
        }
        return null;
    }

    public static boolean isWithinSandbox(IFileStore sandbox, IFileStore current, IPath parent) {
        return sandbox.isParentOf(current.getParent().getFileStore(parent));
    }

    public static void inherit(ManifestParseTree parent, ManifestParseTree child) throws InvalidAccessException {
        if (parent.has("env")) {
            if (!child.has("env")) {
                ManifestParseTree env = new ManifestParseTree();
                env.getTokens().add(new Token("env", 4));
                child.getChildren().add(0, env);
            }
            ManifestParseTree childEnv = child.get("env");
            for (ManifestParseTree manifestParseTree : parent.get("env").getChildren()) {
                String var = manifestParseTree.getLabel();
                if (childEnv.has(var)) continue;
                childEnv.getChildren().add(manifestParseTree);
            }
        }
        for (ManifestParseTree node : parent.getChildren()) {
            if (ManifestUtils.isReserved(node)) continue;
            child.getChildren().add(node);
        }
        if (parent.has("applications")) {
            if (!child.has("applications")) {
                ManifestParseTree applications = new ManifestParseTree();
                applications.getTokens().add(new Token("applications", 4));
                child.getChildren().add(applications);
            }
            int inherited = 0;
            ManifestParseTree manifestParseTree = child.get("applications");
            for (ManifestParseTree parentApplication : parent.get("applications").getChildren()) {
                String app = parentApplication.get("name").getValue();
                if (!InheritanceUtils.hasApplication(manifestParseTree, app)) {
                    manifestParseTree.getChildren().add(inherited, parentApplication);
                    ++inherited;
                    continue;
                }
                ManifestParseTree application = InheritanceUtils.getApplication(manifestParseTree, app);
                for (ManifestParseTree property : parentApplication.getChildren()) {
                    if (application.has(property.getLabel())) continue;
                    application.getChildren().add(property);
                }
                if (!parentApplication.has("services")) continue;
                if (!application.has("services")) {
                    ManifestParseTree services = new ManifestParseTree();
                    services.getTokens().add(new Token("services", 4));
                    application.getChildren().add(services);
                }
                ManifestParseTree applicationServices = application.get("services");
                for (ManifestParseTree service : parentApplication.get("services").getChildren()) {
                    if (applicationServices.has(service.getLabel())) continue;
                    applicationServices.getChildren().add(service);
                }
            }
        }
    }
}

