/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.servlets.file;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.orion.internal.server.servlets.ServletResourceHandler;
import org.eclipse.orion.server.core.HashUtilities;
import org.eclipse.orion.server.core.IOUtilities;
import org.eclipse.osgi.util.NLS;

class GenericFileHandler
extends ServletResourceHandler<IFileStore> {
    private final ServletContext context;

    public GenericFileHandler(ServletContext context) {
        this.context = context;
    }

    protected boolean handleFileContents(HttpServletRequest request, HttpServletResponse response, IFileStore file) throws CoreException, IOException, NoSuchAlgorithmException {
        switch (GenericFileHandler.getMethod(request)) {
            case GET: {
                this.setCacheHeaders(response, file);
                response.setHeader("Content-Type", this.context.getMimeType(file.getName()));
                response.setHeader("Accept-Patch", "application/json-patch; charset=UTF-8");
                IOUtilities.pipe((InputStream)file.openInputStream(0, null), (OutputStream)response.getOutputStream(), (boolean)true, (boolean)false);
                break;
            }
            case PUT: {
                this.setCacheHeaders(response, file);
                IOUtilities.pipe((InputStream)request.getInputStream(), (OutputStream)file.openOutputStream(0, null), (boolean)false, (boolean)true);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private void setCacheHeaders(HttpServletResponse response, IFileStore file) throws NoSuchAlgorithmException, IOException, CoreException {
        response.setHeader("Cache-Control", "no-cache");
        response.setHeader("ETag", GenericFileHandler.generateFileETag(file));
    }

    @Override
    public boolean handleRequest(HttpServletRequest request, HttpServletResponse response, IFileStore file) throws ServletException {
        block6: {
            String fileETag;
            block5: {
                try {
                    fileETag = GenericFileHandler.generateFileETag(file);
                    if (!this.handleIfMatchHeader(request, response, fileETag)) break block5;
                    return true;
                }
                catch (Exception e) {
                    if (!this.handleAuthFailure(request, response, e)) {
                        throw new ServletException(NLS.bind((String)"Error retrieving file: {0}", (Object)file), (Throwable)e);
                    }
                    return true;
                }
            }
            if (!this.handleIfNoneMatchHeader(request, response, fileETag)) break block6;
            return true;
        }
        return this.handleFileContents(request, response, file);
    }

    public static String generateFileETag(IFileStore file) throws NoSuchAlgorithmException, IOException, CoreException {
        if (!file.fetchInfo().exists()) {
            return "";
        }
        return HashUtilities.getHash((InputStream)file.openInputStream(0, null), (boolean)true, (String)"SHA-1");
    }

    protected boolean handleIfMatchHeader(HttpServletRequest request, HttpServletResponse response, String etag) {
        String ifMatchHeader = request.getHeader("If-Match");
        if (ifMatchHeader != null && !ifMatchHeader.equals(etag)) {
            response.setStatus(412);
            return true;
        }
        return false;
    }

    protected boolean handleIfNoneMatchHeader(HttpServletRequest request, HttpServletResponse response, String etag) {
        String ifNoneMatchHeader = request.getHeader("If-None-Match");
        if (ifNoneMatchHeader != null && ifNoneMatchHeader.equals(etag)) {
            switch (GenericFileHandler.getMethod(request)) {
                case GET: 
                case HEAD: {
                    response.setStatus(304);
                    break;
                }
                default: {
                    response.setStatus(412);
                }
            }
            response.setHeader("Cache-Control", "no-cache");
            response.setHeader("ETag", etag);
            return true;
        }
        return false;
    }
}

