/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.servlets.workspace;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.StringTokenizer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.orion.internal.server.servlets.ServletResourceHandler;
import org.eclipse.orion.internal.server.servlets.file.NewFileServlet;
import org.eclipse.orion.internal.server.servlets.workspace.MetadataInfoResourceHandler;
import org.eclipse.orion.internal.server.servlets.workspace.ProjectInfoResourceHandler;
import org.eclipse.orion.internal.server.servlets.workspace.ServletTestingSupport;
import org.eclipse.orion.server.core.LogHelper;
import org.eclipse.orion.server.core.OrionConfiguration;
import org.eclipse.orion.server.core.PreferenceHelper;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.orion.server.core.metastore.IMetaStore;
import org.eclipse.orion.server.core.metastore.MetadataInfo;
import org.eclipse.orion.server.core.metastore.ProjectInfo;
import org.eclipse.orion.server.core.metastore.WorkspaceInfo;
import org.eclipse.orion.server.servlets.OrionServlet;
import org.eclipse.osgi.util.NLS;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class WorkspaceResourceHandler
extends MetadataInfoResourceHandler<WorkspaceInfo> {
    static final int CREATE_COPY = 1;
    static final int CREATE_MOVE = 2;
    static final int CREATE_NO_OVERWRITE = 4;
    private final ServletResourceHandler<IStatus> statusHandler;

    public static void computeProjectLocation(HttpServletRequest request, ProjectInfo project, String location, boolean init) throws CoreException {
        URI contentURI;
        String user = request.getRemoteUser();
        if (location == null) {
            contentURI = WorkspaceResourceHandler.generateProjectLocation(project, user);
        } else {
            try {
                contentURI = new URI(location);
                EFS.getFileSystem((String)contentURI.getScheme());
            }
            catch (Exception exception) {
                contentURI = new File(location).toURI();
            }
            if (init) {
                project.setContentLocation(contentURI);
                IFileStore child = NewFileServlet.getFileStore(request, project);
                child.mkdir(0, null);
            }
        }
        project.setContentLocation(contentURI);
    }

    static URI computeProjectURI(URI parentLocation, WorkspaceInfo workspace, ProjectInfo project) {
        return URIUtil.append((URI)parentLocation, (String)("../file/" + workspace.getUniqueId() + '/' + project.getFullName() + '/'));
    }

    private static URI generateProjectLocation(ProjectInfo project, String user) throws CoreException {
        IFileStore projectStore = OrionConfiguration.getMetaStore().getDefaultContentLocation(project);
        if (projectStore.fetchInfo().exists()) {
            projectStore.delete(0, null);
        }
        projectStore.mkdir(0, null);
        return projectStore.toURI();
    }

    public static ProjectInfo projectForMetadataLocation(IMetaStore store, String sourceLocation) throws CoreException {
        URI sourceURI;
        if (sourceLocation == null) {
            return null;
        }
        try {
            sourceURI = new URI(sourceLocation);
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
        String pathString = sourceURI.getPath();
        if (pathString == null) {
            return null;
        }
        Path path = new Path(pathString);
        if (path.segmentCount() < 4) {
            return null;
        }
        String workspaceId = path.segment(1);
        String projectName = path.segment(3);
        return store.readProject(workspaceId, projectName);
    }

    public static void removeProject(String user, WorkspaceInfo workspace, ProjectInfo project) throws CoreException {
        URI contentURI = project.getContentLocation();
        IFileStore projectStore = OrionConfiguration.getMetaStore().getDefaultContentLocation(project);
        URI defaultLocation = projectStore.toURI();
        if (URIUtil.sameURI((URI)defaultLocation, (URI)contentURI)) {
            projectStore.delete(0, null);
        }
        OrionConfiguration.getMetaStore().deleteProject(workspace.getUniqueId(), project.getFullName());
    }

    public static JSONObject toJSON(WorkspaceInfo workspace, URI requestLocation, URI baseLocation) {
        JSONObject result = MetadataInfoResourceHandler.toJSON((MetadataInfo)workspace);
        JSONArray projects = new JSONArray();
        URI workspaceLocation = URIUtil.append((URI)baseLocation, (String)workspace.getUniqueId());
        URI projectBaseLocation = URIUtil.append((URI)workspaceLocation, (String)"project");
        JSONArray children = new JSONArray();
        IMetaStore metaStore = OrionConfiguration.getMetaStore();
        for (String projectName : workspace.getProjectNames()) {
            try {
                ProjectInfo project = metaStore.readProject(workspace.getUniqueId(), projectName);
                JSONObject projectObject = new JSONObject();
                projectObject.put("Id", (Object)project.getUniqueId());
                projectObject.put("Location", (Object)URIUtil.append((URI)projectBaseLocation, (String)projectName));
                projects.put((Object)projectObject);
                IFileStore projectStore = null;
                try {
                    projectStore = project.getProjectStore();
                }
                catch (CoreException coreException) {}
                JSONObject child = new JSONObject();
                child.put("Name", (Object)project.getFullName());
                child.put("Directory", true);
                URI contentLocation = WorkspaceResourceHandler.computeProjectURI(baseLocation, workspace, project);
                child.put("Location", (Object)contentLocation);
                try {
                    if (projectStore != null) {
                        child.put("LocalTimeStamp", projectStore.fetchInfo(0, null).getLastModified());
                    }
                }
                catch (CoreException coreException) {}
                try {
                    child.put("ChildrenLocation", (Object)new URI(contentLocation.getScheme(), contentLocation.getUserInfo(), contentLocation.getHost(), contentLocation.getPort(), contentLocation.getPath(), "depth=1", contentLocation.getFragment()));
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException(e);
                }
                child.put("Id", (Object)project.getUniqueId());
                children.put((Object)child);
            }
            catch (Exception exception) {}
        }
        try {
            result.put("Location", (Object)workspaceLocation);
            result.put("ChildrenLocation", (Object)workspaceLocation);
            result.put("Projects", (Object)projects);
            result.put("Directory", (Object)"true");
            result.put("Children", (Object)children);
        }
        catch (JSONException jSONException) {}
        return result;
    }

    public WorkspaceResourceHandler(ServletResourceHandler<IStatus> statusHandler) {
        this.statusHandler = statusHandler;
    }

    private int getCreateOptions(HttpServletRequest request) {
        int result = 0;
        String optionString = request.getHeader("X-Create-Options");
        if (optionString != null) {
            String[] stringArray = optionString.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String option = stringArray[n2];
                if ("copy".equalsIgnoreCase(option)) {
                    result |= 1;
                } else if ("move".equalsIgnoreCase(option)) {
                    result |= 2;
                } else if ("no-overwrite".equalsIgnoreCase(option)) {
                    result |= 4;
                }
                ++n2;
            }
        }
        return result;
    }

    private boolean getInit(JSONObject toAdd) {
        return toAdd.optBoolean("CreateIfDoesntExist");
    }

    private boolean handleAddOrRemoveProject(HttpServletRequest request, HttpServletResponse response, WorkspaceInfo workspace) throws IOException, JSONException, ServletException {
        JSONObject data = OrionServlet.readJSONRequest(request);
        if (!data.isNull("Remove")) {
            return this.handleRemoveProject(request, response, workspace);
        }
        int options = this.getCreateOptions(request);
        if ((options & 3) != 0) {
            return this.handleCopyMoveProject(request, response, workspace, data);
        }
        this.handleAddProject(request, response, workspace, data);
        return true;
    }

    private boolean handleCopyMoveProject(HttpServletRequest request, HttpServletResponse response, WorkspaceInfo workspace, JSONObject data) throws ServletException, IOException {
        String sourceLocation = data.optString("Location");
        IFileStore source = null;
        try {
            if (sourceLocation != null) {
                if (sourceLocation.startsWith("/workspace")) {
                    ProjectInfo sourceProject = WorkspaceResourceHandler.projectForMetadataLocation(this.getMetaStore(), WorkspaceResourceHandler.toOrionLocation(request, sourceLocation));
                    if (sourceProject != null) {
                        source = sourceProject.getProjectStore();
                    }
                } else {
                    source = this.resolveSourceLocation(request, sourceLocation);
                }
            }
        }
        catch (Exception e) {
            this.handleError(request, response, 400, NLS.bind((String)"Invalid source location: {0}", (Object)sourceLocation), e);
            return true;
        }
        if (source == null) {
            this.handleError(request, response, 400, NLS.bind((String)"Source does not exist: {0}", (Object)sourceLocation));
            return true;
        }
        int options1 = this.getCreateOptions(request);
        if (!this.validateOptions(request, response, options1)) {
            return true;
        }
        String destinationName = request.getHeader("Slug");
        try {
            if (data.has("Name")) {
                destinationName = data.getString("Name");
            }
        }
        catch (JSONException jSONException) {}
        if (!this.validateProjectName(workspace, destinationName, request, response)) {
            return true;
        }
        if ((options1 & 2) != 0) {
            return this.handleMoveProject(request, response, workspace, source, sourceLocation, destinationName);
        }
        if ((options1 & 1) != 0) {
            JSONObject projectObject = new JSONObject();
            try {
                projectObject.put("Name", (Object)destinationName);
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
            ProjectInfo destinationProject = this.createProject(request, response, workspace, projectObject);
            String sourceName = source.getName();
            try {
                source.copy(destinationProject.getProjectStore(), 2, null);
            }
            catch (CoreException coreException) {
                this.handleError(request, response, 500, NLS.bind((String)"Error copying project {0} to {1}", (Object)sourceName, (Object)destinationName));
                return true;
            }
            URI baseLocation = WorkspaceResourceHandler.getURI(request);
            JSONObject result = ProjectInfoResourceHandler.toJSON(workspace, destinationProject, baseLocation);
            OrionServlet.writeJSONResponse(request, response, result);
            response.setHeader("Location", result.optString("Location", ""));
            response.setStatus(201);
            return true;
        }
        return false;
    }

    private ProjectInfo handleAddProject(HttpServletRequest request, HttpServletResponse response, WorkspaceInfo workspace, JSONObject data) throws IOException, ServletException {
        ProjectInfo project = this.createProject(request, response, workspace, data);
        if (project == null) {
            return null;
        }
        URI baseLocation = WorkspaceResourceHandler.getURI(request);
        JSONObject result = ProjectInfoResourceHandler.toJSON(workspace, project, baseLocation);
        OrionServlet.writeJSONResponse(request, response, result);
        response.setHeader("Location", result.optString("Location"));
        response.setStatus(201);
        return project;
    }

    private ProjectInfo createProject(HttpServletRequest request, HttpServletResponse response, WorkspaceInfo workspace, JSONObject data) throws ServletException {
        JSONObject toAdd = data;
        String id = toAdd.optString("Id", null);
        String name = toAdd.optString("Name", null);
        if (name == null) {
            name = request.getHeader("Slug");
        }
        if (!this.validateProjectName(workspace, name, request, response)) {
            return null;
        }
        ProjectInfo project = new ProjectInfo();
        if (id != null) {
            project.setUniqueId(id);
        }
        project.setFullName(name);
        project.setWorkspaceId(workspace.getUniqueId());
        String content = toAdd.optString("ContentLocation", null);
        if (!this.isAllowedLinkDestination(content, request.getRemoteUser())) {
            String msg = NLS.bind((String)"Cannot link to server path {0}. Use the orion.file.allowedPaths property to specify server locations where content can be linked.", (Object)content);
            this.statusHandler.handleRequest(request, response, (IStatus)new ServerStatus(4, 403, msg, null));
            return null;
        }
        try {
            this.getMetaStore().createProject(project);
        }
        catch (CoreException e) {
            String msg = "Error persisting project state";
            this.statusHandler.handleRequest(request, response, (IStatus)new ServerStatus(4, 500, msg, (Throwable)e));
            return null;
        }
        try {
            WorkspaceResourceHandler.computeProjectLocation(request, project, content, this.getInit(toAdd));
            this.getMetaStore().updateProject(project);
        }
        catch (CoreException e) {
            boolean authFail = this.handleAuthFailure(request, response, (Exception)((Object)e));
            try {
                this.getMetaStore().deleteProject(workspace.getUniqueId(), project.getFullName());
            }
            catch (CoreException e1) {
                LogHelper.log((Throwable)e1);
            }
            if (authFail) {
                return null;
            }
            String msg = NLS.bind((String)"Cannot create project: {0}", (Object)project.getFullName());
            this.statusHandler.handleRequest(request, response, (IStatus)new ServerStatus(4, 500, msg, (Throwable)e));
            return null;
        }
        return project;
    }

    private boolean handleError(HttpServletRequest request, HttpServletResponse response, int httpCode, String message) throws ServletException {
        return this.handleError(request, response, httpCode, message, null);
    }

    private boolean handleError(HttpServletRequest request, HttpServletResponse response, int httpCode, String message, Throwable cause) throws ServletException {
        return this.statusHandler.handleRequest(request, response, (IStatus)new ServerStatus(4, httpCode, message, cause));
    }

    private boolean handleGetWorkspaceMetadata(HttpServletRequest request, HttpServletResponse response, WorkspaceInfo workspace) throws IOException {
        URI baseLocation;
        URI requestLocation = WorkspaceResourceHandler.getURI(request);
        try {
            baseLocation = new URI(requestLocation.getScheme(), null, request.getServletPath(), null, null);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        OrionServlet.writeJSONResponse(request, response, WorkspaceResourceHandler.toJSON(workspace, requestLocation, baseLocation));
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean handleMoveProject(HttpServletRequest request, HttpServletResponse response, WorkspaceInfo workspace, IFileStore source, String sourceLocation, String destinationName) throws ServletException, IOException {
        String sourceName = source.getName();
        try {
            IMetaStore metaStore = this.getMetaStore();
            ProjectInfo projectInfo = metaStore.readProject(workspace.getUniqueId(), sourceName);
            boolean created = false;
            if (projectInfo == null) {
                JSONObject data = new JSONObject();
                try {
                    data.put("Name", (Object)destinationName);
                }
                catch (JSONException jSONException) {}
                projectInfo = this.createProject(request, response, workspace, data);
                if (projectInfo == null) {
                    return true;
                }
                source.move(projectInfo.getProjectStore(), 2, null);
                created = true;
            } else {
                projectInfo.setFullName(destinationName);
                metaStore.updateProject(projectInfo);
            }
            URI baseLocation = WorkspaceResourceHandler.getURI(request);
            JSONObject result = ProjectInfoResourceHandler.toJSON(workspace, projectInfo, baseLocation);
            OrionServlet.writeJSONResponse(request, response, result);
            response.setHeader("Location", sourceLocation);
            response.setStatus(created ? 201 : 200);
            return true;
        }
        catch (CoreException e) {
            String msg = NLS.bind((String)"Error persisting project state: {0}", (Object)sourceName);
            return this.handleError(request, response, 500, msg, e);
        }
    }

    private boolean handlePutWorkspaceMetadata(HttpServletRequest request, HttpServletResponse response, WorkspaceInfo workspace) {
        return false;
    }

    private boolean handleRemoveProject(HttpServletRequest request, HttpServletResponse response, WorkspaceInfo workspace) throws IOException, JSONException, ServletException {
        ProjectInfo project;
        block4: {
            Path path = new Path(request.getPathInfo());
            if (path.segmentCount() != 3) {
                return false;
            }
            String workspaceId = path.segment(0);
            String projectName = path.segment(2);
            try {
                project = this.getMetaStore().readProject(workspaceId, projectName);
                if (project != null) break block4;
                return true;
            }
            catch (CoreException e) {
                ServerStatus error = new ServerStatus(4, 500, "Error removing project", (Throwable)e);
                LogHelper.log((IStatus)error);
                return this.statusHandler.handleRequest(request, response, (IStatus)error);
            }
        }
        WorkspaceResourceHandler.removeProject(request.getRemoteUser(), workspace, project);
        return true;
    }

    @Override
    public boolean handleRequest(HttpServletRequest request, HttpServletResponse response, WorkspaceInfo workspace) throws ServletException {
        if (workspace == null) {
            return this.statusHandler.handleRequest(request, response, (IStatus)new Status(4, "org.eclipse.orion.server.servlets", "Workspace not specified"));
        }
        try {
            switch (WorkspaceResourceHandler.getMethod(request)) {
                case GET: {
                    return this.handleGetWorkspaceMetadata(request, response, workspace);
                }
                case PUT: {
                    return this.handlePutWorkspaceMetadata(request, response, workspace);
                }
                case POST: {
                    return this.handleAddOrRemoveProject(request, response, workspace);
                }
                case DELETE: {
                    return this.handleRemoveProject(request, response, workspace);
                }
            }
        }
        catch (IOException e) {
            String msg = NLS.bind((String)"Error handling request against workspace {0}", (Object)workspace.getUniqueId());
            this.statusHandler.handleRequest(request, response, (IStatus)new Status(4, "org.eclipse.orion.server.servlets", msg, (Throwable)e));
        }
        catch (JSONException e) {
            return this.statusHandler.handleRequest(request, response, (IStatus)new ServerStatus(4, 400, "Syntax error in request", (Throwable)e));
        }
        return false;
    }

    private boolean isAllowedLinkDestination(String content, String user) {
        String userArea;
        if (content == null) {
            return true;
        }
        String prefixes = PreferenceHelper.getString((String)"orion.file.allowedPaths");
        if (prefixes == null) {
            prefixes = ServletTestingSupport.allowedPrefixes;
        }
        if (prefixes != null) {
            StringTokenizer t = new StringTokenizer(prefixes, ",");
            while (t.hasMoreTokens()) {
                String prefix = t.nextToken();
                if (!content.startsWith(prefix)) continue;
                return !content.contains("..");
            }
        }
        URI contentURI = null;
        try {
            URI candidate = new URI(content);
            String scheme = candidate.getScheme();
            if (scheme != null) {
                if (EFS.getFileSystem((String)scheme) != null) {
                    contentURI = candidate;
                }
                if (!"file".equals(scheme)) {
                    return true;
                }
            }
        }
        catch (URISyntaxException uRISyntaxException) {
        }
        catch (CoreException coreException) {}
        if ((userArea = System.getProperty("org.eclipse.orion.server.core.userArea")) != null) {
            IPath path = new Path(userArea).append(user);
            if (contentURI == null) {
                contentURI = new File(content).toURI();
            }
            if (contentURI.toString().startsWith(path.toFile().toURI().toString())) {
                return true;
            }
        }
        return false;
    }

    private boolean validateOptions(HttpServletRequest request, HttpServletResponse response, int options) throws ServletException {
        int copyMove = 3;
        if ((options & copyMove) == copyMove) {
            this.handleError(request, response, 400, "Syntax error in request");
            return false;
        }
        return true;
    }

    private boolean validateProjectName(WorkspaceInfo workspace, String name, HttpServletRequest request, HttpServletResponse response) throws ServletException {
        if (name == null || name.trim().length() == 0) {
            this.statusHandler.handleRequest(request, response, (IStatus)new ServerStatus(4, 400, "Project name cannot be empty", null));
            return false;
        }
        if (name.contains("/") || name.equals("workspace") || name.endsWith(".json")) {
            this.statusHandler.handleRequest(request, response, (IStatus)new ServerStatus(4, 400, NLS.bind((String)"Invalid project name: {0}", (Object)name), null));
            return false;
        }
        try {
            if (this.getMetaStore().readProject(workspace.getUniqueId(), name) != null) {
                this.statusHandler.handleRequest(request, response, (IStatus)new ServerStatus(4, 400, NLS.bind((String)"Duplicate project name: {0}", (Object)name), null));
                return false;
            }
        }
        catch (CoreException e) {
            LogHelper.log((Throwable)e);
        }
        return true;
    }
}

