/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.commands;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.orion.server.cf.CFExtServiceHelper;
import org.eclipse.orion.server.cf.commands.ICFCommand;
import org.eclipse.orion.server.cf.objects.Cloud;
import org.eclipse.orion.server.cf.objects.Target;
import org.eclipse.orion.server.core.ServerStatus;

public abstract class AbstractCFCommand
implements ICFCommand {
    protected Target target;
    private Cloud cloud;
    private boolean wasRun = false;

    protected AbstractCFCommand(Target target) {
        this.target = target;
    }

    protected AbstractCFCommand(Cloud cloud) {
        this.cloud = cloud;
    }

    public Cloud getCloud() {
        if (this.target != null) {
            return this.target.getCloud();
        }
        return this.cloud;
    }

    public Target getTarget() {
        return this.target;
    }

    @Override
    public IStatus doIt() {
        IStatus status = this.validateParams();
        if (!status.isOK()) {
            return status;
        }
        ServerStatus doItStatus = this._doIt();
        ServerStatus result = this.retryIfNeeded(doItStatus);
        this.wasRun = true;
        return result;
    }

    private ServerStatus retryIfNeeded(ServerStatus doItStatus) {
        CFExtServiceHelper helper = CFExtServiceHelper.getDefault();
        if (doItStatus.getHttpCode() == 401 && this.target.getCloud().getAccessToken() != null && helper != null && helper.getService() != null) {
            this.target.getCloud().setAccessToken(helper.getService().getToken(this.target.getCloud()));
            return this._doIt();
        }
        return doItStatus;
    }

    protected abstract ServerStatus _doIt();

    protected void assertWasRun() {
        Assert.isTrue((boolean)this.wasRun);
    }

    protected IStatus validateParams() {
        return Status.OK_STATUS;
    }
}

