/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.commands;

import java.net.URI;
import java.net.URL;
import java.util.Iterator;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.orion.server.cf.commands.AbstractCFCommand;
import org.eclipse.orion.server.cf.commands.GetAppCommand;
import org.eclipse.orion.server.cf.objects.Log;
import org.eclipse.orion.server.cf.objects.Target;
import org.eclipse.orion.server.cf.utils.HttpUtil;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.osgi.util.NLS;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetLogsCommand
extends AbstractCFCommand {
    private final Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.cf");
    private String commandName = "Get App Logs";
    private String appName;
    private String baseRequestLocation;

    public GetLogsCommand(Target target, String appName, String baseRequestLocation) {
        super(target);
        this.appName = appName;
        this.baseRequestLocation = baseRequestLocation;
    }

    @Override
    public ServerStatus _doIt() {
        try {
            GetAppCommand getAppCommand = new GetAppCommand(this.target, this.appName);
            IStatus getAppStatus = getAppCommand.doIt();
            if (!getAppStatus.isOK()) {
                return (ServerStatus)getAppStatus;
            }
            String appUrl = getAppCommand.getApp().getAppJSON().getString("url");
            JSONObject jsonResp = new JSONObject();
            this.setRunningInstances(jsonResp, appUrl);
            this.setCrashedInstance(jsonResp, appUrl);
            return new ServerStatus(Status.OK_STATUS, 200, jsonResp);
        }
        catch (Exception e) {
            String msg = NLS.bind((String)"An error occured when performing operation {0}", (Object)this.commandName);
            this.logger.error(msg, (Throwable)e);
            return new ServerStatus(4, 500, msg, (Throwable)e);
        }
    }

    private ServerStatus setRunningInstances(JSONObject jsonResp, String appUrl) {
        try {
            URI targetURI = URIUtil.toURI((URL)this.target.getUrl());
            String runningInstancesUrl = String.valueOf(appUrl) + "/instances";
            URI runningInstancesURI = targetURI.resolve(runningInstancesUrl);
            GetMethod getRunningInstancesMethod = new GetMethod(runningInstancesURI.toString());
            HttpUtil.configureHttpMethod((HttpMethod)getRunningInstancesMethod, this.target);
            ServerStatus getStatus = HttpUtil.executeMethod((HttpMethod)getRunningInstancesMethod);
            if (!getStatus.isOK()) {
                return getStatus;
            }
            JSONObject runningInstances = getStatus.getJsonData();
            Iterator iterator = runningInstances.keys();
            while (iterator.hasNext()) {
                JSONArray logsJSON = new JSONArray();
                String runningInstanceNo = (String)iterator.next();
                ServerStatus prepareJSONStatus = this.prepareJSONResp(logsJSON, runningInstanceNo, appUrl);
                if (!prepareJSONStatus.isOK()) continue;
                jsonResp.put(runningInstanceNo, (Object)logsJSON);
            }
        }
        catch (Exception e) {
            return new ServerStatus(4, 500, null, (Throwable)e);
        }
        return new ServerStatus(Status.OK_STATUS, 200);
    }

    private ServerStatus setCrashedInstance(JSONObject jsonResp, String appUrl) {
        try {
            URI targetURI = URIUtil.toURI((URL)this.target.getUrl());
            String crashedInstancesUrl = String.valueOf(appUrl) + "/crashes";
            URI crashedInstancesURI = targetURI.resolve(crashedInstancesUrl);
            GetMethod getCrashedInstancesMethod = new GetMethod(crashedInstancesURI.toString());
            HttpUtil.configureHttpMethod((HttpMethod)getCrashedInstancesMethod, this.target);
            ServerStatus getStatus = HttpUtil.executeMethod((HttpMethod)getCrashedInstancesMethod);
            if (!getStatus.isOK()) {
                return getStatus;
            }
            String response = getStatus.getJsonData().getString("response");
            JSONArray crashedInstances = new JSONArray(response);
            JSONArray logsJSON = new JSONArray();
            if (crashedInstances.length() > 0) {
                JSONObject crashedInstance = crashedInstances.getJSONObject(crashedInstances.length() - 1);
                this.prepareJSONResp(logsJSON, crashedInstance.getString("instance"), appUrl);
                jsonResp.put("Last Crash", (Object)logsJSON);
            }
        }
        catch (Exception e) {
            return new ServerStatus(4, 500, null, (Throwable)e);
        }
        return new ServerStatus(Status.OK_STATUS, 200);
    }

    private ServerStatus prepareJSONResp(JSONArray logsJSON, String instance, String appUrl) {
        try {
            String instanceLogsAppUrl = String.valueOf(appUrl) + "/instances/" + instance + "/files/logs";
            URI targetURI = URIUtil.toURI((URL)this.target.getUrl());
            URI instanceLogsAppURI = targetURI.resolve(instanceLogsAppUrl);
            GetMethod getInstanceLogsMethod = new GetMethod(instanceLogsAppURI.toString());
            HttpUtil.configureHttpMethod((HttpMethod)getInstanceLogsMethod, this.target);
            ServerStatus getStatus = HttpUtil.executeMethod((HttpMethod)getInstanceLogsMethod);
            if (!getStatus.isOK()) {
                return getStatus;
            }
            String response = getStatus.getJsonData().optString("response");
            if (response == null) {
                return new ServerStatus(4, 500, "Log request: invalid response from the server", getStatus.getJsonData(), null);
            }
            String[] logFiles = response.split("\n");
            URI baseUri = new URI(this.baseRequestLocation.endsWith("/") ? this.baseRequestLocation : String.valueOf(this.baseRequestLocation) + "/");
            int i = 0;
            while (i < logFiles.length) {
                String logFileEntry = logFiles[i];
                String[] logFileEntryParts = logFileEntry.split("\\s+");
                if (logFileEntryParts.length == 2) {
                    Log log = new Log(this.appName, logFileEntryParts[0]);
                    log.setLocation(baseUri.resolve(log.getName()));
                    log.setSize(logFileEntryParts[1]);
                    logsJSON.put((Object)log.toJSON());
                }
                ++i;
            }
        }
        catch (Exception e) {
            String msg = NLS.bind((String)"An error occured when performing operation {0}", (Object)this.commandName);
            this.logger.error(msg, (Throwable)e);
            return new ServerStatus(4, 500, msg, (Throwable)e);
        }
        return new ServerStatus(Status.OK_STATUS, 200);
    }
}

