/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.commands;

import java.net.URI;
import java.net.URL;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.orion.server.cf.commands.AbstractCFCommand;
import org.eclipse.orion.server.cf.objects.Route;
import org.eclipse.orion.server.cf.objects.Target;
import org.eclipse.orion.server.cf.utils.HttpUtil;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.osgi.util.NLS;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetRoutesCommand
extends AbstractCFCommand {
    private final Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.cf");
    private String commandName = "Get Spaces";

    public GetRoutesCommand(String userId, Target target) {
        super(target);
    }

    @Override
    protected ServerStatus _doIt() {
        try {
            URI targetURI = URIUtil.toURI((URL)this.target.getUrl());
            URI orgsURI = targetURI.resolve("/v2/routes");
            GetMethod getRoutesMethod = new GetMethod(orgsURI.toString());
            HttpUtil.configureHttpMethod((HttpMethod)getRoutesMethod, this.target);
            getRoutesMethod.setQueryString("inline-relations-depth=1");
            ServerStatus status = HttpUtil.executeMethod((HttpMethod)getRoutesMethod);
            if (!status.isOK()) {
                return status;
            }
            JSONObject routes = status.getJsonData();
            if (routes.getInt("total_results") < 1) {
                return new ServerStatus(0, 200, null, null);
            }
            JSONObject result = new JSONObject();
            JSONArray resources = routes.getJSONArray("resources");
            int k = 0;
            while (k < resources.length()) {
                JSONObject routeJSON = resources.getJSONObject(k);
                Route route = new Route();
                route.setCFJSON(routeJSON);
                result.append("Routes", (Object)route.toJSON());
                ++k;
            }
            return new ServerStatus(Status.OK_STATUS, 200, result);
        }
        catch (Exception e) {
            String msg = NLS.bind((String)"An error occured when performing operation {0}", (Object)this.commandName);
            this.logger.error(msg, (Throwable)e);
            return new ServerStatus(4, 500, msg, (Throwable)e);
        }
    }
}

