/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.handlers.v1;

import java.net.URI;
import java.net.URL;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.orion.internal.server.servlets.ServletResourceHandler;
import org.eclipse.orion.server.cf.CFActivator;
import org.eclipse.orion.server.cf.jobs.CFJob;
import org.eclipse.orion.server.cf.objects.Info;
import org.eclipse.orion.server.cf.objects.Target;
import org.eclipse.orion.server.cf.servlets.AbstractRESTHandler;
import org.eclipse.orion.server.cf.utils.HttpUtil;
import org.eclipse.orion.server.core.IOUtilities;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.osgi.util.NLS;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfoHandlerV1
extends AbstractRESTHandler<Info> {
    private final Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.cf");

    public InfoHandlerV1(ServletResourceHandler<IStatus> statusHandler) {
        super(statusHandler);
    }

    @Override
    protected Info buildResource(HttpServletRequest request, String path) throws CoreException {
        return null;
    }

    @Override
    protected CFJob handleGet(Info info, HttpServletRequest request, HttpServletResponse response, final String path) {
        final JSONObject targetJSON = this.extractJSONData(IOUtilities.getQueryParameter((HttpServletRequest)request, (String)"Target"));
        return new CFJob(request, false){

            protected IStatus performJob() {
                try {
                    Target target;
                    URL targetUrl = null;
                    if (targetJSON != null) {
                        try {
                            targetUrl = new URL(targetJSON.getString("Url"));
                        }
                        catch (Exception exception) {}
                    }
                    if ((target = CFActivator.getDefault().getTargetRegistry().getTarget(this.userId, targetUrl)) == null) {
                        return HttpUtil.createErrorStatus(2, "CF-TargetNotSet", "Target not set");
                    }
                    URI infoURI = URIUtil.toURI((URL)target.getUrl()).resolve("/v2/info");
                    GetMethod getInfoMethod = new GetMethod(infoURI.toString());
                    HttpUtil.configureHttpMethod((HttpMethod)getInfoMethod, target);
                    return HttpUtil.executeMethod((HttpMethod)getInfoMethod);
                }
                catch (Exception e) {
                    String msg = NLS.bind((String)"Failed to handle request for {0}", (Object)path);
                    ServerStatus status = new ServerStatus(4, 500, msg, (Throwable)e);
                    InfoHandlerV1.this.logger.error(msg, (Throwable)e);
                    return status;
                }
            }
        };
    }
}

