/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.handlers.v1;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.orion.internal.server.servlets.ServletResourceHandler;
import org.eclipse.orion.server.cf.CFActivator;
import org.eclipse.orion.server.cf.commands.ComputeTargetCommand;
import org.eclipse.orion.server.cf.commands.LoginCommand;
import org.eclipse.orion.server.cf.commands.LogoutCommand;
import org.eclipse.orion.server.cf.jobs.CFJob;
import org.eclipse.orion.server.cf.objects.Target;
import org.eclipse.orion.server.cf.servlets.AbstractRESTHandler;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.osgi.util.NLS;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TargetHandlerV1
extends AbstractRESTHandler<Target> {
    private final Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.cf");

    public TargetHandlerV1(ServletResourceHandler<IStatus> statusHandler) {
        super(statusHandler);
    }

    @Override
    protected Target buildResource(HttpServletRequest request, String path) throws CoreException {
        return null;
    }

    @Override
    protected CFJob handleGet(Target target, HttpServletRequest request, HttpServletResponse response, final String path) {
        return new CFJob(request, false){

            protected IStatus performJob() {
                try {
                    Target target = CFActivator.getDefault().getTargetRegistry().getTarget(this.userId);
                    if (target == null) {
                        String msg = "Target not set";
                        return new ServerStatus(4, 404, msg, null);
                    }
                    return new ServerStatus(Status.OK_STATUS, 200, target.toJSON());
                }
                catch (JSONException e) {
                    String msg = NLS.bind((String)"Failed to handle request for {0}", (Object)path);
                    ServerStatus status = new ServerStatus(4, 500, msg, (Throwable)e);
                    TargetHandlerV1.this.logger.error(msg, (Throwable)e);
                    return status;
                }
            }
        };
    }

    @Override
    protected CFJob handlePost(Target resource, HttpServletRequest request, HttpServletResponse response, final String path) {
        final JSONObject jsonData = this.extractJSONData(request);
        return new CFJob(request, false){

            protected IStatus performJob() {
                try {
                    ComputeTargetCommand computeTarget = new ComputeTargetCommand(this.userId, jsonData);
                    IStatus result = computeTarget.doIt();
                    Target target = computeTarget.getTarget();
                    if (jsonData.has("Username") && jsonData.has("Password") && !(result = new LoginCommand(target, jsonData.getString("Username"), jsonData.getString("Password")).doIt()).isOK()) {
                        return result;
                    }
                    CFActivator.getDefault().getTargetRegistry().markDefault(this.userId, target);
                    return new ServerStatus(Status.OK_STATUS, 200, target.toJSON());
                }
                catch (Exception e) {
                    String msg = NLS.bind((String)"Failed to handle request for {0}", (Object)path);
                    ServerStatus status = new ServerStatus(4, 500, msg, (Throwable)e);
                    TargetHandlerV1.this.logger.error(msg, (Throwable)e);
                    return status;
                }
            }
        };
    }

    @Override
    protected CFJob handleDelete(Target resource, HttpServletRequest request, HttpServletResponse response, final String path) {
        return new CFJob(request, false){

            protected IStatus performJob() {
                try {
                    Target target = CFActivator.getDefault().getTargetRegistry().getTarget(this.userId);
                    if (target == null) {
                        String msg = "Target not set";
                        return new ServerStatus(4, 404, msg, null);
                    }
                    LogoutCommand logoutCommand = new LogoutCommand(target);
                    return logoutCommand.doIt();
                }
                catch (Exception e) {
                    String msg = NLS.bind((String)"Failed to handle request for {0}", (Object)path);
                    ServerStatus status = new ServerStatus(4, 500, msg, (Throwable)e);
                    TargetHandlerV1.this.logger.error(msg, (Throwable)e);
                    return status;
                }
            }
        };
    }
}

