/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.manifest.v2.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.orion.server.cf.manifest.v2.AnalyzerException;
import org.eclipse.orion.server.cf.manifest.v2.InputLine;
import org.eclipse.orion.server.cf.manifest.v2.InvalidAccessException;
import org.eclipse.orion.server.cf.manifest.v2.ManifestParseTree;
import org.eclipse.orion.server.cf.manifest.v2.ParserException;
import org.eclipse.orion.server.cf.manifest.v2.TokenizerException;
import org.eclipse.orion.server.cf.manifest.v2.utils.ApplicationSanizator;
import org.eclipse.orion.server.cf.manifest.v2.utils.InheritanceUtils;
import org.eclipse.orion.server.cf.manifest.v2.utils.ManifestConstants;
import org.eclipse.orion.server.cf.manifest.v2.utils.ManifestParser;
import org.eclipse.orion.server.cf.manifest.v2.utils.ManifestPreprocessor;
import org.eclipse.orion.server.cf.manifest.v2.utils.ManifestTokenizer;
import org.eclipse.orion.server.cf.manifest.v2.utils.ManifestTransformator;
import org.eclipse.orion.server.cf.manifest.v2.utils.SymbolResolver;
import org.eclipse.osgi.util.NLS;

public class ManifestUtils {
    public static final String[] RESERVED_PROPERTIES = new String[]{"env", "inherit", "applications"};

    public static boolean isReserved(ManifestParseTree node) {
        String value = node.getLabel();
        String[] stringArray = RESERVED_PROPERTIES;
        int n = RESERVED_PROPERTIES.length;
        int n2 = 0;
        while (n2 < n) {
            String property = stringArray[n2];
            if (property.equals(value)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static ManifestParseTree parseManifest(IFileStore manifestFileStore, String targetBase) throws CoreException, IOException, TokenizerException, ParserException, AnalyzerException {
        IFileInfo manifestFileInfo = manifestFileStore.fetchInfo();
        if (!manifestFileInfo.exists() || manifestFileInfo.isDirectory()) {
            throw new IOException(ManifestConstants.MISSING_OR_INVALID_MANIFEST);
        }
        if (manifestFileInfo.getLength() == 0L || manifestFileInfo.getLength() > ManifestConstants.MANIFEST_SIZE_LIMIT) {
            throw new IOException(ManifestConstants.MANIFEST_FILE_SIZE_EXCEEDED);
        }
        InputStream inputStream = manifestFileStore.openInputStream(0, null);
        ManifestPreprocessor preprocessor = new ManifestPreprocessor();
        List<InputLine> inputLines = preprocessor.process(inputStream);
        ManifestTokenizer tokenizer = new ManifestTokenizer(inputLines);
        ManifestParser parser = new ManifestParser();
        ManifestParseTree parseTree = parser.parse(tokenizer);
        ManifestTransformator transformator = new ManifestTransformator();
        transformator.apply(parseTree);
        SymbolResolver symbolResolver = new SymbolResolver(targetBase);
        symbolResolver.apply(parseTree);
        ApplicationSanizator applicationAnalyzer = new ApplicationSanizator();
        applicationAnalyzer.apply(parseTree);
        return parseTree;
    }

    public static ManifestParseTree parse(IFileStore sandbox, IFileStore manifestStore, String targetBase, List<IPath> manifestList) throws CoreException, IOException, TokenizerException, ParserException, AnalyzerException, InvalidAccessException {
        ManifestParseTree manifest = ManifestUtils.parseManifest(manifestStore, targetBase);
        if (!manifest.has("inherit")) {
            return manifest;
        }
        Path parentLocation = new Path(manifest.get("inherit").getValue());
        if (!InheritanceUtils.isWithinSandbox(sandbox, manifestStore, (IPath)parentLocation)) {
            throw new AnalyzerException(NLS.bind((String)ManifestConstants.FORBIDDEN_ACCESS_ERROR, (Object)manifest.get("inherit").getValue()));
        }
        if (manifestList.contains(parentLocation)) {
            throw new AnalyzerException(ManifestConstants.INHERITANCE_CYCLE_ERROR);
        }
        manifestList.add((IPath)parentLocation);
        IFileStore parentStore = manifestStore.getParent().getFileStore((IPath)parentLocation);
        ManifestParseTree parentManifest = ManifestUtils.parse(sandbox, parentStore, targetBase, manifestList);
        InheritanceUtils.inherit(parentManifest, manifest);
        ManifestTransformator transformator = new ManifestTransformator();
        transformator.apply(manifest);
        return manifest;
    }

    public static ManifestParseTree parse(IFileStore sandbox, IFileStore manifestStore) throws CoreException, IOException, TokenizerException, ParserException, AnalyzerException, InvalidAccessException {
        return ManifestUtils.parse(sandbox, manifestStore, null, new ArrayList<IPath>());
    }

    public static ManifestParseTree parse(IFileStore sandbox, IFileStore manifestStore, String targetBase) throws CoreException, IOException, TokenizerException, ParserException, AnalyzerException, InvalidAccessException {
        return ManifestUtils.parse(sandbox, manifestStore, targetBase, new ArrayList<IPath>());
    }

    public static int normalizeMemoryMeasure(String memory) {
        if (memory.toLowerCase().endsWith("m")) {
            return Integer.parseInt(memory.substring(0, memory.length() - 1));
        }
        if (memory.toLowerCase().endsWith("mb")) {
            return Integer.parseInt(memory.substring(0, memory.length() - 2));
        }
        if (memory.toLowerCase().endsWith("g")) {
            return 1024 * Integer.parseInt(memory.substring(0, memory.length() - 1));
        }
        if (memory.toLowerCase().endsWith("gb")) {
            return 1024 * Integer.parseInt(memory.substring(0, memory.length() - 2));
        }
        return 1024;
    }
}

