/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.servlets.site;

import java.io.IOException;
import java.net.URI;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.orion.internal.server.servlets.ServletResourceHandler;
import org.eclipse.orion.internal.server.servlets.site.SiteConfigurationResourceHandler;
import org.eclipse.orion.internal.server.servlets.site.SiteInfo;
import org.eclipse.orion.server.core.LogHelper;
import org.eclipse.orion.server.core.OrionConfiguration;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.orion.server.core.metastore.UserInfo;
import org.eclipse.orion.server.servlets.JsonURIUnqualificationStrategy;
import org.eclipse.orion.server.servlets.OrionServlet;
import org.json.JSONArray;
import org.json.JSONObject;

public class SiteConfigurationServlet
extends OrionServlet {
    private static final long serialVersionUID = 1L;
    private ServletResourceHandler<SiteInfo> siteConfigurationResourceHandler = new SiteConfigurationResourceHandler(this.getStatusHandler());

    protected synchronized void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.traceRequest(req);
        IPath pathInfo = SiteConfigurationServlet.getPathInfo(req);
        if (pathInfo.segmentCount() == 0) {
            this.doGetAllSiteConfigurations(req, resp);
            return;
        }
        if (pathInfo.segmentCount() == 1) {
            SiteInfo site = this.getExistingSiteConfig(req, resp);
            if (this.siteConfigurationResourceHandler.handleRequest(req, resp, site)) {
                return;
            }
        } else {
            this.handleException(resp, (IStatus)new ServerStatus(4, 400, "Bad request", null));
            return;
        }
        super.doGet(req, resp);
    }

    protected synchronized void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.traceRequest(req);
        IPath pathInfo = SiteConfigurationServlet.getPathInfo(req);
        if (pathInfo.segmentCount() == 0) {
            if (this.siteConfigurationResourceHandler.handleRequest(req, resp, null)) {
                return;
            }
        } else {
            this.handleException(resp, (IStatus)new ServerStatus(4, 400, "Bad request", null));
            return;
        }
        super.doPost(req, resp);
    }

    protected synchronized void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.traceRequest(req);
        IPath pathInfo = SiteConfigurationServlet.getPathInfo(req);
        if (pathInfo.segmentCount() == 1) {
            SiteInfo site = this.getExistingSiteConfig(req, resp);
            if (this.siteConfigurationResourceHandler.handleRequest(req, resp, site)) {
                return;
            }
        } else {
            this.handleException(resp, (IStatus)new ServerStatus(4, 400, "Bad request", null));
            return;
        }
        super.doPut(req, resp);
    }

    protected synchronized void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.traceRequest(req);
        if (SiteConfigurationServlet.getPathInfo(req).segmentCount() == 1) {
            SiteInfo site = this.getExistingSiteConfig(req, resp);
            if (this.siteConfigurationResourceHandler.handleRequest(req, resp, site)) {
                return;
            }
        } else {
            this.handleException(resp, (IStatus)new ServerStatus(4, 400, "Bad request", null));
        }
        super.doDelete(req, resp);
    }

    private SiteInfo getExistingSiteConfig(HttpServletRequest req, HttpServletResponse resp) {
        IPath pathInfo;
        String userName;
        block3: {
            userName = SiteConfigurationServlet.getUserName(req);
            pathInfo = SiteConfigurationServlet.getPathInfo(req);
            try {
                if (pathInfo.segmentCount() == 1) break block3;
                return null;
            }
            catch (CoreException e) {
                LogHelper.log((Throwable)e);
                return null;
            }
        }
        UserInfo user = OrionConfiguration.getMetaStore().readUser(userName);
        return SiteInfo.getSite(user, pathInfo.segment(0));
    }

    private boolean doGetAllSiteConfigurations(HttpServletRequest req, HttpServletResponse resp) throws ServletException {
        String userName = SiteConfigurationServlet.getUserName(req);
        try {
            UserInfo user = OrionConfiguration.getMetaStore().readUser(userName);
            URI base = ServletResourceHandler.getURI(req);
            JSONArray configurations = new JSONArray();
            JSONObject sites = SiteInfo.getSites(user);
            String[] names = JSONObject.getNames((JSONObject)sites);
            if (names != null) {
                String[] stringArray = names;
                int n = names.length;
                int n2 = 0;
                while (n2 < n) {
                    String siteId = stringArray[n2];
                    JSONObject siteInfo = sites.getJSONObject(siteId);
                    siteInfo.put("Location", (Object)URIUtil.append((URI)base, (String)siteId));
                    configurations.put((Object)siteInfo);
                    ++n2;
                }
            }
            JSONObject jsonResponse = new JSONObject();
            jsonResponse.put("SiteConfigurations", (Object)configurations);
            SiteConfigurationServlet.writeJSONResponse(req, resp, jsonResponse, JsonURIUnqualificationStrategy.LOCATION_ONLY);
        }
        catch (Exception e) {
            LogHelper.log((Throwable)e);
            this.handleException(resp, "An error occurred while obtaining site configurations", e);
        }
        return true;
    }

    private static IPath getPathInfo(HttpServletRequest req) {
        Path contextPath;
        Path path;
        String pathString = req.getPathInfo();
        Path path2 = path = pathString == null ? Path.EMPTY : new Path(pathString);
        if (req.getContextPath().length() != 0 && (contextPath = new Path(req.getContextPath())).isPrefixOf((IPath)path)) {
            path = path.removeFirstSegments(contextPath.segmentCount());
        }
        return path;
    }

    private static String getUserName(HttpServletRequest req) {
        return req.getRemoteUser();
    }
}

