/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.core;

import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.orion.internal.server.core.metastore.SimpleMetaStoreV1;
import org.eclipse.orion.internal.server.core.metastore.SimpleMetaStoreV2;
import org.eclipse.orion.internal.server.core.tasks.TaskService;
import org.eclipse.orion.server.core.LogHelper;
import org.eclipse.orion.server.core.OrionConfiguration;
import org.eclipse.orion.server.core.metastore.IMetaStore;
import org.eclipse.orion.server.core.tasks.ITaskService;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.osgi.service.datalocation.Location;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator {
    public static volatile BundleContext bundleContext;
    public static final String PROP_USER_AREA = "org.eclipse.orion.server.core.userArea";
    static Activator singleton;
    ServiceTracker<FrameworkLog, FrameworkLog> logTracker;
    ServiceTracker<IPreferencesService, IPreferencesService> prefTracker;
    private ServiceRegistration<ITaskService> taskServiceRegistration;
    private IMetaStore metastore;
    private URI rootStoreURI;

    public static Activator getDefault() {
        return singleton;
    }

    public static FrameworkLog getFrameworkLog() {
        Activator a = singleton;
        if (a == null) {
            return null;
        }
        ServiceTracker<FrameworkLog, FrameworkLog> tracker = a.getLogTracker();
        if (tracker == null) {
            return null;
        }
        return (FrameworkLog)tracker.getService();
    }

    public synchronized IMetaStore getMetastore() {
        return this.metastore;
    }

    public static IPreferencesService getPreferenceService() {
        Activator a = singleton;
        if (a == null) {
            return null;
        }
        ServiceTracker<IPreferencesService, IPreferencesService> tracker = a.getPrefTracker();
        if (tracker == null) {
            return null;
        }
        return (IPreferencesService)tracker.getService();
    }

    public BundleContext getContext() {
        return bundleContext;
    }

    private ServiceTracker<FrameworkLog, FrameworkLog> getLogTracker() {
        if (this.logTracker != null) {
            return this.logTracker;
        }
        if (bundleContext == null) {
            return null;
        }
        this.logTracker = new ServiceTracker(bundleContext, FrameworkLog.class, null);
        this.logTracker.open();
        return this.logTracker;
    }

    private ServiceTracker<IPreferencesService, IPreferencesService> getPrefTracker() {
        if (this.prefTracker != null) {
            return this.prefTracker;
        }
        if (bundleContext == null) {
            return null;
        }
        this.prefTracker = new ServiceTracker(bundleContext, IPreferencesService.class, null);
        this.prefTracker.open();
        return this.prefTracker;
    }

    private IPath getTaskLocation() throws IOException {
        Collection refs;
        BundleContext context = Activator.getDefault().getContext();
        try {
            refs = context.getServiceReferences(Location.class, Location.INSTANCE_FILTER);
        }
        catch (InvalidSyntaxException e) {
            throw new RuntimeException(e);
        }
        if (refs.isEmpty()) {
            throw new IOException("Framework instance location is undefined");
        }
        ServiceReference ref = (ServiceReference)refs.iterator().next();
        Location location = (Location)context.getService(ref);
        try {
            if (location == null) {
                throw new IOException("Framework instance location is undefined");
            }
            URL root = location.getDataArea("org.eclipse.orion.server.core");
            IPath iPath = new Path(root.toExternalForm().substring(5)).append("tasks");
            return iPath;
        }
        finally {
            context.ungetService(ref);
        }
    }

    private void initializeMetaStore() {
        String pref = OrionConfiguration.getMetaStorePreference();
        if ("simple2".equals(pref)) {
            try {
                this.metastore = new SimpleMetaStoreV2(OrionConfiguration.getRootLocation().toLocalFile(0, null));
            }
            catch (CoreException e) {
                throw new RuntimeException("Cannot initialize MetaStore", e);
            }
        } else if ("simple".equals(pref)) {
            try {
                this.metastore = new SimpleMetaStoreV1(OrionConfiguration.getRootLocation().toLocalFile(0, null));
            }
            catch (CoreException e) {
                throw new RuntimeException("Cannot initialize MetaStore", e);
            }
        } else {
            Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.config");
            logger.error("Preference orion.core.metastore was not supplied and legacy files exist, see https://wiki.eclipse.org/Orion/Metadata_migration to migrate to the current version");
            return;
        }
        bundleContext.registerService(IMetaStore.class, (Object)this.metastore, null);
    }

    public void start(BundleContext context) throws Exception {
        singleton = this;
        bundleContext = context;
        this.registerServices();
        this.initializeFileSystem();
        this.initializeMetaStore();
    }

    private void registerServices() {
        try {
            IPath taskLocation = this.getTaskLocation();
            TaskService service = new TaskService(taskLocation);
            this.taskServiceRegistration = bundleContext.registerService(ITaskService.class, (Object)service, null);
        }
        catch (IOException e) {
            LogHelper.log((IStatus)new Status(4, "org.eclipse.orion.server.core", "Failed to initialize task service", (Throwable)e));
        }
    }

    public void stop(BundleContext context) throws Exception {
        this.metastore = null;
        this.stopTaskService();
        if (this.prefTracker != null) {
            this.prefTracker.close();
            this.prefTracker = null;
        }
        if (this.logTracker != null) {
            this.logTracker.close();
            this.logTracker = null;
        }
        bundleContext = null;
    }

    public IPath getPlatformLocation() {
        Collection refs;
        BundleContext context = Activator.getDefault().getContext();
        try {
            refs = context.getServiceReferences(Location.class, Location.INSTANCE_FILTER);
        }
        catch (InvalidSyntaxException e) {
            throw new RuntimeException(e);
        }
        if (refs.isEmpty()) {
            return null;
        }
        ServiceReference ref = (ServiceReference)refs.iterator().next();
        Location location = (Location)context.getService(ref);
        try {
            if (location == null) {
                return null;
            }
            URL root = location.getURL();
            if (root == null) {
                return null;
            }
            Path path = new Path(root.toExternalForm().substring(5));
            return path;
        }
        finally {
            context.ungetService(ref);
        }
    }

    private void initializeFileSystem() {
        IPath location = this.getPlatformLocation();
        if (location == null) {
            throw new RuntimeException("Unable to compute base file system location");
        }
        IFileStore rootStore = EFS.getLocalFileSystem().getStore(location);
        try {
            rootStore.mkdir(0, null);
            this.rootStoreURI = rootStore.toURI();
        }
        catch (CoreException e) {
            throw new RuntimeException("Instance location is read only: " + rootStore, e);
        }
        if (System.getProperty(PROP_USER_AREA) == null) {
            System.setProperty(PROP_USER_AREA, rootStore.getFileStore((IPath)new Path(".metadata/.plugins/org.eclipse.orion.server.core/userArea")).toString());
        }
    }

    private void stopTaskService() {
        ServiceRegistration<ITaskService> reg = this.taskServiceRegistration;
        this.taskServiceRegistration = null;
        if (reg != null) {
            reg.unregister();
        }
    }

    public URI getRootLocationURI() {
        return this.rootStoreURI;
    }
}

