/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.useradmin.diskusage;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.orion.server.core.OrionConfiguration;
import org.eclipse.orion.server.user.profile.IOrionUserProfileNode;
import org.eclipse.orion.server.user.profile.IOrionUserProfileService;
import org.eclipse.orion.server.useradmin.UserServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiskUsageJob
extends Job {
    private Logger logger;

    public DiskUsageJob() {
        super("Orion Disk Usage Data");
    }

    protected IStatus run(IProgressMonitor monitor) {
        this.logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.account");
        if (!this.updateDiskUsageData()) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Orion disk usage user data job waiting for user metadata service");
            }
            this.schedule(5000L);
            return Status.OK_STATUS;
        }
        this.schedule(43200000L);
        return Status.OK_STATUS;
    }

    private boolean updateDiskUsageData() {
        UserServiceHelper userServiceHelper;
        block6: {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Orion disk usage user data job started");
            }
            if ((userServiceHelper = UserServiceHelper.getDefault()) != null) break block6;
            return false;
        }
        try {
            String[] userids;
            IOrionUserProfileService userProfileService = userServiceHelper.getUserProfileService();
            String[] stringArray = userids = userProfileService.getUserNames();
            int n = userids.length;
            int n2 = 0;
            while (n2 < n) {
                String userId = stringArray[n2];
                File userRoot = OrionConfiguration.getMetaStore().getUserHome(userId).toLocalFile(0, null);
                String diskUsage = this.getFolderSize(userRoot);
                IOrionUserProfileNode generalUserProfile = userProfileService.getUserProfileNode(userId, "general");
                generalUserProfile.put("diskusage", diskUsage, false);
                generalUserProfile.put("diskusagetimestamp", new Long(System.currentTimeMillis()).toString(), false);
                generalUserProfile.flush();
                ++n2;
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Orion disk usage user data updated");
            }
        }
        catch (CoreException e) {
            this.logger.error("Cannot complete Orion disk usage user data job", (Throwable)e);
            return false;
        }
        return true;
    }

    private String getFolderSize(File folder) {
        StringBuffer commandOutput = new StringBuffer();
        try {
            Process process = Runtime.getRuntime().exec("du -hs " + folder.toString());
            process.waitFor();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String line = "";
            while ((line = reader.readLine()) != null) {
                commandOutput.append(String.valueOf(line) + "\n");
            }
        }
        catch (Exception exception) {
            return "unknown";
        }
        String size = commandOutput.toString();
        if (size.indexOf("\t") == -1) {
            return "unknown";
        }
        return size.substring(0, size.indexOf("\t"));
    }
}

