/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.useradmin.servlets;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.orion.internal.server.servlets.ServletResourceHandler;
import org.eclipse.orion.server.useradmin.UserServiceHelper;
import org.eclipse.orion.server.useradmin.servlets.GenericUserHandler;
import org.eclipse.orion.server.useradmin.servlets.UserHandlerV1;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.osgi.framework.Version;

public class ServletUserHandler
extends ServletResourceHandler<String> {
    public static VersionRange VERSION1 = new VersionRange("[1,2)");
    private final ServletResourceHandler<String> genericUserHandler;
    private final ServletResourceHandler<String> userHandlerV1;
    final ServletResourceHandler<IStatus> statusHandler;

    ServletUserHandler(UserServiceHelper userServiceHelper, ServletResourceHandler<IStatus> statusHandler) {
        this.statusHandler = statusHandler;
        this.genericUserHandler = new GenericUserHandler(userServiceHelper, statusHandler);
        this.userHandlerV1 = new UserHandlerV1(userServiceHelper, statusHandler);
    }

    public boolean handleRequest(HttpServletRequest request, HttpServletResponse response, String userPathInfo) throws ServletException {
        String versionString = request.getHeader("Orion-Version");
        Version version = versionString == null ? null : new Version(versionString);
        ServletResourceHandler<String> handler = version != null && VERSION1.isIncluded(version) ? this.userHandlerV1 : this.genericUserHandler;
        return handler.handleRequest(request, response, (Object)userPathInfo);
    }
}

