/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.configurator.configuration;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.orion.server.configurator.ConfiguratorActivator;
import org.eclipse.orion.server.core.IOUtilities;
import org.eclipse.orion.server.core.LogHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrionPreferenceInitializer
extends AbstractPreferenceInitializer {
    private static final String DEFAULT_CONFIG_FILE = "orion.conf";
    private final Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.config");

    private File findServerConfigFile() {
        File result;
        String location = ConfiguratorActivator.getDefault().getContext().getProperty("orion.core.configFile");
        if (location == null) {
            location = DEFAULT_CONFIG_FILE;
        }
        if ((result = new File(location)).exists()) {
            return result;
        }
        this.logger.info("No server configuration file found at: " + result.getAbsolutePath());
        URL instanceURL = ConfiguratorActivator.getDefault().getInstanceLocation().getURL();
        result = new File(new File(instanceURL.toExternalForm().substring(5)), DEFAULT_CONFIG_FILE);
        if (result.exists()) {
            return result;
        }
        this.logger.info("No server configuration file found at: " + result);
        return null;
    }

    public void initializeDefaultPreferences() {
        File configFile = this.findServerConfigFile();
        if (configFile == null) {
            return;
        }
        Properties props = this.readProperties(configFile);
        if (props == null) {
            return;
        }
        IEclipsePreferences node = DefaultScope.INSTANCE.getNode("org.eclipse.orion.server.configurator");
        for (Object o : props.keySet()) {
            String key = (String)o;
            node.put(key, props.getProperty(key));
        }
    }

    private Properties readProperties(File propFile) {
        Properties props = new Properties();
        try {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(propFile));
            try {
                props.load(in);
            }
            finally {
                IOUtilities.safeClose((Closeable)in);
            }
        }
        catch (IOException e) {
            this.logger.warn("Unable to read server configuration file at: " + propFile);
            LogHelper.log((Throwable)e);
        }
        this.logger.info("Server configuration file loaded from: " + propFile);
        return props;
    }
}

