/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.git.servlets;

import java.io.File;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.orion.internal.server.servlets.ServletResourceHandler;
import org.eclipse.orion.internal.server.servlets.workspace.authorization.AuthorizationService;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.orion.server.core.tasks.IURIUnqualificationStrategy;
import org.eclipse.orion.server.git.objects.Status;
import org.eclipse.orion.server.git.servlets.GitUtils;
import org.eclipse.orion.server.servlets.JsonURIUnqualificationStrategy;
import org.eclipse.orion.server.servlets.OrionServlet;
import org.eclipse.osgi.util.NLS;

public class GitStatusHandlerV1
extends ServletResourceHandler<String> {
    private ServletResourceHandler<IStatus> statusHandler;

    GitStatusHandlerV1(ServletResourceHandler<IStatus> statusHandler) {
        this.statusHandler = statusHandler;
    }

    public boolean handleRequest(HttpServletRequest request, HttpServletResponse response, String gitPathInfo) throws ServletException {
        Repository db = null;
        try {
            Path path = new Path(gitPathInfo);
            if (!path.hasTrailingSeparator()) {
                String msg = NLS.bind((String)"Cannot get status on a file: {0}", (Object)gitPathInfo);
                boolean bl = this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, msg, null));
                return bl;
            }
            if (!AuthorizationService.checkRights((String)request.getRemoteUser(), (String)("/" + path.toString()), (String)request.getMethod())) {
                response.sendError(403);
                return true;
            }
            Set<Map.Entry<IPath, File>> set = GitUtils.getGitDirs((IPath)path, GitUtils.Traverse.GO_UP).entrySet();
            File gitDir = set.iterator().next().getValue();
            if (gitDir == null) {
                return false;
            }
            db = FileRepositoryBuilder.create((File)gitDir);
            Git git = new Git(db);
            org.eclipse.jgit.api.Status gitStatus = git.status().call();
            URI baseLocation = GitStatusHandlerV1.getURI((HttpServletRequest)request);
            String relativePath = GitUtils.getRelativePath((IPath)path, set.iterator().next().getKey());
            Path basePath = new Path(relativePath);
            Status status = new Status(baseLocation, db, gitStatus, (IPath)basePath);
            OrionServlet.writeJSONResponse((HttpServletRequest)request, (HttpServletResponse)response, (Object)status.toJSON(), (IURIUnqualificationStrategy)JsonURIUnqualificationStrategy.ALL_NO_GIT);
            return true;
        }
        catch (Exception e) {
            boolean bl = this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 500, "Error generating status response", (Throwable)e));
            return bl;
        }
        finally {
            if (db != null) {
                db.close();
            }
        }
    }
}

