/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.authentication.formopenid;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.orion.server.authentication.form.FormAuthHelper;
import org.eclipse.orion.server.authentication.formopenid.FormOpenIdAuthenticationService;
import org.eclipse.orion.server.authentication.formpersona.PersonaException;
import org.eclipse.orion.server.authentication.formpersona.PersonaHelper;
import org.eclipse.orion.server.authentication.openid.OpenIdException;
import org.eclipse.orion.server.authentication.openid.OpenIdHelper;
import org.eclipse.orion.server.authentication.openid.OpenidConsumer;
import org.eclipse.orion.server.core.LogHelper;
import org.eclipse.orion.server.core.resources.Base64;
import org.eclipse.orion.server.servlets.OrionServlet;
import org.eclipse.orion.server.useradmin.UnsupportedUserStoreException;
import org.json.JSONException;
import org.json.JSONObject;
import org.osgi.framework.Version;

public class FormOpenIdLoginServlet
extends OrionServlet {
    private FormOpenIdAuthenticationService authenticationService;
    private OpenidConsumer consumer;
    private static final long serialVersionUID = 1L;

    public FormOpenIdLoginServlet(FormOpenIdAuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String assertion;
        String pathInfo;
        this.traceRequest(req);
        String string = pathInfo = req.getPathInfo() == null ? "" : req.getPathInfo();
        if (pathInfo.startsWith("/form")) {
            block28: {
                try {
                    FormAuthHelper.LoginResult authResult = FormAuthHelper.performAuthentication(req, resp);
                    if (authResult == FormAuthHelper.LoginResult.OK) {
                        String versionString = req.getHeader("Orion-Version");
                        Version version = versionString == null ? null : new Version(versionString);
                        String xRequestedWith = req.getHeader("X-Requested-With");
                        if (version == null && !"XMLHttpRequest".equals(xRequestedWith)) {
                            if (req.getParameter("redirect") != null && !req.getParameter("redirect").equals("")) {
                                resp.sendRedirect(req.getParameter("redirect"));
                            }
                        } else {
                            resp.setStatus(200);
                            PrintWriter writer = resp.getWriter();
                            String uid = (String)req.getSession().getAttribute("user");
                            try {
                                JSONObject userJson = FormAuthHelper.getUserJson(uid, req.getContextPath());
                                writer.print(userJson);
                                resp.setContentType("application/json");
                            }
                            catch (JSONException jSONException) {}
                        }
                        resp.flushBuffer();
                        break block28;
                    }
                    if (authResult == FormAuthHelper.LoginResult.BLOCKED) {
                        this.displayError("Your account is not active. Please confirm your email before logging in.", req, resp);
                    } else {
                        this.displayError("Invalid user or password", req, resp);
                    }
                }
                catch (UnsupportedUserStoreException e) {
                    LogHelper.log((Throwable)e);
                    resp.sendError(404, e.getMessage());
                }
            }
            return;
        }
        if (pathInfo.startsWith("/openid")) {
            String openid = req.getParameter("openid");
            if (openid != null) {
                try {
                    this.consumer = OpenIdHelper.redirectToOpenIdProvider(req, resp, this.consumer);
                }
                catch (OpenIdException e) {
                    LogHelper.log((IStatus)new Status(4, "org.eclipse.orion.server.authentication", "An error occurred redirecting to OpenId provider", (Throwable)e));
                    this.displayError(e.getMessage(), req, resp);
                }
                return;
            }
            String op_return = req.getParameter("op_return");
            if (op_return != null) {
                try {
                    OpenIdHelper.handleOpenIdReturnAndLogin(req, resp, this.consumer);
                }
                catch (OpenIdException e) {
                    this.displayError(e.getMessage(), req, resp);
                }
                return;
            }
        }
        if (pathInfo.startsWith("/persona") && (assertion = req.getParameter("assertion")) != null) {
            try {
                new PersonaHelper().handleCredentialsAndLogin(req, resp);
            }
            catch (PersonaException e) {
                this.displayError(e.getMessage(), req, resp);
            }
        }
        if (pathInfo.startsWith("/canaddusers")) {
            JSONObject jsonResp = new JSONObject();
            try {
                jsonResp.put("CanAddUsers", FormAuthHelper.canAddUsers());
                jsonResp.put("ForceEmail", FormAuthHelper.forceEmail());
                jsonResp.put("RegistrationURI", (Object)FormAuthHelper.registrationURI());
            }
            catch (JSONException jSONException) {}
            resp.getWriter().print(jsonResp);
            resp.setContentType("application/json");
            return;
        }
        String user = req.getRemoteUser();
        if (user == null) {
            user = this.authenticationService.getAuthenticatedUser(req, resp, this.authenticationService.getDefaultAuthenticationProperties());
        }
        if (user != null) {
            resp.setStatus(200);
            try {
                resp.getWriter().print(FormAuthHelper.getUserJson(user, req.getContextPath()));
            }
            catch (JSONException e) {
                this.handleException(resp, "An error occured when creating JSON object for logged in user", (Exception)((Object)e));
            }
            return;
        }
    }

    private void displayError(String error, HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String versionString = req.getHeader("Orion-Version");
        Version version = versionString == null ? null : new Version(versionString);
        String xRequestedWith = req.getHeader("X-Requested-With");
        if (version == null && !"XMLHttpRequest".equals(xRequestedWith)) {
            String url = "/mixloginstatic/LoginWindow.html";
            if (req.getParameter("redirect") != null) {
                url = String.valueOf(url) + "?redirect=" + req.getParameter("redirect");
            }
            if (error == null) {
                error = "Invalid login";
            }
            url = String.valueOf(url) + (url.contains("?") ? "&" : "?");
            url = String.valueOf(url) + "error=" + new String(Base64.encode((byte[])error.getBytes()));
            resp.sendRedirect(url);
        } else {
            resp.setStatus(401);
            PrintWriter writer = resp.getWriter();
            JSONObject jsonError = new JSONObject();
            try {
                jsonError.put("error", (Object)error);
                writer.print(jsonError);
                resp.setContentType("application/json");
            }
            catch (JSONException jSONException) {}
        }
        resp.flushBuffer();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String pathInfo;
        this.traceRequest(req);
        String string = pathInfo = req.getPathInfo() == null ? "" : req.getPathInfo();
        if (pathInfo.startsWith("/openid") && (req.getParameter("openid") != null || req.getParameter("op_return") != null)) {
            this.doPost(req, resp);
            return;
        }
        RequestDispatcher rd = req.getRequestDispatcher("/mixlogin/login");
        rd.forward((ServletRequest)req, (ServletResponse)resp);
    }
}

