/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.core;

import java.io.File;
import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.orion.internal.server.core.Activator;
import org.eclipse.orion.internal.server.core.metastore.SimpleMetaStore;
import org.eclipse.orion.server.core.PreferenceHelper;
import org.eclipse.orion.server.core.metastore.IMetaStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrionConfiguration {
    private static final String SECURESTORAGE = "/.metadata/.plugins/org.eclipse.orion.server.user.securestorage/user_store";
    private static final String USERS_PREFS = "/.metadata/.plugins/org.eclipse.orion.server.core/.settings/Users.prefs";
    private static String metaStorePreference = null;

    public static IMetaStore getMetaStore() {
        return Activator.getDefault().getMetastore();
    }

    public static IFileStore getRootLocation() {
        URI platformLocationURI = Activator.getDefault().getRootLocationURI();
        IFileStore root = null;
        try {
            root = EFS.getStore((URI)platformLocationURI);
        }
        catch (CoreException e) {
            throw new Error("Failed to access platform instance location", e);
        }
        return root;
    }

    public static IFileStore getUserHome(String userId) {
        return OrionConfiguration.getMetaStore().getUserHome(userId);
    }

    public static String getMetaStorePreference() {
        if (metaStorePreference != null) {
            return metaStorePreference;
        }
        String metastore = PreferenceHelper.getString("orion.core.metastore", "none").toLowerCase();
        if ("simple".equals(metastore) || "simple2".equals(metastore) || "legacy".equals(metastore)) {
            metaStorePreference = metastore;
            return metaStorePreference;
        }
        try {
            File rootFile = OrionConfiguration.getRootLocation().toLocalFile(0, null);
            File securestorage = new File(rootFile, SECURESTORAGE);
            File users_prefs = new File(rootFile, USERS_PREFS);
            int version = SimpleMetaStore.getOrionVersion(rootFile);
            if (4 == version) {
                metaStorePreference = "simple";
                return metaStorePreference;
            }
            if (6 == version) {
                metaStorePreference = "simple2";
                return metaStorePreference;
            }
            if (securestorage.exists() || users_prefs.exists()) {
                Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.config");
                logger.error("Preference orion.core.metastore was not supplied and legacy files exist, see https://wiki.eclipse.org/Orion/Metadata_migration to migrate to the current version");
                metaStorePreference = "legacy";
                return metaStorePreference;
            }
            metaStorePreference = "simple2";
            return metaStorePreference;
        }
        catch (CoreException e) {
            throw new Error("Failed to access platform instance location", e);
        }
    }

    public static IPath getPlatformLocation() {
        return Activator.getDefault().getPlatformLocation();
    }
}

