/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.useradmin.servlets;

import java.io.IOException;
import java.net.URI;
import java.util.HashSet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.orion.server.core.LogHelper;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.orion.server.servlets.OrionServlet;
import org.eclipse.orion.server.user.profile.RandomPasswordGenerator;
import org.eclipse.orion.server.useradmin.IOrionCredentialsService;
import org.eclipse.orion.server.useradmin.User;
import org.eclipse.orion.server.useradmin.UserEmailUtil;
import org.eclipse.orion.server.useradmin.UserServiceHelper;
import org.json.JSONException;
import org.json.JSONObject;

public class EmailConfirmationServlet
extends OrionServlet {
    private static final long serialVersionUID = 2029138177545673411L;

    private IOrionCredentialsService getUserAdmin() {
        return UserServiceHelper.getDefault().getUserStore();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.traceRequest(req);
        String[] userPathInfoParts = req.getPathInfo().split("\\/", 2);
        String userId = userPathInfoParts[1];
        IOrionCredentialsService userAdmin = this.getUserAdmin();
        User user = userAdmin.getUser("uid", userId);
        if (user == null) {
            resp.sendError(404, "User " + userId + " not found.");
            return;
        }
        if (req.getParameter("passwordResetId") != null) {
            this.resetPassword(user, req, resp);
        } else {
            this.confirmEmail(user, req, resp);
        }
    }

    private void resetPassword(User user, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (user.getProperty("passwordResetId") == null || "".equals(user.getProperty("passwordResetId"))) {
            resp.sendError(400, "You have not requested to reset your password");
            return;
        }
        if (!user.getProperty("passwordResetId").equals(req.getParameter("passwordResetId"))) {
            resp.sendError(400, "This password reset request is out of date");
            return;
        }
        String newPass = RandomPasswordGenerator.getRanromPassword();
        user.setPassword(newPass);
        try {
            UserEmailUtil.getUtil().setPasswordResetEmail(user);
        }
        catch (Exception e) {
            LogHelper.log((Throwable)e);
            resp.sendError(500, "Your password could not be changed, because confirmation email could not be sent. To reset your password contact your administrator.");
            return;
        }
        IStatus status = this.getUserAdmin().updateUser(user.getUid(), user);
        if (!status.isOK()) {
            if (status instanceof ServerStatus) {
                resp.sendError(((ServerStatus)status).getHttpCode(), status.getMessage());
                return;
            }
            resp.sendError(500, status.getMessage());
            return;
        }
        resp.setContentType("text/html;charset=UTF-8");
        resp.getWriter().write("<html><body><p>Your password has been successfully reset. Your new password has been sent to the email address associated with your account.</p></body></html>");
    }

    private void confirmEmail(User user, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (user.getConfirmationId() == null) {
            resp.setContentType("text/html;charset=UTF-8");
            resp.getWriter().write("<html><body><p>Your email address has already been confirmed. Thank you!</p></body></html>");
            return;
        }
        if (req.getParameter("confirmationId") == null || !req.getParameter("confirmationId").equals(user.getConfirmationId())) {
            resp.sendError(400, "Email could not be confirmed.");
            return;
        }
        user.confirmEmail();
        IStatus status = this.getUserAdmin().updateUser(user.getUid(), user);
        if (!status.isOK()) {
            if (status instanceof ServerStatus) {
                resp.sendError(((ServerStatus)status).getHttpCode(), status.getMessage());
                return;
            }
            resp.sendError(500, status.getMessage());
            return;
        }
        resp.setContentType("text/html;charset=UTF-8");
        StringBuffer host = new StringBuffer();
        String scheme = req.getScheme();
        host.append(scheme);
        host.append(":////");
        String servername = req.getServerName();
        host.append(servername);
        host.append(":");
        int port = req.getServerPort();
        host.append(port);
        resp.getWriter().write("<html><body><p>Your email address has been confirmed. Thank you! <a href=\"" + host + "\">Click here</a> to continue and login to your Orion account.</p></body></html>");
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        User user;
        String userLogin;
        String userEmail;
        String[] userPathInfoParts;
        this.traceRequest(req);
        String[] stringArray = userPathInfoParts = req.getPathInfo() == null ? new String[]{} : req.getPathInfo().split("\\/", 2);
        if (userPathInfoParts.length > 1 && userPathInfoParts[1] != null && "cansendemails".equalsIgnoreCase(userPathInfoParts[1])) {
            JSONObject jsonResp = new JSONObject();
            try {
                jsonResp.put("emailConfigured", UserEmailUtil.getUtil().isEmailConfigured());
                EmailConfirmationServlet.writeJSONResponse((HttpServletRequest)req, (HttpServletResponse)resp, (Object)jsonResp);
            }
            catch (JSONException e) {
                resp.sendError(500, e.getMessage());
            }
            return;
        }
        try {
            JSONObject data = OrionServlet.readJSONRequest((HttpServletRequest)req);
            userEmail = data.getString("email");
            userLogin = data.getString("login");
        }
        catch (JSONException e) {
            this.getStatusHandler().handleRequest(req, resp, (Object)new ServerStatus(4, 400, "Could not parse json request", (Throwable)e));
            return;
        }
        IOrionCredentialsService userAdmin = this.getUserAdmin();
        HashSet<User> users = new HashSet<User>();
        if (userLogin != null && userLogin.trim().length() > 0) {
            user = userAdmin.getUser("login", userLogin.trim());
            if (user == null) {
                resp.sendError(404, "User " + userLogin + " not found.");
                return;
            }
            if (userEmail != null && userEmail.trim().length() > 0) {
                if (!user.isEmailConfirmed()) {
                    resp.sendError(400, "User " + userLogin + " email has not been yet confirmed." + " Please follow the instructions from the confirmation email in your inbox and then request a password reset again.");
                    return;
                }
                if (!userEmail.equals(user.getEmail())) {
                    resp.sendError(404, "User " + userLogin + " with email " + userEmail + " does not exist.");
                    return;
                }
            }
            users.add(user);
        } else if (userEmail != null && userEmail.trim().length() > 0) {
            user = userAdmin.getUser("email", userEmail.trim());
            if (user != null && user.isEmailConfirmed()) {
                users.add(user);
            }
            if (users.size() == 0) {
                if (user == null) {
                    resp.sendError(404, "User with email " + userEmail + " not found.");
                } else {
                    resp.sendError(400, "Email " + userLogin + " has not been yet confirmed." + " Please follow the instructions from the confirmation email in your inbox and then request a password reset again.");
                }
                return;
            }
        }
        MultiStatus multiStatus = new MultiStatus("org.eclipse.orion.server.core", 0, null, null);
        req.getRequestURI();
        URI baseURI = URI.create(req.getRequestURL().toString());
        for (User user2 : users) {
            multiStatus.add(this.sendPasswordResetConfirmation(user2, baseURI));
        }
        if (!multiStatus.isOK()) {
            int i = 0;
            while (i < multiStatus.getChildren().length) {
                IStatus status = multiStatus.getChildren()[i];
                if (!status.isOK()) {
                    this.getStatusHandler().handleRequest(req, resp, (Object)status);
                    return;
                }
                ++i;
            }
        }
        this.getStatusHandler().handleRequest(req, resp, (Object)new ServerStatus(1, 200, "Confirmation email has been sent to " + userEmail, null));
    }

    private IStatus sendPasswordResetConfirmation(User user, URI baseUri) {
        if (user.getEmail() == null || user.getEmail().length() == 0) {
            return new ServerStatus(4, 400, "User " + user.getLogin() + " doesn't have its email set. Contact administrator to reset your password.", null);
        }
        if (!user.isEmailConfirmed()) {
            return new ServerStatus(4, 400, "Your email has not been yet confirmed. Please follow the instructions from the confirmation email in your inbox and then request a password reset again.", null);
        }
        IOrionCredentialsService userAdmin = this.getUserAdmin();
        user.addProperty("passwordResetId", User.getUniqueEmailConfirmationId());
        IStatus status = userAdmin.updateUser(user.getUid(), user);
        if (!status.isOK()) {
            return status;
        }
        try {
            UserEmailUtil.getUtil().sendResetPasswordConfirmation(baseUri, user);
            return new ServerStatus(1, 200, "Confirmation email has been sent.", null);
        }
        catch (Exception e) {
            LogHelper.log((Throwable)e);
            return new ServerStatus(4, 400, "Could not send confirmation email.", null);
        }
    }
}

