/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.commands;

import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.orion.server.cf.commands.AbstractCFCommand;
import org.eclipse.orion.server.cf.objects.App;
import org.eclipse.orion.server.cf.objects.Target;
import org.eclipse.orion.server.cf.utils.HttpUtil;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.osgi.util.NLS;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetAppCommand
extends AbstractCFCommand {
    private final Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.cf");
    private String commandName;
    private String name;
    private App app;

    public GetAppCommand(Target target, String name) {
        super(target);
        Object[] bindings = new String[]{name};
        this.commandName = NLS.bind((String)"Get application {0}", (Object[])bindings);
        this.name = name;
    }

    @Override
    public ServerStatus _doIt() {
        try {
            URI targetURI = URIUtil.toURI((URL)this.target.getUrl());
            String appsUrl = this.target.getSpace().getCFJSON().getJSONObject("entity").getString("apps_url");
            URI appsURI = targetURI.resolve(appsUrl);
            GetMethod getAppsMethod = new GetMethod(appsURI.toString());
            HttpUtil.configureHttpMethod((HttpMethod)getAppsMethod, this.target);
            getAppsMethod.setQueryString("q=name:" + URLEncoder.encode(this.name, "UTF8") + "&inline-relations-depth=1");
            ServerStatus getStatus = HttpUtil.executeMethod((HttpMethod)getAppsMethod);
            if (!getStatus.isOK()) {
                return getStatus;
            }
            JSONObject apps = getStatus.getJsonData();
            if (!apps.has("resources") || apps.getJSONArray("resources").length() == 0) {
                return new ServerStatus(4, 404, "Application not found", null);
            }
            JSONObject appJSON = apps.getJSONArray("resources").getJSONObject(0).getJSONObject("metadata");
            String summaryAppUrl = String.valueOf(appJSON.getString("url")) + "/summary";
            URI summaryAppURI = targetURI.resolve(summaryAppUrl);
            GetMethod getSummaryMethod = new GetMethod(summaryAppURI.toString());
            HttpUtil.configureHttpMethod((HttpMethod)getSummaryMethod, this.target);
            getStatus = HttpUtil.executeMethod((HttpMethod)getSummaryMethod);
            if (!getStatus.isOK()) {
                return getStatus;
            }
            JSONObject summaryJSON = getStatus.getJsonData();
            this.app = new App();
            this.app.setAppJSON(appJSON);
            this.app.setSummaryJSON(summaryJSON);
            return new ServerStatus(Status.OK_STATUS, 200, this.app.toJSON());
        }
        catch (Exception e) {
            String msg = NLS.bind((String)"An error occured when performing operation {0}", (Object)this.commandName);
            this.logger.error(msg, (Throwable)e);
            return new ServerStatus(4, 500, msg, (Throwable)e);
        }
    }

    public App getApp() {
        return this.app;
    }
}

