/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.handlers.v1;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.orion.internal.server.servlets.ServletResourceHandler;
import org.eclipse.orion.server.cf.commands.ComputeTargetCommand;
import org.eclipse.orion.server.cf.commands.GetAppCommand;
import org.eclipse.orion.server.cf.commands.ParseManifestCommand;
import org.eclipse.orion.server.cf.commands.PushAppCommand;
import org.eclipse.orion.server.cf.commands.StartAppCommand;
import org.eclipse.orion.server.cf.commands.StopAppCommand;
import org.eclipse.orion.server.cf.jobs.CFJob;
import org.eclipse.orion.server.cf.manifest.v2.ManifestParseTree;
import org.eclipse.orion.server.cf.objects.App;
import org.eclipse.orion.server.cf.objects.Target;
import org.eclipse.orion.server.cf.servlets.AbstractRESTHandler;
import org.eclipse.orion.server.cf.utils.HttpUtil;
import org.eclipse.orion.server.core.IOUtilities;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.osgi.util.NLS;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppsHandlerV1
extends AbstractRESTHandler<App> {
    private final Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.cf");

    public AppsHandlerV1(ServletResourceHandler<IStatus> statusHandler) {
        super(statusHandler);
    }

    @Override
    protected App buildResource(HttpServletRequest request, String path) throws CoreException {
        return null;
    }

    @Override
    protected CFJob handleGet(App app, HttpServletRequest request, HttpServletResponse response, final String path) {
        final String encodedContentLocation = IOUtilities.getQueryParameter((HttpServletRequest)request, (String)"ContentLocation");
        String contentLocation = null;
        if (encodedContentLocation != null) {
            try {
                contentLocation = ServletResourceHandler.toOrionLocation((HttpServletRequest)request, (String)URLDecoder.decode(encodedContentLocation, "UTF8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        }
        final String finalContentLocation = contentLocation;
        final String encodedName = IOUtilities.getQueryParameter((HttpServletRequest)request, (String)"Name");
        final JSONObject targetJSON = this.extractJSONData(IOUtilities.getQueryParameter((HttpServletRequest)request, (String)"Target"));
        return new CFJob(request, false){

            protected IStatus performJob() {
                try {
                    ComputeTargetCommand computeTarget = new ComputeTargetCommand(this.userId, targetJSON);
                    IStatus result = computeTarget.doIt();
                    if (!result.isOK()) {
                        return result;
                    }
                    Target target = computeTarget.getTarget();
                    if (encodedName != null) {
                        String name = URLDecoder.decode(encodedName, "UTF8");
                        return new GetAppCommand(target, name).doIt();
                    }
                    if (encodedContentLocation != null) {
                        ManifestParseTree applications;
                        if (finalContentLocation == null) {
                            return new ServerStatus(4, 404, "Can not determine the application name", null);
                        }
                        String manifestAppName = null;
                        ParseManifestCommand parseManifestCommand = new ParseManifestCommand(target, this.userId, finalContentLocation);
                        IStatus status = parseManifestCommand.doIt();
                        if (!status.isOK()) {
                            return status;
                        }
                        ManifestParseTree manifest = parseManifestCommand.getManifest();
                        if (manifest != null && (applications = manifest.get("applications")).getChildren().size() > 0) {
                            manifestAppName = applications.get(0).get("name").getValue();
                            return new GetAppCommand(target, manifestAppName).doIt();
                        }
                        return new ServerStatus(4, 404, "Can not determine the application name", null);
                    }
                    return AppsHandlerV1.this.getApps(target);
                }
                catch (Exception e) {
                    String msg = NLS.bind((String)"Failed to handle request for {0}", (Object)path);
                    ServerStatus status = new ServerStatus(4, 500, msg, (Throwable)e);
                    AppsHandlerV1.this.logger.error(msg, (Throwable)e);
                    return status;
                }
            }
        };
    }

    @Override
    protected CFJob handlePut(App resource, HttpServletRequest request, HttpServletResponse response, final String path) {
        JSONObject jsonData = this.extractJSONData(request);
        final String state = jsonData.optString("State", null);
        final String appName = jsonData.optString("Name", null);
        final JSONObject targetJSON = jsonData.optJSONObject("Target");
        final String contentLocation = ServletResourceHandler.toOrionLocation((HttpServletRequest)request, (String)jsonData.optString("ContentLocation", null));
        int userTimeout = jsonData.optInt("Timeout", 60);
        final int timeout = userTimeout > 0 ? userTimeout : 0;
        final boolean force = jsonData.optBoolean("Force", true);
        return new CFJob(request, false){

            protected IStatus performJob() {
                try {
                    ComputeTargetCommand computeTarget = new ComputeTargetCommand(this.userId, targetJSON);
                    IStatus status = computeTarget.doIt();
                    if (!status.isOK()) {
                        return status;
                    }
                    Target target = computeTarget.getTarget();
                    String manifestAppName = null;
                    ParseManifestCommand parseManifestCommand = null;
                    if (contentLocation != null) {
                        ManifestParseTree applications;
                        parseManifestCommand = new ParseManifestCommand(target, this.userId, contentLocation);
                        status = parseManifestCommand.doIt();
                        if (!status.isOK()) {
                            return status;
                        }
                        ManifestParseTree manifest = parseManifestCommand.getManifest();
                        if (manifest != null && (applications = manifest.get("applications")).getChildren().size() > 0) {
                            manifestAppName = applications.get(0).get("name").getValue();
                        }
                    }
                    GetAppCommand getAppCommand = new GetAppCommand(target, appName != null ? appName : manifestAppName);
                    status = getAppCommand.doIt();
                    App app = getAppCommand.getApp();
                    if ("Started".equals(state)) {
                        if (!status.isOK()) {
                            return status;
                        }
                        return new StartAppCommand(target, app, timeout).doIt();
                    }
                    if ("Stopped".equals(state)) {
                        if (!status.isOK()) {
                            return status;
                        }
                        return new StopAppCommand(target, app).doIt();
                    }
                    if (parseManifestCommand == null) {
                        String msg = NLS.bind((String)"Failed to handle request for {0}", (Object)path);
                        status = new ServerStatus(4, 500, msg, null);
                        AppsHandlerV1.this.logger.error(msg);
                        return status;
                    }
                    if (app == null) {
                        app = new App();
                    }
                    app.setName(appName != null ? appName : manifestAppName);
                    app.setManifest(parseManifestCommand.getManifest());
                    app.setAppStore(parseManifestCommand.getAppStore());
                    status = new PushAppCommand(target, app, force).doIt();
                    if (!status.isOK()) {
                        return status;
                    }
                    getAppCommand = new GetAppCommand(target, app.getName());
                    getAppCommand.doIt();
                    app = getAppCommand.getApp();
                    app.setManifest(parseManifestCommand.getManifest());
                    new StartAppCommand(target, app).doIt();
                    return status;
                }
                catch (Exception e) {
                    String msg = NLS.bind((String)"Failed to handle request for {0}", (Object)path);
                    ServerStatus status = new ServerStatus(4, 500, msg, (Throwable)e);
                    AppsHandlerV1.this.logger.error(msg, (Throwable)e);
                    return status;
                }
            }
        };
    }

    private IStatus getApps(Target target) throws Exception {
        String appsUrl = target.getSpace().getCFJSON().getJSONObject("entity").getString("apps_url");
        appsUrl = appsUrl.replaceAll("apps", "summary");
        URI appsURI = URIUtil.toURI((URL)target.getUrl()).resolve(appsUrl);
        GetMethod getMethod = new GetMethod(appsURI.toString());
        HttpUtil.configureHttpMethod((HttpMethod)getMethod, target);
        return HttpUtil.executeMethod((HttpMethod)getMethod);
    }
}

