/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.manifest.v2;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.orion.server.cf.manifest.v2.InvalidAccessException;
import org.eclipse.orion.server.cf.manifest.v2.Token;

public class ManifestParseTree {
    private List<Token> tokens;
    private List<ManifestParseTree> children = new ArrayList<ManifestParseTree>();
    private ManifestParseTree parent;
    private int level;

    public ManifestParseTree() {
        this.tokens = new ArrayList<Token>();
        this.parent = this;
        this.level = 0;
    }

    public ManifestParseTree(int level) {
        this.tokens = new ArrayList<Token>();
        this.parent = this;
        this.level = level;
    }

    public String getLabel() {
        StringBuilder sb = new StringBuilder();
        int n = this.tokens.size();
        int i = 0;
        while (i < n) {
            Token token = this.tokens.get(i);
            sb.append(token.getContent());
            if (3 != token.getType() && i + 1 < n && 3 != this.tokens.get(i + 1).getType()) {
                sb.append(" ");
            }
            ++i;
        }
        return sb.toString().trim();
    }

    public ManifestParseTree get(String childName) throws InvalidAccessException {
        for (ManifestParseTree child : this.children) {
            if (!childName.equals(child.getLabel())) continue;
            return child;
        }
        throw new InvalidAccessException(this, childName);
    }

    public ManifestParseTree getOpt(String childName) {
        for (ManifestParseTree child : this.children) {
            if (!childName.equals(child.getLabel())) continue;
            return child;
        }
        return null;
    }

    public boolean has(String childName) {
        return this.getOpt(childName) != null;
    }

    public ManifestParseTree get(int kthChild) throws InvalidAccessException {
        int curretChild = -1;
        for (ManifestParseTree child : this.children) {
            if (!child.isItemNode() || ++curretChild != kthChild) continue;
            return child;
        }
        throw new InvalidAccessException(this, kthChild);
    }

    public String getValue() throws InvalidAccessException {
        if (this.children.isEmpty()) {
            throw new InvalidAccessException(this);
        }
        return this.children.get(0).getLabel().replaceAll("^\"|^'|\"$|'$", "");
    }

    public boolean isList() {
        if (this.children.isEmpty()) {
            return false;
        }
        return this.children.get(0).isItemNode();
    }

    protected String toString(int indentation) {
        boolean isItemNode;
        StringBuilder sb = new StringBuilder();
        if (this.getParent() == this) {
            sb.append("---" + System.getProperty("line.separator"));
            for (ManifestParseTree child : this.children) {
                sb.append(String.valueOf(child.toString(0)) + System.getProperty("line.separator"));
            }
            return sb.toString();
        }
        int i = 0;
        while (i < indentation) {
            sb.append(" ");
            ++i;
        }
        sb.append(this.getLabel());
        boolean bl = isItemNode = this.tokens.size() == 1 && 2 == this.tokens.get(0).getType();
        if (!isItemNode && this.children.size() > 0) {
            sb.append(":");
        }
        int childrenSize = this.children.size();
        int i2 = 0;
        while (i2 < childrenSize) {
            ManifestParseTree child = this.children.get(i2);
            if (isItemNode && i2 == 0 || childrenSize == 1 && child.getChildren().size() == 0) {
                sb.append(" ");
                sb.append(child.toString(0));
            } else {
                sb.append(System.getProperty("line.separator"));
                if (!child.isItemNode()) {
                    sb.append(child.toString(indentation + 2));
                } else {
                    sb.append(child.toString(indentation));
                }
            }
            ++i2;
        }
        return sb.toString();
    }

    public boolean isRoot() {
        return this.parent == this;
    }

    public boolean isItemNode() {
        return this.tokens.size() == 1 && 2 == this.tokens.get(0).getType();
    }

    public List<ManifestParseTree> getChildren() {
        return this.children;
    }

    public ManifestParseTree getParent() {
        return this.parent;
    }

    public void setParent(ManifestParseTree father) {
        this.parent = father;
    }

    public int getLevel() {
        return this.level;
    }

    public List<Token> getTokens() {
        return this.tokens;
    }

    public String toString() {
        return this.toString(0);
    }
}

