/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.servlets;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.StringTokenizer;
import java.util.zip.GZIPOutputStream;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class ExcludedExtensionGzipFilter
implements Filter {
    static final String INCLUDE_REQUEST_URI_ATTRIBUTE = "javax.servlet.include.request_uri";
    static final String FORWARD_REQUEST_URI_ATTRIBUTE = "javax.servlet.forward.request_uri";
    private HashSet<String> _excludedExtensions = new HashSet();

    public void init(FilterConfig filterConfig) throws ServletException {
        String excludedExtensionsParam = filterConfig.getInitParameter("excludedExtensions");
        if (excludedExtensionsParam != null) {
            StringTokenizer tokenizer = new StringTokenizer(excludedExtensionsParam, ",", false);
            while (tokenizer.hasMoreTokens()) {
                this._excludedExtensions.add(tokenizer.nextToken().trim());
            }
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.isApplicable((HttpServletRequest)request)) {
            GZipServletResponse gzipResponse = new GZipServletResponse((HttpServletResponse)response);
            chain.doFilter(request, (ServletResponse)gzipResponse);
            gzipResponse.close();
        } else {
            chain.doFilter(request, response);
        }
    }

    private boolean isApplicable(HttpServletRequest req) {
        String extension;
        if (req.getAttribute(INCLUDE_REQUEST_URI_ATTRIBUTE) != null || req.getAttribute(FORWARD_REQUEST_URI_ATTRIBUTE) != null) {
            return false;
        }
        String acceptEncoding = req.getHeader("Accept-Encoding");
        if (acceptEncoding == null || !acceptEncoding.contains("gzip")) {
            return false;
        }
        String pathInfo = req.getPathInfo();
        if (pathInfo == null || this._excludedExtensions.isEmpty()) {
            return true;
        }
        int dot = pathInfo.lastIndexOf(46);
        return dot == -1 || !this._excludedExtensions.contains(extension = pathInfo.substring(dot + 1).toLowerCase());
    }

    public void destroy() {
    }

    public static class GZipServletResponse
    extends HttpServletResponseWrapper {
        private PrintWriter _printWriter;
        private ServletOutputStream _servletOutputStream;

        public GZipServletResponse(HttpServletResponse response) {
            super(response);
        }

        public ServletOutputStream getOutputStream() throws IOException {
            if (this._printWriter != null) {
                throw new IllegalStateException();
            }
            if (this._servletOutputStream == null) {
                ((HttpServletResponse)this.getResponse()).setHeader("Content-Encoding", "gzip");
                this._servletOutputStream = new ServletOutputStreamWrapper(new GZIPOutputStream((OutputStream)this.getResponse().getOutputStream()));
            }
            return this._servletOutputStream;
        }

        public PrintWriter getWriter() throws IOException {
            if (this._printWriter == null) {
                if (this._servletOutputStream != null) {
                    throw new IllegalStateException();
                }
                ((HttpServletResponse)this.getResponse()).setHeader("Content-Encoding", "gzip");
                this._servletOutputStream = new ServletOutputStreamWrapper(new GZIPOutputStream((OutputStream)this.getResponse().getOutputStream()));
                this._printWriter = new PrintWriter((OutputStream)this._servletOutputStream);
            }
            return this._printWriter;
        }

        public void flushBuffer() throws IOException {
            if (this._printWriter != null) {
                this._printWriter.flush();
            } else if (this._servletOutputStream != null) {
                this._servletOutputStream.flush();
            }
        }

        public void setContentLength(int len) {
        }

        public void close() throws IOException {
            if (this._printWriter != null) {
                this._printWriter.close();
            } else if (this._servletOutputStream != null) {
                this._servletOutputStream.close();
            }
        }
    }

    public static class ServletOutputStreamWrapper
    extends ServletOutputStream {
        private OutputStream _outputStream;

        public ServletOutputStreamWrapper(OutputStream outputStream) throws IOException {
            this._outputStream = outputStream;
        }

        public void write(int b) throws IOException {
            this._outputStream.write(b);
        }

        public void write(byte[] b) throws IOException {
            this._outputStream.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this._outputStream.write(b, off, len);
        }

        public void flush() throws IOException {
            this._outputStream.flush();
        }

        public void close() throws IOException {
            this._outputStream.close();
        }
    }
}

