/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.git.jobs;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.LogCommand;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.orion.server.git.jobs.GitJob;
import org.eclipse.orion.server.git.objects.Log;
import org.eclipse.orion.server.git.objects.Remote;
import org.eclipse.orion.server.git.servlets.GitUtils;
import org.eclipse.osgi.util.NLS;
import org.json.JSONArray;
import org.json.JSONObject;

public class RemoteDetailsJob
extends GitJob {
    private IPath path;
    private URI cloneLocation;
    private int commitsSize;
    private int pageNo;
    private int pageSize;
    private String baseLocation;
    private String configName;
    private String nameFilter;

    public RemoteDetailsJob(String userRunningTask, String configName, IPath repositoryPath, URI cloneLocation, int commitsSize, int pageNo, int pageSize, String baseLocation, String filter) {
        super(userRunningTask, false);
        this.path = repositoryPath;
        this.cloneLocation = cloneLocation;
        this.commitsSize = commitsSize;
        this.pageNo = pageNo;
        this.pageSize = pageSize;
        this.baseLocation = baseLocation;
        this.configName = configName;
        this.nameFilter = filter;
    }

    public RemoteDetailsJob(String userRunningTask, String configName, IPath repositoryPath, URI cloneLocation) {
        this(userRunningTask, configName, repositoryPath, cloneLocation, 0, 0, -1, null, "");
    }

    public RemoteDetailsJob(String userRunningTask, String configName, IPath repositoryPath, URI cloneLocation, int commitsSize, String filterParm) {
        this(userRunningTask, configName, repositoryPath, cloneLocation, commitsSize, 0, -1, null, filterParm);
    }

    private ObjectId getCommitObjectId(Repository db, ObjectId oid) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        RevWalk walk = new RevWalk(db);
        try {
            RevCommit revCommit = walk.parseCommit((AnyObjectId)oid);
            return revCommit;
        }
        finally {
            walk.release();
        }
    }

    protected IStatus performJob(IProgressMonitor monitor) {
        Repository db = null;
        try {
            File gitDir = GitUtils.getGitDir(this.path);
            db = FileRepositoryBuilder.create((File)gitDir);
            Git git = new Git(db);
            Set configNames = db.getConfig().getSubsections("remote");
            for (String configN : configNames) {
                if (!configN.equals(this.configName)) continue;
                Remote remote = new Remote(this.cloneLocation, db, configN);
                JSONObject result = remote.toJSON();
                if (!result.has("Children")) {
                    ServerStatus serverStatus = new ServerStatus(Status.OK_STATUS, 200, result);
                    return serverStatus;
                }
                JSONArray children = result.getJSONArray("Children");
                JSONArray filteredChildren = new JSONArray();
                if (children.length() == 0 || this.commitsSize == 0 && this.pageSize < 0) {
                    if (this.nameFilter != null && !this.nameFilter.equals("")) {
                        int i = 0;
                        while (i < children.length()) {
                            JSONObject test = (JSONObject)children.get(i);
                            String name = (String)test.get("Name");
                            if (name.toLowerCase().contains(this.nameFilter.toLowerCase())) {
                                filteredChildren.put((Object)test);
                            }
                            ++i;
                        }
                        result.put("Children", (Object)filteredChildren);
                    }
                    ServerStatus serverStatus = new ServerStatus(Status.OK_STATUS, 200, result);
                    return serverStatus;
                }
                int firstChild = this.pageSize > 0 ? this.pageSize * (this.pageNo - 1) : 0;
                int lastChild = this.pageSize > 0 ? firstChild + this.pageSize - 1 : children.length() - 1;
                int n = lastChild = lastChild > children.length() - 1 ? children.length() - 1 : lastChild;
                if (this.pageNo > 1 && this.baseLocation != null) {
                    String prev = String.valueOf(this.baseLocation) + "?page=" + (this.pageNo - 1) + "&pageSize=" + this.pageSize;
                    if (this.commitsSize > 0) {
                        prev = String.valueOf(prev) + "&commits=" + this.commitsSize;
                    }
                    result.put("PreviousLocation", (Object)prev);
                }
                if (lastChild < children.length() - 1) {
                    String next = String.valueOf(this.baseLocation) + "?page=" + (this.pageNo + 1) + "&pageSize=" + this.pageSize;
                    if (this.commitsSize > 0) {
                        next = String.valueOf(next) + "&commits=" + this.commitsSize;
                    }
                    result.put("NextLocation", (Object)next);
                }
                JSONArray newChildren = new JSONArray();
                int i = firstChild;
                while (i <= lastChild) {
                    if (monitor.isCanceled()) {
                        Status status = new Status(8, "org.eclipse.orion.server.git", "Cancelled");
                        return status;
                    }
                    JSONObject branch = children.getJSONObject(i);
                    if (this.commitsSize == 0) {
                        newChildren.put((Object)branch);
                    } else {
                        LogCommand lc = git.log();
                        String branchName = branch.getString("Id");
                        ObjectId toObjectId = db.resolve(branchName);
                        Ref toRefId = db.getRef(branchName);
                        if (toObjectId == null) {
                            String msg = NLS.bind((String)"No ref or commit found: {0}", (Object)branchName);
                            ServerStatus serverStatus = new ServerStatus(4, 404, msg, null);
                            return serverStatus;
                        }
                        toObjectId = this.getCommitObjectId(db, toObjectId);
                        lc.add((AnyObjectId)toObjectId);
                        lc.setMaxCount(this.commitsSize);
                        Iterable commits = lc.call();
                        Log log = new Log(this.cloneLocation, db, commits, null, null, toRefId);
                        log.setPaging(1, this.commitsSize);
                        branch.put("Commit", (Object)log.toJSON());
                        newChildren.put((Object)branch);
                    }
                    ++i;
                }
                result.put("Children", (Object)newChildren);
                ServerStatus serverStatus = new ServerStatus(Status.OK_STATUS, 200, result);
                return serverStatus;
            }
            String msg = NLS.bind((String)"Couldn't find remote : {0}", (Object)this.configName);
            ServerStatus serverStatus = new ServerStatus(4, 404, msg, null);
            return serverStatus;
        }
        catch (Exception e) {
            String msg = NLS.bind((String)"Couldn't get remote details : {0}", (Object)this.configName);
            Status status = new Status(4, "org.eclipse.orion.server.git", msg, (Throwable)e);
            return status;
        }
        finally {
            if (db != null) {
                db.close();
            }
        }
    }
}

