/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.commands;

import java.net.URI;
import java.net.URL;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.orion.server.cf.commands.AbstractCFCommand;
import org.eclipse.orion.server.cf.commands.GetAppCommand;
import org.eclipse.orion.server.cf.manifest.v2.InvalidAccessException;
import org.eclipse.orion.server.cf.manifest.v2.ManifestParseTree;
import org.eclipse.orion.server.cf.manifest.v2.utils.ManifestUtils;
import org.eclipse.orion.server.cf.objects.App;
import org.eclipse.orion.server.cf.objects.Target;
import org.eclipse.orion.server.cf.utils.HttpUtil;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.osgi.util.NLS;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateApplicationCommand
extends AbstractCFCommand {
    private final Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.cf");
    private String commandName = "Update application parameters";
    private App application;
    private String appName;
    private String appCommand;
    private int appInstances;
    private int appMemory;
    private String buildPack;
    private JSONObject env;

    public UpdateApplicationCommand(Target target, App app) {
        super(target);
        this.application = app;
    }

    @Override
    protected ServerStatus _doIt() {
        try {
            URI targetURI = URIUtil.toURI((URL)this.target.getUrl());
            URI appURI = targetURI.resolve(this.application.getAppJSON().getString("url"));
            PutMethod updateApplicationMethod = new PutMethod(appURI.toString());
            ServerStatus confStatus = HttpUtil.configureHttpMethod((HttpMethod)updateApplicationMethod, this.target.getCloud());
            if (!confStatus.isOK()) {
                return confStatus;
            }
            updateApplicationMethod.setQueryString("async=true&inline-relations-depth=1");
            JSONObject updateAppRequest = new JSONObject();
            updateAppRequest.put("name", (Object)this.appName);
            updateAppRequest.put("instances", this.appInstances);
            updateAppRequest.put("command", (Object)this.appCommand);
            updateAppRequest.put("memory", this.appMemory);
            updateAppRequest.put("environment_json", (Object)(this.env != null ? this.env : new JSONObject()));
            updateAppRequest.put("buildpack", this.buildPack != null ? this.buildPack : JSONObject.NULL);
            updateApplicationMethod.setRequestEntity((RequestEntity)new StringRequestEntity(updateAppRequest.toString(), "application/json", "utf-8"));
            ServerStatus status = HttpUtil.executeMethod((HttpMethodBase)updateApplicationMethod);
            if (!status.isOK()) {
                return status;
            }
            GetAppCommand.expire(this.target, this.application.getName());
            return status;
        }
        catch (Exception e) {
            String msg = NLS.bind((String)"An error occured when performing operation {0}", (Object)this.commandName);
            this.logger.error(msg, (Throwable)e);
            return new ServerStatus(4, 500, msg, (Throwable)e);
        }
    }

    @Override
    protected IStatus validateParams() {
        try {
            ManifestParseTree appEnvNode;
            ManifestParseTree manifest = this.application.getManifest();
            ManifestParseTree app = manifest.get("applications").get(0);
            this.appName = this.application.getName() != null ? this.application.getName() : app.get("name").getValue();
            ManifestParseTree commandNode = app.getOpt("command");
            this.appCommand = commandNode != null ? commandNode.getValue() : "";
            ManifestParseTree instancesNode = app.getOpt("instances");
            this.appInstances = instancesNode != null ? Integer.parseInt(instancesNode.getValue()) : 1;
            ManifestParseTree memoryNode = app.getOpt("memory");
            this.appMemory = memoryNode != null ? ManifestUtils.normalizeMemoryMeasure(memoryNode.getValue()) : ((memoryNode = app.getOpt("mem")) != null ? ManifestUtils.normalizeMemoryMeasure(memoryNode.getValue()) : 1024);
            ManifestParseTree buildpackNode = app.getOpt("buildpack");
            this.buildPack = buildpackNode != null ? buildpackNode.getValue() : null;
            ManifestParseTree envNode = manifest.getOpt("env");
            if (envNode != null) {
                this.env = new JSONObject();
                for (ManifestParseTree var : envNode.getChildren()) {
                    this.env.put(var.getLabel(), (Object)var.getValue());
                }
            }
            if ((appEnvNode = app.getOpt("env")) != null) {
                this.env = new JSONObject();
                for (ManifestParseTree var : appEnvNode.getChildren()) {
                    this.env.put(var.getLabel(), (Object)var.getValue());
                }
            }
            return Status.OK_STATUS;
        }
        catch (InvalidAccessException e) {
            return new ServerStatus(4, 400, e.getMessage(), null);
        }
        catch (Exception e) {
            String msg = NLS.bind((String)"An error occured when performing operation {0}", (Object)this.commandName);
            this.logger.error(msg, (Throwable)e);
            return new ServerStatus(4, 500, msg, (Throwable)e);
        }
    }
}

