/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.handlers.v1;

import java.net.URL;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.orion.internal.server.servlets.ServletResourceHandler;
import org.eclipse.orion.server.cf.CFActivator;
import org.eclipse.orion.server.cf.commands.ComputeTargetCommand;
import org.eclipse.orion.server.cf.commands.LoginCommand;
import org.eclipse.orion.server.cf.commands.LogoutCommand;
import org.eclipse.orion.server.cf.jobs.CFJob;
import org.eclipse.orion.server.cf.objects.Cloud;
import org.eclipse.orion.server.cf.objects.Target;
import org.eclipse.orion.server.cf.servlets.AbstractRESTHandler;
import org.eclipse.orion.server.core.IOUtilities;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.osgi.util.NLS;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TargetHandlerV1
extends AbstractRESTHandler<Target> {
    private final Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.cf");

    public TargetHandlerV1(ServletResourceHandler<IStatus> statusHandler) {
        super(statusHandler);
    }

    @Override
    protected Target buildResource(HttpServletRequest request, String path) throws CoreException {
        return null;
    }

    @Override
    protected CFJob handleGet(Target target, HttpServletRequest request, HttpServletResponse response, final String path) {
        return new CFJob(request, false){

            protected IStatus performJob() {
                try {
                    Target target = CFActivator.getDefault().getTargetRegistry().getDefaultTarget(this.userId);
                    if (target == null) {
                        String msg = "Target not set";
                        return new ServerStatus(4, 404, msg, null);
                    }
                    return new ServerStatus(Status.OK_STATUS, 200, target.toJSON());
                }
                catch (JSONException e) {
                    String msg = NLS.bind((String)"Failed to handle request for {0}", (Object)path);
                    ServerStatus status = new ServerStatus(4, 500, msg, (Throwable)e);
                    TargetHandlerV1.this.logger.error(msg, (Throwable)e);
                    return status;
                }
            }
        };
    }

    @Override
    protected CFJob handlePost(Target resource, HttpServletRequest request, HttpServletResponse response, final String path) {
        final JSONObject jsonData = this.extractJSONData(request);
        return new CFJob(request, false){

            protected IStatus performJob() {
                try {
                    ComputeTargetCommand computeTarget = new ComputeTargetCommand(this.userId, jsonData);
                    IStatus result = computeTarget.doIt();
                    Target target = computeTarget.getTarget();
                    if (jsonData.has("Username") && jsonData.has("Password") && !(result = new LoginCommand(target.getCloud(), jsonData.getString("Username"), jsonData.getString("Password")).doIt()).isOK()) {
                        return result;
                    }
                    CFActivator.getDefault().getTargetRegistry().setDefaultTarget(this.userId, target);
                    return new ServerStatus(Status.OK_STATUS, 200, target.toJSON());
                }
                catch (Exception e) {
                    String msg = NLS.bind((String)"Failed to handle request for {0}", (Object)path);
                    ServerStatus status = new ServerStatus(4, 500, msg, (Throwable)e);
                    TargetHandlerV1.this.logger.error(msg, (Throwable)e);
                    return status;
                }
            }
        };
    }

    @Override
    protected CFJob handlePut(Target resource, HttpServletRequest request, HttpServletResponse response, final String path) {
        final JSONObject jsonData = this.extractJSONData(request);
        return new CFJob(request, false){

            protected IStatus performJob() {
                try {
                    JSONArray regions = jsonData.getJSONArray("Targets");
                    int i = 0;
                    while (i < regions.length()) {
                        JSONObject region = regions.getJSONObject(i);
                        String url = region.getString("Url");
                        Cloud cloud = CFActivator.getDefault().getTargetRegistry().getCloud(this.userId, new URL(url));
                        JSONObject accessToken = new JSONObject();
                        accessToken.put("access_token", (Object)region.getString("AccessToken"));
                        cloud.setAccessToken(accessToken);
                        ++i;
                    }
                    return new ServerStatus(Status.OK_STATUS, 200);
                }
                catch (Exception e) {
                    String msg = NLS.bind((String)"Failed to handle request for {0}", (Object)path);
                    ServerStatus status = new ServerStatus(4, 500, msg, (Throwable)e);
                    TargetHandlerV1.this.logger.error(msg, (Throwable)e);
                    return status;
                }
            }
        };
    }

    @Override
    protected CFJob handleDelete(Target resource, HttpServletRequest request, HttpServletResponse response, final String path) {
        final String invalidate = IOUtilities.getQueryParameter((HttpServletRequest)request, (String)"Invalidate");
        final JSONObject targetJSON = this.extractJSONData(IOUtilities.getQueryParameter((HttpServletRequest)request, (String)"Target"));
        return new CFJob(request, false){

            protected IStatus performJob() {
                try {
                    ComputeTargetCommand computeTarget = new ComputeTargetCommand(this.userId, targetJSON);
                    computeTarget.doIt();
                    Target target = computeTarget.getTarget();
                    if (target == null) {
                        String msg = "Target not set";
                        return new ServerStatus(4, 404, msg, null);
                    }
                    LogoutCommand logoutCommand = new LogoutCommand(target, Boolean.parseBoolean(invalidate));
                    return logoutCommand.doIt();
                }
                catch (Exception e) {
                    String msg = NLS.bind((String)"Failed to handle request for {0}", (Object)path);
                    ServerStatus status = new ServerStatus(4, 500, msg, (Throwable)e);
                    TargetHandlerV1.this.logger.error(msg, (Throwable)e);
                    return status;
                }
            }
        };
    }
}

