/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.gerritfs;

import com.google.gerrit.extensions.annotations.Export;
import com.google.gerrit.httpd.WebSession;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.AccessPath;
import com.google.gerrit.server.account.AccountCache;
import com.google.gerrit.server.account.AccountException;
import com.google.gerrit.server.account.AccountManager;
import com.google.gerrit.server.account.AccountState;
import com.google.gerrit.server.account.AuthRequest;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.project.NoSuchProjectException;
import com.google.gerrit.server.project.ProjectControl;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.orion.server.gerritfs.GerritListFile;
import org.json.JSONArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Export(value="/contents/*")
@Singleton
public class GerritFileContents
extends HttpServlet {
    private final GitRepositoryManager repoManager;
    private final ProjectControl.Factory projControlFactory;
    private final Provider<WebSession> session;
    private final AccountCache accountCache;
    private final Config config;
    private final AccountManager accountManager;
    private static Logger log = LoggerFactory.getLogger(GerritFileContents.class);

    @Inject
    public GerritFileContents(GitRepositoryManager repoManager, ProjectControl.Factory project, Provider<WebSession> session, AccountCache accountCache, @GerritServerConfig Config config, AccountManager accountManager) {
        this.repoManager = repoManager;
        this.projControlFactory = project;
        this.session = session;
        this.accountCache = accountCache;
        this.config = config;
        this.accountManager = accountManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        ServletOutputStream out = resp.getOutputStream();
        this.handleAuth(req);
        try {
            Project.NameKey projName;
            String pathInfo = req.getPathInfo();
            Pattern pattern = Pattern.compile("/([^/]*)(?:/([^/]*)(?:/(.*))?)?");
            Matcher matcher = pattern.matcher(pathInfo);
            matcher.matches();
            String projectName = null;
            String refName = null;
            String filePath = null;
            if (matcher.groupCount() > 0) {
                projectName = matcher.group(1);
                refName = matcher.group(2);
                filePath = matcher.group(3);
                projectName = projectName == null || projectName.equals("") ? null : URLDecoder.decode(projectName, "UTF-8");
                refName = refName == null || refName.equals("") ? null : URLDecoder.decode(refName, "UTF-8");
                filePath = filePath == null || filePath.equals("") ? null : URLDecoder.decode(filePath, "UTF-8");
            }
            if (projectName != null) {
                projName = Project.NameKey.parse((String)projectName);
                try {
                    ProjectControl control = this.projControlFactory.controlFor(projName);
                    if (!control.isVisible()) {
                        log.debug("Project not visible!");
                        resp.sendError(401, "You need to be logged in to see private projects");
                        return;
                    }
                }
                catch (NoSuchProjectException e1) {
                    resp.sendError(400, "No such project exists.");
                }
            }
            if (projectName == null || refName == null || filePath == null) {
                resp.sendError(400, "You need to provide a projectName, refName and filePath.");
                return;
            }
            projName = Project.NameKey.parse((String)projectName);
            Repository repo = this.repoManager.openRepository(projName);
            Git git = new Git(repo);
            Ref head = repo.getRef(refName);
            RevWalk walk = new RevWalk(repo);
            RevCommit commit = walk.parseCommit((AnyObjectId)head.getObjectId());
            RevTree tree = commit.getTree();
            TreeWalk treeWalk = new TreeWalk(repo);
            treeWalk.addTree((AnyObjectId)tree);
            treeWalk.setRecursive(true);
            treeWalk.setFilter((TreeFilter)PathFilter.create((String)filePath));
            if (!treeWalk.next()) {
                throw new IllegalStateException("No file found");
            }
            ObjectId objId = treeWalk.getObjectId(0);
            ObjectLoader loader = repo.open((AnyObjectId)objId);
            if (treeWalk.next()) {
                JSONArray contents = GerritListFile.getListEntries(treeWalk, repo, git, head, filePath, projectName);
                String response = contents.toString();
                resp.setContentType("application/json");
                resp.setHeader("Cache-Control", "no-cache");
                resp.setHeader("ETag", "\"" + tree.getId().getName() + "\"");
                out.print(response);
            } else {
                resp.setHeader("Cache-Control", "no-cache");
                resp.setHeader("ETag", "\"" + tree.getId().getName() + "\"");
                resp.setContentType("application/octet-stream");
                loader.copyTo((OutputStream)out);
            }
            walk.release();
            treeWalk.release();
        }
        finally {
            out.close();
        }
    }

    private void handleAuth(HttpServletRequest req) {
        String username = req.getRemoteUser();
        if (username != null) {
            if (this.config.getBoolean("auth", "userNameToLowerCase", false)) {
                username = username.toLowerCase(Locale.US);
            }
            log.debug("User name: " + username);
            AccountState who = this.accountCache.getByUsername(username);
            log.debug("AccountState " + who);
            if (who == null && username.matches("^([a-zA-Z0-9][a-zA-Z0-9._-]*[a-zA-Z0-9]|[a-zA-Z0-9])$")) {
                log.debug("User is not registered with Gerrit. Register now.");
                AuthRequest areq = AuthRequest.forUser((String)username);
                try {
                    this.accountManager.authenticate(areq);
                    who = this.accountCache.getByUsername(username);
                    if (who == null) {
                        log.warn("Unable to register user \"" + username + "\". Continue as anonymous.");
                    } else {
                        log.debug("User registered.");
                    }
                }
                catch (AccountException e) {
                    log.warn("Exception registering user \"" + username + "\". Continue as anonymous.", (Throwable)e);
                }
            }
            if (who != null && who.getAccount().isActive()) {
                log.debug("Not anonymous user");
                WebSession ws = (WebSession)this.session.get();
                ws.setUserAccountId(who.getAccount().getId());
                ws.setAccessPathOk(AccessPath.REST_API, true);
            } else {
                log.debug("Anonymous user");
            }
        }
    }
}

