/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.git.objects;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectStream;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.EmptyTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.AndTreeFilter;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.jgit.util.io.NullOutputStream;
import org.eclipse.orion.server.core.resources.Property;
import org.eclipse.orion.server.core.resources.ResourceShape;
import org.eclipse.orion.server.core.resources.annotations.PropertyDescription;
import org.eclipse.orion.server.core.resources.annotations.ResourceDescription;
import org.eclipse.orion.server.core.users.UserUtilities;
import org.eclipse.orion.server.git.BaseToCommitConverter;
import org.eclipse.orion.server.git.objects.GitObject;
import org.eclipse.orion.server.git.objects.Log;
import org.eclipse.orion.server.git.objects.Tag;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@ResourceDescription(type="Commit")
public class Commit
extends GitObject {
    public static final String RESOURCE = "commit";
    public static final String TYPE = "Commit";
    protected static final ResourceShape DEFAULT_RESOURCE_SHAPE = new ResourceShape();
    protected RevCommit revCommit;
    protected String pattern;
    protected TreeFilter filter;
    protected boolean isRoot;
    protected Map<ObjectId, JSONArray> commitToBranchMap;
    protected Map<ObjectId, Map<String, Ref>> commitToTagMap;

    public Commit(URI cloneLocation, Repository db, RevCommit revCommit, String pattern) {
        super(cloneLocation, db);
        Property[] defaultProperties = new Property[]{new Property("Location"), new Property("CloneLocation"), new Property("ContentLocation"), new Property("DiffLocation"), new Property("Name"), new Property("AuthorName"), new Property("AuthorEmail"), new Property("AuthorImage"), new Property("CommitterName"), new Property("CommitterEmail"), new Property("Time"), new Property("Message"), new Property("Tags"), new Property("Branches"), new Property("Parents"), new Property("TreeLocation"), new Property("Diffs")};
        DEFAULT_RESOURCE_SHAPE.setProperties(defaultProperties);
        this.isRoot = true;
        this.revCommit = revCommit;
        if (revCommit.getParentCount() == 0) {
            this.revCommit = this.parseCommit(revCommit);
        }
        this.pattern = pattern;
        if (pattern != null && !pattern.isEmpty()) {
            this.filter = AndTreeFilter.create((TreeFilter)PathFilterGroup.createFromStrings(Collections.singleton(pattern)), (TreeFilter)TreeFilter.ANY_DIFF);
            this.isRoot = false;
        }
    }

    public void setCommitToBranchMap(Map<ObjectId, JSONArray> map) {
        this.commitToBranchMap = map;
    }

    public void setCommitToTagMap(Map<ObjectId, Map<String, Ref>> map) {
        this.commitToTagMap = map;
    }

    public Map<ObjectId, JSONArray> getCommitToBranchMap() throws GitAPIException, JSONException, URISyntaxException, IOException, CoreException {
        if (this.commitToBranchMap == null) {
            this.commitToBranchMap = Log.getCommitToBranchMap(this.cloneLocation, this.db);
        }
        return this.commitToBranchMap;
    }

    public Map<ObjectId, Map<String, Ref>> getCommitToTagMap() throws GitAPIException, JSONException, URISyntaxException, IOException, CoreException {
        if (this.commitToTagMap == null) {
            this.commitToTagMap = Log.getCommitToTagMap(this.cloneLocation, this.db);
        }
        return this.commitToTagMap;
    }

    public ObjectStream toObjectStream() throws IOException {
        TreeWalk w = TreeWalk.forPath((Repository)this.db, (String)this.pattern, (RevTree)this.revCommit.getTree());
        if (w == null) {
            return null;
        }
        ObjectId blobId = w.getObjectId(0);
        return this.db.open((AnyObjectId)blobId, 3).openStream();
    }

    @Override
    public JSONObject toJSON() throws JSONException, URISyntaxException, IOException, CoreException {
        return (JSONObject)this.jsonSerializer.serialize((Object)this, DEFAULT_RESOURCE_SHAPE);
    }

    @PropertyDescription(name="ContentLocation")
    protected URI getContentLocation() throws URISyntaxException {
        if (!this.isRoot) {
            return BaseToCommitConverter.getCommitLocation(this.cloneLocation, this.revCommit.getName(), this.pattern, BaseToCommitConverter.REMOVE_FIRST_2.setQuery("parts=body"));
        }
        return null;
    }

    @PropertyDescription(name="DiffLocation")
    protected URI getDiffLocation() throws URISyntaxException {
        return this.createDiffLocation(this.revCommit.getName(), null, this.pattern);
    }

    @PropertyDescription(name="TreeLocation")
    private URI getTreeLocation() throws URISyntaxException {
        return this.createTreeLocation(null);
    }

    @PropertyDescription(name="Name")
    protected String getName() {
        return this.revCommit.getName();
    }

    @PropertyDescription(name="AuthorName")
    protected String getAuthorName() {
        PersonIdent author = this.revCommit.getAuthorIdent();
        return author.getName();
    }

    @PropertyDescription(name="AuthorEmail")
    protected String getAuthorEmail() {
        PersonIdent author = this.revCommit.getAuthorIdent();
        return author.getEmailAddress();
    }

    @PropertyDescription(name="AuthorImage")
    protected String getAuthorImage() {
        PersonIdent author = this.revCommit.getAuthorIdent();
        return UserUtilities.getImageLink((String)author.getEmailAddress());
    }

    @PropertyDescription(name="CommitterName")
    protected String getCommitterName() {
        PersonIdent committer = this.revCommit.getCommitterIdent();
        return committer.getName();
    }

    @PropertyDescription(name="CommitterEmail")
    protected String getCommitterEmail() {
        PersonIdent committer = this.revCommit.getCommitterIdent();
        return committer.getEmailAddress();
    }

    @PropertyDescription(name="Time")
    protected long getCommitTime() {
        return (long)this.revCommit.getCommitTime() * 1000L;
    }

    @PropertyDescription(name="Message")
    protected String getCommitMessiage() {
        return this.revCommit.getFullMessage();
    }

    @PropertyDescription(name="Tags")
    protected JSONArray getTags() throws MissingObjectException, JSONException, URISyntaxException, CoreException, IOException, GitAPIException {
        return this.toJSON(this.getTagsForCommit());
    }

    @PropertyDescription(name="Branches")
    protected JSONArray getBranches() throws JSONException, GitAPIException, URISyntaxException, IOException, CoreException {
        return this.getCommitToBranchMap().get(this.revCommit.getId());
    }

    @PropertyDescription(name="Parents")
    protected JSONArray getParents() throws JSONException, URISyntaxException, IOException, CoreException {
        return this.parentsToJSON(this.revCommit.getParents());
    }

    @PropertyDescription(name="Diffs")
    protected JSONObject getDiffs() throws JSONException, URISyntaxException, MissingObjectException, IncorrectObjectTypeException, IOException {
        JSONArray diffs = new JSONArray();
        JSONObject result = new JSONObject();
        TreeWalk tw = null;
        try {
            tw = new TreeWalk(this.db);
            tw.setRecursive(true);
            List l = null;
            String fromName = null;
            if (this.revCommit.getParentCount() > 0) {
                RevCommit parent = this.parseCommit(this.revCommit.getParent(0));
                tw.reset(new AnyObjectId[]{parent.getTree(), this.revCommit.getTree()});
                if (this.filter != null) {
                    tw.setFilter(this.filter);
                } else {
                    tw.setFilter(TreeFilter.ANY_DIFF);
                }
                l = DiffEntry.scan((TreeWalk)tw);
                fromName = this.revCommit.getParent(0).getName();
            } else {
                RevWalk rw = null;
                DiffFormatter diffFormat = null;
                try {
                    rw = new RevWalk(this.db);
                    diffFormat = new DiffFormatter((OutputStream)NullOutputStream.INSTANCE);
                    diffFormat.setRepository(this.db);
                    if (this.filter != null) {
                        diffFormat.setPathFilter(this.filter);
                    }
                    l = diffFormat.scan((AbstractTreeIterator)new EmptyTreeIterator(), (AbstractTreeIterator)new CanonicalTreeParser(null, rw.getObjectReader(), (AnyObjectId)this.revCommit.getTree()));
                }
                finally {
                    diffFormat.release();
                    rw.release();
                }
            }
            int pageSize = 100;
            int page = 1;
            int start = pageSize * (page - 1);
            int end = Math.min(pageSize + start, l.size());
            int i = start;
            i = start;
            while (i < end) {
                DiffEntry entr = (DiffEntry)l.get(i);
                JSONObject diff = new JSONObject();
                diff.put("Type", (Object)"Diff");
                diff.put("NewPath", (Object)entr.getNewPath());
                diff.put("OldPath", (Object)entr.getOldPath());
                diff.put("ChangeType", (Object)entr.getChangeType().toString());
                String path = entr.getChangeType() != DiffEntry.ChangeType.DELETE ? entr.getNewPath() : entr.getOldPath();
                diff.put("DiffLocation", (Object)this.createDiffLocation(this.revCommit.getName(), fromName, path));
                diff.put("ContentLocation", (Object)this.createContentLocation(entr, path));
                diff.put("TreeLocation", (Object)this.createTreeLocation(path));
                diffs.put((Object)diff);
                ++i;
            }
            result.put("Type", (Object)"Diff");
            result.put("Children", (Object)diffs);
            result.put("Length", l.size());
            if (i < l.size()) {
                URI diffLocation = this.createDiffLocation(this.revCommit.getName(), fromName, "");
                URI nextLocation = new URI(diffLocation.getScheme(), diffLocation.getUserInfo(), diffLocation.getHost(), diffLocation.getPort(), diffLocation.getPath(), "pageSize=" + pageSize + "&page=" + (page + 1), diffLocation.getFragment());
                result.put("NextLocation", (Object)nextLocation);
            }
        }
        finally {
            tw.release();
        }
        return result;
    }

    protected JSONArray toJSON(Map<String, Ref> revTags) throws JSONException, URISyntaxException, CoreException, IOException {
        JSONArray children = new JSONArray();
        for (Map.Entry<String, Ref> revTag : revTags.entrySet()) {
            Tag tag = new Tag(this.cloneLocation, this.db, revTag.getValue());
            children.put((Object)tag.toJSON());
        }
        return children;
    }

    @Override
    protected URI getLocation() throws URISyntaxException {
        return BaseToCommitConverter.getCommitLocation(this.cloneLocation, this.revCommit.getName(), this.pattern, BaseToCommitConverter.REMOVE_FIRST_2);
    }

    protected Map<String, Ref> getTagsForCommit() throws MissingObjectException, IOException, GitAPIException, JSONException, URISyntaxException, CoreException {
        Map<String, Ref> tags = this.getCommitToTagMap().get(this.revCommit.getId());
        if (tags == null) {
            tags = new HashMap<String, Ref>();
        }
        return tags;
    }

    protected URI createDiffLocation(String toRefId, String fromRefId, String path) throws URISyntaxException {
        IPath diffPath = new Path("/gitapi").append("diff");
        String diffRange = "";
        if (fromRefId != null) {
            diffRange = String.valueOf(fromRefId) + "..";
        }
        diffRange = String.valueOf(diffRange) + toRefId;
        diffPath = diffPath.append(diffRange);
        IPath clonePath = new Path(this.cloneLocation.getPath()).removeFirstSegments(2);
        if (path == null) {
            diffPath = diffPath.append(clonePath);
        } else if (this.isRoot) {
            diffPath = diffPath.append(clonePath).append(path);
        } else {
            IPath projectRoot = clonePath.uptoSegment(3);
            diffPath = diffPath.append(projectRoot).append(path);
        }
        return new URI(this.cloneLocation.getScheme(), this.cloneLocation.getAuthority(), diffPath.toString(), null, null);
    }

    protected URI createTreeLocation(String path) throws URISyntaxException {
        IPath clonePath = new Path(this.cloneLocation.getPath()).removeFirstSegments(2);
        IPath result = new Path("/gitapi").append("tree").append(clonePath).append(this.getName());
        if (path != null) {
            result = result.append(path);
        }
        return new URI(this.cloneLocation.getScheme(), this.cloneLocation.getUserInfo(), this.cloneLocation.getHost(), this.cloneLocation.getPort(), result.makeAbsolute().toString(), this.cloneLocation.getQuery(), this.cloneLocation.getFragment());
    }

    protected URI createContentLocation(DiffEntry entr, String path) throws URISyntaxException {
        IPath clonePath = new Path(this.cloneLocation.getPath()).removeFirstSegments(2);
        IPath result = path == null ? clonePath : (this.isRoot ? clonePath.append(path) : clonePath.uptoSegment(3).append(path));
        return new URI(this.cloneLocation.getScheme(), this.cloneLocation.getUserInfo(), this.cloneLocation.getHost(), this.cloneLocation.getPort(), result.makeAbsolute().toString(), this.cloneLocation.getQuery(), this.cloneLocation.getFragment());
    }

    protected JSONArray parentsToJSON(RevCommit[] revCommits) throws JSONException, IOException, URISyntaxException {
        JSONArray parents = new JSONArray();
        RevCommit[] revCommitArray = revCommits;
        int n = revCommits.length;
        int n2 = 0;
        while (n2 < n) {
            RevCommit revCommit = revCommitArray[n2];
            JSONObject parent = new JSONObject();
            parent.put("Name", (Object)revCommit.getName());
            parent.put("Location", (Object)BaseToCommitConverter.getCommitLocation(this.cloneLocation, revCommit.getName(), this.pattern, BaseToCommitConverter.REMOVE_FIRST_2));
            parents.put((Object)parent);
            ++n2;
        }
        return parents;
    }

    private RevCommit parseCommit(RevCommit revCommit) {
        RevWalk rw = null;
        try {
            rw = new RevWalk(this.db);
            RevCommit revCommit2 = rw.parseCommit((AnyObjectId)revCommit);
            return revCommit2;
        }
        catch (IOException iOException) {
            RevCommit revCommit3 = revCommit;
            return revCommit3;
        }
        finally {
            rw.release();
        }
    }
}

